/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.chart.DefaultXYInterpolatedChartDataset;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.XYChartSeries;
import org.broadinstitute.genee.chart.XYChartSeriesSupplier;
import org.broadinstitute.genee.chart.XYInterpolatedChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDatasetSupplier;
import org.broadinstitute.genee.heatmap.XYChartDatasetCollection;

public class DefaultXYChartDataset
implements XYChartDataset,
XYInterpolatedChartDatasetSupplier,
XYChartSeriesSupplier {
    protected List<XYChartSeries> seriesList = new ArrayList<XYChartSeries>();
    private float xMax = Float.NaN;
    private float xMin = Float.NaN;
    private float yMax = Float.NaN;
    private float yMin = Float.NaN;

    public DefaultXYChartDataset() {
    }

    public DefaultXYChartDataset(XYChartDatasetCollection chartDatasetCollection) {
    }

    public DefaultXYChartDataset(XYChartSeries series) {
        this.seriesList.add(series);
    }

    public void addSeries(XYChartSeries series) {
        this.seriesList.add(series);
    }

    public void clear() {
        this.seriesList.clear();
    }

    @Override
    public XYInterpolatedChartDataset createXYInterpolatedChartDataset(XYChartDataset dest) {
        return new DefaultXYInterpolatedChartDataset();
    }

    @Override
    public int getItemCount(int series) {
        return this.seriesList.get(series).getItemCount();
    }

    @Override
    public XYChartSeries getSeries(int seriesIndex) {
        return this.seriesList.get(seriesIndex);
    }

    @Override
    public int getSeriesCount() {
        return this.seriesList.size();
    }

    @Override
    public String getSeriesName(int series) {
        return this.seriesList.get(series).getName();
    }

    @Override
    public float getX(int series, int index) {
        return this.seriesList.get(series).getX(index);
    }

    @Override
    public float getXEnd(int series, int index) {
        return this.seriesList.get(series).getXEnd(index);
    }

    @Override
    public float getXMax() {
        if (!Float.isNaN(this.xMax)) {
            return this.xMax;
        }
        return DefaultXYChartDataset.getXMax(this.seriesList);
    }

    @Override
    public float getXMax(int series) {
        return this.seriesList.get(series).getXMax();
    }

    @Override
    public float getXMin() {
        if (!Float.isNaN(this.xMin)) {
            return this.xMin;
        }
        return DefaultXYChartDataset.getXMin(this.seriesList);
    }

    @Override
    public float getXMin(int series) {
        return this.seriesList.get(series).getXMin();
    }

    @Override
    public float getXStart(int series, int index) {
        return this.seriesList.get(series).getXStart(index);
    }

    public List<XYChartSeries> getXYChartSeries() {
        return this.seriesList;
    }

    @Override
    public float getY(int series, int index) {
        return this.seriesList.get(series).getY(index);
    }

    @Override
    public float getYEnd(int series, int index) {
        return this.seriesList.get(series).getYEnd(index);
    }

    @Override
    public float getYMax() {
        if (!Float.isNaN(this.yMax)) {
            return this.yMax;
        }
        return DefaultXYChartDataset.getYMax(this.seriesList);
    }

    @Override
    public float getYMax(int series) {
        return this.seriesList.get(series).getYMax();
    }

    @Override
    public float getYMin() {
        if (!Float.isNaN(this.yMin)) {
            return this.yMin;
        }
        return DefaultXYChartDataset.getYMin(this.seriesList);
    }

    @Override
    public float getYMin(int series) {
        return this.seriesList.get(series).getYMin();
    }

    @Override
    public float getYStart(int series, int index) {
        return this.seriesList.get(series).getYStart(index);
    }

    public void setXMax(float max) {
        this.xMax = max;
    }

    public void setXMin(float min) {
        this.xMin = min;
    }

    public void setYMax(float max) {
        this.yMax = max;
    }

    public void setYMin(float min) {
        this.yMin = min;
    }

    public static float getXMax(List<? extends XYChartSeries> seriesList) {
        float max = -3.4028235E38f;
        for (XYChartSeries xYChartSeries : seriesList) {
            float seriesMax = xYChartSeries.getXMax();
            if (Float.isNaN(seriesMax)) continue;
            max = Math.max(max, seriesMax);
        }
        return max;
    }

    public static float getXMin(List<? extends XYChartSeries> seriesList) {
        float min = Float.MAX_VALUE;
        for (XYChartSeries xYChartSeries : seriesList) {
            float seriesMin = xYChartSeries.getXMin();
            if (Float.isNaN(seriesMin)) continue;
            min = Math.min(min, seriesMin);
        }
        return min;
    }

    public static float getYMax(List<? extends XYChartSeries> seriesList) {
        float max = -3.4028235E38f;
        for (XYChartSeries xYChartSeries : seriesList) {
            float seriesMax = xYChartSeries.getYMax();
            if (Float.isNaN(seriesMax)) continue;
            max = Math.max(max, seriesMax);
        }
        return max;
    }

    public static float getYMin(List<? extends XYChartSeries> seriesList) {
        float min = Float.MAX_VALUE;
        for (XYChartSeries xYChartSeries : seriesList) {
            float seriesMin = xYChartSeries.getYMin();
            if (Float.isNaN(seriesMin)) continue;
            min = Math.min(min, seriesMin);
        }
        return min;
    }
}

