/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import gnu.trove.list.array.TFloatArrayList;
import org.broadinstitute.genee.chart.AbstractXYChartSeries;

public class DefaultXYChartSeries
extends AbstractXYChartSeries {
    protected TFloatArrayList xpoints;
    protected TFloatArrayList ypoints;

    public DefaultXYChartSeries(String seriesName, int size) {
        super(seriesName);
        this.xpoints = new TFloatArrayList(size);
        this.ypoints = new TFloatArrayList(size);
    }

    public void add(float x, float y) {
        if (!Float.isNaN(y)) {
            this.ymin = Math.min(this.ymin, y);
            this.ymax = Math.max(this.ymax, y);
        }
        if (!Float.isNaN(x)) {
            this.xmax = Math.max(this.xmax, x);
            this.xmin = Math.min(this.xmin, x);
        }
        this.xpoints.add(x);
        this.ypoints.add(y);
    }

    @Override
    public int getItemCount() {
        return this.ypoints.size();
    }

    public float getModelX(int index) {
        return this.xpoints.getQuick(index);
    }

    public float getModelY(int index) {
        return this.ypoints.getQuick(index);
    }

    @Override
    public float getX(int index) {
        return this.xpoints.getQuick(index);
    }

    @Override
    public float getY(int index) {
        return this.ypoints.getQuick(index);
    }

    @Override
    public float getYEnd(int index) {
        return this.getY(index);
    }

    @Override
    public float getYStart(int index) {
        return this.getY(index);
    }
}

