/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import org.broadinstitute.genee.chart.AbstractXYChartSeries;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.Vector;

public class ProfileChartSeries
extends AbstractXYChartSeries {
    private DatasetRowView rowView;
    private Vector xValueVector;

    public ProfileChartSeries(DatasetRowView rowView, Vector xValueVector, String seriesName) {
        super(seriesName);
        this.rowView = rowView;
        this.xValueVector = xValueVector;
        if (xValueVector == null) {
            this.xmax = this.getItemCount() - 1;
            this.xmin = 0.0f;
        } else {
            int size = xValueVector.size();
            for (int i = 0; i < size; ++i) {
                Number n = (Number)xValueVector.getValue(i);
                float value = n != null ? n.floatValue() : Float.NaN;
                this.xmin = Math.min(this.xmin, value);
                this.xmax = Math.max(this.xmax, value);
            }
        }
        this.ymin = FloatListStatUtils.min(rowView);
        this.ymax = FloatListStatUtils.max(rowView);
    }

    @Override
    public int getItemCount() {
        return this.rowView.size();
    }

    @Override
    public float getX(int index) {
        if (this.xValueVector != null) {
            Number n = (Number)this.xValueVector.getValue(index);
            return n != null ? n.floatValue() : Float.NaN;
        }
        return index;
    }

    @Override
    public float getY(int index) {
        return this.rowView.getValue(index);
    }
}

