/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.broadinstitute.genee.chart.AbstractChartRenderer;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.heatmap.CoordinateMapper;

public class RangeRenderer
extends AbstractChartRenderer {
    @Override
    public void paint(XYChartDataset chartDataset, int datasetIndex, Graphics2D g2, CoordinateMapper worldCoordinateMapper) {
        int count = chartDataset.getSeriesCount();
        for (int seriesIndex = 0; seriesIndex < count; ++seriesIndex) {
            this.paintRange(chartDataset, datasetIndex, seriesIndex, g2, worldCoordinateMapper);
        }
    }

    private void paintRange(XYChartDataset chartDataset, int datasetIndex, int seriesIndex, Graphics2D g2, CoordinateMapper worldCoordinateMapper) {
        Rectangle2D.Float rect = new Rectangle2D.Float();
        float xpixStart = 0.0f;
        g2.setColor(Color.LIGHT_GRAY);
        float xminPix = worldCoordinateMapper.xToPix(chartDataset.getXMin());
        float ytop = worldCoordinateMapper.yToPix(chartDataset.getYMin());
        float ybottom = worldCoordinateMapper.yToPix(chartDataset.getYMax());
        Line2D.Float line = new Line2D.Float(xminPix, ytop, xminPix, ybottom);
        g2.draw(line);
        float xmaxPix = worldCoordinateMapper.xToPix(chartDataset.getXMax());
        line.setLine(xmaxPix, ytop, xmaxPix, ybottom);
        g2.draw(line);
        int nitems = chartDataset.getItemCount(seriesIndex);
        for (int itemIndex = 0; itemIndex < nitems; ++itemIndex) {
            float length;
            float xpixEnd = worldCoordinateMapper.xToPix(chartDataset.getXEnd(seriesIndex, itemIndex));
            float barWidth = this.chartPropertiesSupplier.getBarSize(chartDataset, datasetIndex, seriesIndex, itemIndex);
            g2.setColor(this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex));
            xpixStart = worldCoordinateMapper.xToPix(chartDataset.getXStart(seriesIndex, itemIndex));
            if (xpixEnd < xpixStart) {
                length = xpixStart - xpixEnd;
                rect.setRect(xpixEnd, worldCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex)) - barWidth / 2.0f, length, barWidth);
            } else {
                length = xpixEnd - xpixStart;
                rect.setRect(xpixStart, worldCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex)) - barWidth / 2.0f, length, barWidth);
            }
            g2.fill(rect);
        }
    }
}

