/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import org.broadinstitute.genee.category.VectorShapeModel;
import org.broadinstitute.genee.category.VectorVisualMapper;
import org.broadinstitute.genee.chart.ColorSizeShapeAttribute;
import org.broadinstitute.genee.chart.ShapeByChartLegend;
import org.broadinstitute.genee.gui.Highlighter;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.matrix.Vector;

public abstract class ShapeBy
extends ColorSizeShapeAttribute {
    private Highlighter highlighter;
    private VectorShapeModel vectorShapeModel = new VectorShapeModel();

    public ShapeBy() {
        this.highlighter = new Highlighter(){

            @Override
            protected void notifyChanged() {
                ShapeBy.this.notifyHighlighterChanged();
            }
        };
        this.legend = new ShapeByChartLegend(this.highlighter);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public VectorVisualMapper getVectorShapeModel() {
        return this.vectorShapeModel;
    }

    @Override
    public void setVector(OrientedVector v) {
        this.vector = v;
        Vector vectorInSelectedIndicesSpace = this.getVectorInSelectedIndicesSpace(this.vector);
        this.vectorShapeModel.setVector(vectorInSelectedIndicesSpace);
        this.highlighter.clearHighlighted(false);
    }

    @Override
    public void updateLegend() {
        Vector vectorInSelectedIndicesSpace = this.getVectorInSelectedIndicesSpace(this.vector);
        if (vectorInSelectedIndicesSpace != null) {
            this.legend.setVectorVisualMapper(this.vectorShapeModel);
            this.legend.setVector(vectorInSelectedIndicesSpace);
        } else {
            this.legend.setVector(null);
        }
    }
}

