/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import com.jidesoft.combobox.ListExComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.gui.UIUtil;

public class ShapeComboBox
extends ListExComboBox {
    public ShapeComboBox() {
        DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>();
        model.addElement(0);
        model.addElement(1);
        model.addElement(2);
        model.addElement(3);
        model.addElement(4);
        model.addElement(5);
        model.addElement(6);
        this.setModel(model);
        this.setRenderer(new ShapeListCellRenderer());
    }

    public Shape getSelectedShape() {
        return ShapeUtil.getShape((Integer)this.getSelectedItem(), 12.0f);
    }

    public static class ShapeListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private Shape shape;

        public ShapeListCellRenderer() {
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.setOpaque(true);
            this.setSize(15, 15);
            this.setMinimumSize(new Dimension(15, 15));
            this.setPreferredSize(new Dimension(15, 15));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
            }
            this.shape = ShapeUtil.getShape((Integer)value, 12.0f);
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g.setColor(this.getForeground());
            if (this.shape != null) {
                g2.setRenderingHints(UIUtil.RENDERING_HINTS);
                g2.translate(1.5, 1.5);
                g2.draw(this.shape);
            }
        }
    }
}

