/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDatasetSupplier;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.movie.MovieFrame;
import org.broadinstitute.genee.movie.MovieGenerator;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class ChartGridMovieController {
    private GENEEChart[][] chartPanels;
    private List<XYChartDataset>[][] destinationChartDatasets;
    private ChartGrid chartGrid;
    private Animator animator;
    private int frameIndex = -1;
    private MovieFrame[] movieFrames;
    private TimingTarget internalTimingTarget;
    private MovieGenerator movieGenerator;
    private List<TimingTarget> timingTargets = new ArrayList<TimingTarget>();
    private int transitionTime = 1000;

    public ChartGridMovieController(final ChartGrid chartGrid) {
        this.chartGrid = chartGrid;
        this.internalTimingTarget = new TimingTarget(){

            @Override
            public void begin() {
                chartGrid.setAnimationRunning(true);
                this.repeat();
            }

            @Override
            public void end() {
                int nrows = ChartGridMovieController.this.chartPanels.length;
                for (int i = 0; i < nrows; ++i) {
                    int ncols = ChartGridMovieController.this.chartPanels[0].length;
                    for (int j = 0; j < ncols; ++j) {
                        ChartGridMovieController.this.chartPanels[i][j].setChartDatasets(ChartGridMovieController.this.destinationChartDatasets[i][j]);
                        ChartGridMovieController.this.chartPanels[i][j].setBackgroundText(null);
                    }
                }
                chartGrid.setXAxisScale();
                chartGrid.setYAxisScale();
                chartGrid.repaintCharts();
                chartGrid.setAnimationRunning(false);
            }

            @Override
            public void repeat() {
                if (ChartGridMovieController.this.chartPanels != null) {
                    int nrows = ChartGridMovieController.this.chartPanels.length;
                    for (int i = 0; i < nrows; ++i) {
                        int ncols = ChartGridMovieController.this.chartPanels[0].length;
                        for (int j = 0; j < ncols; ++j) {
                            ChartGridMovieController.this.chartPanels[i][j].setChartDatasets(ChartGridMovieController.this.destinationChartDatasets[i][j]);
                        }
                    }
                }
                ChartGridMovieController.this.setFrame(ChartGridMovieController.this.frameIndex + 1, true);
            }

            @Override
            public void timingEvent(float fraction) {
                int nrows = ChartGridMovieController.this.chartPanels.length;
                for (int i = 0; i < nrows; ++i) {
                    int ncols = ChartGridMovieController.this.chartPanels[0].length;
                    for (int j = 0; j < ncols; ++j) {
                        List<XYChartDataset> chartDatasets = ChartGridMovieController.this.chartPanels[i][j].getChartDatasets();
                        for (XYChartDataset chartDataset : chartDatasets) {
                            ((XYInterpolatedChartDataset)chartDataset).setFraction(fraction);
                        }
                    }
                }
                chartGrid.setXAxisScale();
                chartGrid.setYAxisScale();
                chartGrid.repaintCharts();
            }
        };
    }

    public void addTimingTarget(TimingTarget t) {
        this.timingTargets.add(t);
    }

    public ChartGrid getChartGrid() {
        return this.chartGrid;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public MovieFrame[] getMovieFrames() {
        return this.movieFrames == null ? new MovieFrame[]{} : this.movieFrames;
    }

    public int getNumberOfFrames() {
        return this.movieFrames.length;
    }

    public void goToFrame(int frameIndex) {
        this.stop();
        this.setFrame(frameIndex, false);
    }

    public boolean isRunning() {
        return this.animator != null ? this.animator.isRunning() : false;
    }

    public void reset() {
        this.stop();
        this.setMovieGenerator(this.movieGenerator);
    }

    public void setFrameIndex(int frameIndex) {
        this.frameIndex = frameIndex;
    }

    public int setMovieGenerator(MovieGenerator movieGenerator) {
        this.movieGenerator = movieGenerator;
        this.movieFrames = movieGenerator.generate(this.chartGrid.getProject());
        this.frameIndex = -1;
        return this.movieFrames.length;
    }

    public void setTransitionTime(int transitionTime) {
        this.transitionTime = transitionTime;
        if (this.animator != null) {
            this.animator.setDuration(transitionTime);
        }
    }

    public void start() {
        this.stop();
        if (this.frameIndex == this.movieFrames.length - 1) {
            this.frameIndex = -1;
        }
        this.animator = new Animator(this.transitionTime, Math.max(1, this.movieFrames.length - this.frameIndex - 1), Animator.RepeatBehavior.LOOP, this.internalTimingTarget);
        for (TimingTarget t : this.timingTargets) {
            this.animator.addTarget(t);
        }
        this.animator.start();
    }

    public void stop() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
    }

    private void setFrame(int frameIndex, boolean interpolateTo) {
        int j;
        int ncols;
        int i;
        if (frameIndex >= this.getNumberOfFrames()) {
            frameIndex = this.getNumberOfFrames() - 1;
        } else if (frameIndex < 0) {
            frameIndex = 0;
        }
        this.frameIndex = frameIndex;
        int[] modelRowIndices = this.movieFrames[frameIndex].getRowModelIndices();
        int[] modelColumnIndices = this.movieFrames[frameIndex].getColumnModelIndices();
        List<XYChartDataset>[][] sourceChartDatasets = this.destinationChartDatasets;
        this.chartGrid.updateCharts(this.movieFrames[frameIndex].getDataset(), modelRowIndices, modelColumnIndices, !interpolateTo, false);
        this.chartPanels = this.chartGrid.getChartPanels();
        this.destinationChartDatasets = new List[this.chartPanels.length][this.chartPanels[0].length];
        int nrows = this.chartPanels.length;
        for (i = 0; i < nrows; ++i) {
            ncols = this.chartPanels[0].length;
            for (j = 0; j < ncols; ++j) {
                this.destinationChartDatasets[i][j] = this.chartPanels[i][j].getChartDatasets();
            }
        }
        if (interpolateTo) {
            nrows = this.chartPanels.length;
            for (i = 0; i < nrows; ++i) {
                ncols = this.chartPanels[0].length;
                for (j = 0; j < ncols; ++j) {
                    List<XYChartDataset> originalChartDatasetsList = this.destinationChartDatasets[i][j];
                    ArrayList<XYInterpolatedChartDataset> interpolatedList = new ArrayList<XYInterpolatedChartDataset>();
                    int ndatasets = originalChartDatasetsList.size();
                    for (int k = 0; k < ndatasets; ++k) {
                        XYChartDataset dest;
                        XYChartDataset source = dest = originalChartDatasetsList.get(k);
                        if (sourceChartDatasets != null && i < sourceChartDatasets.length && j < sourceChartDatasets[0].length && k < sourceChartDatasets[i][j].size()) {
                            source = sourceChartDatasets[i][j].get(k);
                        }
                        XYInterpolatedChartDataset interpolatedChartDataset = ((XYInterpolatedChartDatasetSupplier)((Object)source)).createXYInterpolatedChartDataset(dest);
                        interpolatedChartDataset.setSource(source);
                        interpolatedChartDataset.setDestination(dest);
                        interpolatedList.add(interpolatedChartDataset);
                    }
                    this.chartPanels[i][j].setBackgroundText(this.movieFrames[frameIndex].getName());
                    this.chartPanels[i][j].setChartDatasets(interpolatedList);
                }
            }
        }
        if (this.movieGenerator.isByRow()) {
            this.chartGrid.getProject().setSelectedModelRowIndices(modelRowIndices);
        } else {
            this.chartGrid.getProject().setSelectedModelColumnIndices(modelColumnIndices);
        }
    }
}

