/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.chart.grid.ChartGridMovieController;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.ProgressPanel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.grid.AttributesDragAndDropComponent;
import org.broadinstitute.genee.gui.grid.DropListPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.movie.MovieFrame;
import org.broadinstitute.genee.movie.MovieGenerator;
import org.jdesktop.animation.timing.TimingTarget;

public class ChartMovieControlPanel
extends JPanel {
    private DropListPanel animateOver;
    private JButton generateAllImagesButton;
    private ChartGridMovieController movieController;
    private JButton playPauseButton;
    private ProgressPanel progressPanel;
    private JSlider animationSpeedSlider;
    private static final String ANIMATE_OVER_NAME = "Animate";
    private boolean animateOverChanged = false;
    private OrientedVector animateOverVector;

    public ChartMovieControlPanel(ChartGrid grid) {
        this.movieController = new ChartGridMovieController(grid);
        this.progressPanel = new ProgressPanel();
        this.animateOver = new DropListPanel(AttributesDragAndDropComponent.ACCEPT_DROP_TYPES, false, false, null, ANIMATE_OVER_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                List<Object> droppedData = ChartMovieControlPanel.this.animateOver.getDroppedData();
                if (droppedData.size() == 1) {
                    ChartMovieControlPanel.this.animateOverVector = (OrientedVector)droppedData.get(0);
                } else {
                    ChartMovieControlPanel.this.animateOverVector = null;
                }
                ChartMovieControlPanel.this.setEnabled();
                ChartMovieControlPanel.this.animateOverChanged = true;
            }
        };
        this.movieController.addTimingTarget(new TimingTarget(){

            @Override
            public void begin() {
                ChartMovieControlPanel.this.progressPanel.setValue(ChartMovieControlPanel.this.movieController.getFrameIndex());
            }

            @Override
            public void end() {
                ChartMovieControlPanel.this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11062.playblue_16.png"));
                ChartMovieControlPanel.this.animateOver.getComponent().setEnabled(true);
                ChartMovieControlPanel.this.generateAllImagesButton.setEnabled(true);
                ChartMovieControlPanel.this.animationSpeedSlider.setEnabled(true);
            }

            @Override
            public void repeat() {
            }

            @Override
            public void timingEvent(float fraction) {
                float value = (float)ChartMovieControlPanel.this.movieController.getFrameIndex() + fraction;
                ChartMovieControlPanel.this.progressPanel.setValue(value);
            }
        });
        this.generateAllImagesButton = new JButton("Create All Images");
        this.generateAllImagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final File directory = FileChooserUtil.showSelectDirectoryDialog(UIUtil.getCurrentFrame(), "Choose output directory");
                if (directory == null) {
                    return;
                }
                final MovieFrame[] movieFrames = ChartMovieControlPanel.this.movieController.getMovieFrames() == null ? new MovieFrame[]{} : ChartMovieControlPanel.this.movieController.getMovieFrames();
                final ChartGrid copy = ChartMovieControlPanel.this.movieController.getChartGrid().copy();
                final Pattern p = Pattern.compile(IOUtil.PROHIBITED_WINDOWS_FILE_NAME_PATTERN);
                new BackgroundTask<Void>("Creating Images"){

                    @Override
                    public Void doInBackground() throws Exception {
                        int length = movieFrames.length;
                        for (int frameIndex = 0; frameIndex < length; ++frameIndex) {
                            copy.updateCharts(movieFrames[frameIndex].getDataset(), movieFrames[frameIndex].getRowModelIndices(), movieFrames[frameIndex].getColumnModelIndices(), true, false);
                            String name = movieFrames[frameIndex].getName();
                            Matcher m = p.matcher(name);
                            name = m.replaceAll("_");
                            ImageUtil.saveImage(copy, "png", new File(directory, name), true);
                            if (frameIndex % 20 == 0) {
                                this.setMessage("Saving " + movieFrames[frameIndex].getName());
                            }
                            this.setPercentComplete((1.0f + (float)frameIndex) / (float)movieFrames.length);
                        }
                        return null;
                    }
                }.execute();
            }
        });
        this.playPauseButton = new JButton();
        this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11062.playblue_16.png"));
        this.playPauseButton.setPreferredSize(new Dimension(16, 16));
        this.playPauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartMovieControlPanel.this.toggleStopped();
            }
        });
        this.progressPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ChartMovieControlPanel.this.update(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.progressPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ChartMovieControlPanel.this.update(e);
            }
        });
        this.setLayout((LayoutManager)new FormLayout("p:g", "p, 6px, p, 6px, p, p:g"));
        CellConstraints cc = new CellConstraints();
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Animate over:");
        formBuilder.add(this.animateOver.getComponent());
        this.add((Component)formBuilder.getPanel(), cc.xy(1, 3));
        JPanel p = new JPanel((LayoutManager)new FormLayout("2px, left:p, 2px, p", "p, 2px, p"));
        p.add((Component)this.playPauseButton, cc.xy(2, 1));
        p.add((Component)this.progressPanel, cc.xy(4, 1));
        this.add((Component)p, cc.xy(1, 5));
        this.animationSpeedSlider = new JSlider(0, 1, 100, 50);
        this.animationSpeedSlider.setPaintLabels(true);
        this.animationSpeedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ChartMovieControlPanel.this.animationSpeedSlider.getValueIsAdjusting()) {
                    int value = ChartMovieControlPanel.this.animationSpeedSlider.getValue();
                    WorldCoordinateMapper mapper = new WorldCoordinateMapper();
                    mapper.setLeftGutter(1.0f);
                    mapper.setRightGutter(0.0f);
                    mapper.setXMax(100.0f);
                    mapper.setXMin(2000.0f);
                    mapper.setXPixelScale(100.0f);
                    int transitionTime = (int)mapper.pixToX(value);
                    ChartMovieControlPanel.this.movieController.setTransitionTime(transitionTime);
                }
            }
        });
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(this.animationSpeedSlider.getMinimum(), new JLabel("Slow"));
        labelTable.put(this.animationSpeedSlider.getMaximum(), new JLabel("Fast"));
        this.animationSpeedSlider.setLabelTable(labelTable);
        JPanel tmp = new JPanel((LayoutManager)new FormLayout("p, 6px, p, 12px, p", "p:g"));
        tmp.add((Component)this.animationSpeedSlider, cc.xy(3, 1));
        tmp.add((Component)this.generateAllImagesButton, cc.xy(5, 1));
        this.add((Component)tmp, cc.xy(1, 6));
        this.setEnabled();
    }

    public void reset() {
        this.movieController.reset();
        this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11062.playblue_16.png"));
        this.animateOver.getComponent().setEnabled(true);
        this.generateAllImagesButton.setEnabled(true);
        this.animationSpeedSlider.setEnabled(true);
        this.progressPanel.setValue(0.0f);
    }

    public void start() {
        this.setMovieFrames();
        this.animateOver.getComponent().setEnabled(false);
        this.generateAllImagesButton.setEnabled(false);
        this.animationSpeedSlider.setEnabled(false);
        this.movieController.start();
        this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11089.breakplayingblue_16.png"));
    }

    public void stop() {
        this.movieController.stop();
        this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11062.playblue_16.png"));
        this.animateOver.getComponent().setEnabled(true);
        this.generateAllImagesButton.setEnabled(true);
        this.animationSpeedSlider.setEnabled(true);
    }

    private void setEnabled() {
        boolean enabled = this.animateOverVector != null;
        this.generateAllImagesButton.setEnabled(enabled);
        this.playPauseButton.setEnabled(enabled);
        this.progressPanel.setEnabled(enabled);
        this.animationSpeedSlider.setEnabled(enabled);
    }

    private void setMovieFrames() {
        if (this.animateOverChanged) {
            int frames = this.movieController.setMovieGenerator(new GenerateByVector(this.animateOverVector));
            this.animateOverChanged = false;
            this.progressPanel.setMaxValue(frames - 1);
        }
    }

    private void toggleStopped() {
        if (this.movieController.isRunning()) {
            this.stop();
        } else {
            this.start();
        }
    }

    private void update(MouseEvent e) {
        if (this.progressPanel.isEnabled()) {
            this.stop();
            float frameIndex = this.progressPanel.getValue(e);
            int intFrame = Math.round(frameIndex);
            this.progressPanel.setValue(intFrame);
            this.movieController.goToFrame(intFrame);
        }
    }

    public static class GenerateByVector
    implements MovieGenerator {
        private OrientedVector vector;

        public GenerateByVector(OrientedVector v) {
            this.vector = v;
        }

        @Override
        public MovieFrame[] generate(Project project) {
            LinkedHashMap<Object, TIntArrayList> map = new LinkedHashMap<Object, TIntArrayList>();
            int n = this.vector.size();
            for (int i = 0; i < n; ++i) {
                Object value = this.vector.getValue(i);
                TIntArrayList list = (TIntArrayList)map.get(value);
                if (list == null) {
                    list = new TIntArrayList();
                    map.put(value, list);
                }
                list.add(i);
            }
            MovieFrame[] frames = new MovieFrame[map.values().size()];
            int frameIndex = 0;
            for (Object name : map.keySet()) {
                int[] columnIndices;
                int[] rowIndices;
                int[] frameIndices = ((TIntArrayList)map.get(name)).toArray();
                if (this.vector.isRowVector()) {
                    rowIndices = frameIndices;
                    columnIndices = project.getColumnSelectionModel().getSelectedModelIndices();
                } else {
                    columnIndices = frameIndices;
                    rowIndices = project.getRowSelectionModel().getSelectedModelIndices();
                }
                frames[frameIndex++] = new MovieFrame(Formatter.toString(name), project.getOriginalDataset(), rowIndices, columnIndices);
            }
            return frames;
        }

        @Override
        public boolean isByRow() {
            return this.vector.isRowVector();
        }

        public String toString() {
            return this.vector.toString();
        }
    }
}

