/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.chart.DefaultXYInterpolatedChartDataset;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDatasetSupplier;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class ChartTransition {
    private Animator animator;
    private ChartGrid chartGrid;
    private List<XYChartDataset>[][] chartDatasetsBeforeTransition;
    private int duration = 1000;

    public ChartTransition(ChartGrid chartGrid) {
        this.chartGrid = chartGrid;
    }

    public void saveTransitionFrom() {
        GENEEChart[][] chartPanels = this.chartGrid.getChartPanels();
        this.chartDatasetsBeforeTransition = new List[chartPanels.length][chartPanels[0].length];
        int nrows = chartPanels.length;
        for (int i = 0; i < nrows; ++i) {
            int ncols = chartPanels[0].length;
            for (int j = 0; j < ncols; ++j) {
                this.chartDatasetsBeforeTransition[i][j] = chartPanels[i][j].getChartDatasets();
            }
        }
    }

    public void transition() {
        GENEEChart[][] chartPanels = this.chartGrid.getChartPanels();
        int nrows = chartPanels.length;
        for (int i = 0; i < nrows; ++i) {
            int ncols = chartPanels[0].length;
            for (int j = 0; j < ncols; ++j) {
                List<XYChartDataset> destinationDatasetsList = chartPanels[i][j].getChartDatasets();
                ArrayList<XYInterpolatedChartDataset> interpolatedDatasets = new ArrayList<XYInterpolatedChartDataset>();
                int ndatasets = destinationDatasetsList.size();
                for (int datasetIndex = 0; datasetIndex < ndatasets; ++datasetIndex) {
                    XYChartDataset destinationDataset;
                    XYChartDataset source = destinationDataset = destinationDatasetsList.get(datasetIndex);
                    if (this.chartDatasetsBeforeTransition != null && i < this.chartDatasetsBeforeTransition.length && j < this.chartDatasetsBeforeTransition[0].length && datasetIndex < this.chartDatasetsBeforeTransition[i][j].size()) {
                        source = this.chartDatasetsBeforeTransition[i][j].get(datasetIndex);
                    }
                    XYInterpolatedChartDataset interpolatedChartDataset = source instanceof XYInterpolatedChartDatasetSupplier ? ((XYInterpolatedChartDatasetSupplier)((Object)source)).createXYInterpolatedChartDataset(destinationDataset) : new DefaultXYInterpolatedChartDataset();
                    interpolatedChartDataset.setSource(source);
                    interpolatedChartDataset.setDestination(destinationDataset);
                    interpolatedDatasets.add(interpolatedChartDataset);
                }
                chartPanels[i][j].setChartDatasets(interpolatedDatasets);
            }
        }
        this.run();
    }

    private void run() {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.animator = new Animator(this.duration, new TimingTarget(){

            @Override
            public void begin() {
                ChartTransition.this.chartGrid.setAnimationRunning(true);
            }

            @Override
            public void end() {
                int j;
                int ncols;
                int i;
                ChartTransition.this.chartGrid.setAnimationRunning(false);
                GENEEChart[][] chartPanels = ChartTransition.this.chartGrid.getChartPanels();
                int nrows = chartPanels.length;
                for (i = 0; i < nrows; ++i) {
                    ncols = chartPanels[0].length;
                    for (j = 0; j < ncols; ++j) {
                        ArrayList<XYChartDataset> destinationDatasetsList = new ArrayList<XYChartDataset>();
                        List<XYChartDataset> interpolatedDatasets = chartPanels[i][j].getChartDatasets();
                        int size = interpolatedDatasets.size();
                        for (int k = 0; k < size; ++k) {
                            XYChartDataset interpolatedDataset = interpolatedDatasets.get(k);
                            if (!(interpolatedDataset instanceof XYInterpolatedChartDataset)) {
                                System.err.println("Chart transition end error");
                            }
                            XYChartDataset destinationDataset = interpolatedDataset;
                            if (interpolatedDataset instanceof XYInterpolatedChartDataset && (destinationDataset = ((XYInterpolatedChartDataset)interpolatedDataset).getDestination()) instanceof XYInterpolatedChartDataset) {
                                System.err.println("Chart transition end error-end dataset is interpolated.");
                            }
                            destinationDatasetsList.add(destinationDataset);
                        }
                        chartPanels[i][j].setChartDatasets(destinationDatasetsList);
                    }
                }
                ChartTransition.this.chartGrid.setXAxisScale();
                ChartTransition.this.chartGrid.setYAxisScale();
                nrows = chartPanels.length;
                for (i = 0; i < nrows; ++i) {
                    ncols = chartPanels[0].length;
                    for (j = 0; j < ncols; ++j) {
                        chartPanels[i][j].invalidateImage();
                    }
                }
            }

            @Override
            public void repeat() {
            }

            @Override
            public void timingEvent(float f) {
                int j;
                int ncols;
                int i;
                GENEEChart[][] chartPanels = ChartTransition.this.chartGrid.getChartPanels();
                int nrows = chartPanels.length;
                for (i = 0; i < nrows; ++i) {
                    ncols = chartPanels[0].length;
                    for (j = 0; j < ncols; ++j) {
                        List<XYChartDataset> chartDatasets = chartPanels[i][j].getChartDatasets();
                        for (XYChartDataset chartDataset : chartDatasets) {
                            if (!(chartDataset instanceof XYInterpolatedChartDataset)) {
                                System.err.println("Chart transition timingEvent error");
                            }
                            if (!(chartDataset instanceof XYInterpolatedChartDataset)) continue;
                            ((XYInterpolatedChartDataset)chartDataset).setFraction(f);
                        }
                    }
                }
                ChartTransition.this.chartGrid.setUpdateDividerLocation(true);
                nrows = chartPanels.length;
                for (i = 0; i < nrows; ++i) {
                    ncols = chartPanels[0].length;
                    for (j = 0; j < ncols; ++j) {
                        chartPanels[i][j].invalidateImage();
                    }
                }
            }
        });
        this.animator.start();
    }
}

