/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import java.util.Arrays;
import java.util.List;
import org.broadinstitute.genee.chart.Axis;
import org.broadinstitute.genee.chart.BarRenderer;
import org.broadinstitute.genee.chart.ChartPropertiesSupplier;
import org.broadinstitute.genee.chart.ChartToolTipProvider;
import org.broadinstitute.genee.chart.DefaultHistogramChartSeries;
import org.broadinstitute.genee.chart.DefaultXYChartDataset;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.chart.grid.ConvertToChart;
import org.broadinstitute.genee.chart.grid.DatasetSplitter;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.OrientedVector;

public class ConvertToHistogramChart
implements ConvertToChart {
    private float xmin = Float.NaN;
    private float xmax = Float.NaN;
    private int numberOfBins = 100;
    public static final String NUMBER_OF_BINS_PROPERTY = "numberOfBins";
    private ChartGrid chartGrid;

    @Override
    public ConvertToChart copy() {
        ConvertToHistogramChart copy = new ConvertToHistogramChart();
        copy.numberOfBins = this.numberOfBins;
        return copy;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void customize(GENEEChart chartPanel, Dataset modelDataset, int[] gridRowIndices, int[] gridColumnIndices, int rowIndex, int columnIndex) {
        List<Dataset> datasets;
        BarRenderer renderer = new BarRenderer(true);
        this.chartGrid.setProperties(chartPanel, renderer);
        chartPanel.setChartRenderer(renderer);
        ChartPropertiesSupplier chartPropertiesSupplier = renderer.getChartPropertiesSupplier();
        if (this.chartGrid.getColorByVector() != null) {
            OrientedVector colorByVector = this.chartGrid.getColorByVector();
            DatasetSplitter splitter = new DatasetSplitter(colorByVector, modelDataset, gridRowIndices, gridColumnIndices, rowIndex, columnIndex, this.chartGrid);
            chartPropertiesSupplier.setColorByVector(splitter.getVector());
            chartPropertiesSupplier.setColorModel(this.chartGrid.getColorModel(colorByVector.isRowVector()));
            chartPropertiesSupplier.setColorBySeries(true);
            datasets = splitter.getDatasets();
        } else {
            chartPropertiesSupplier.setColorByVector(null);
            datasets = Arrays.asList(DatasetUtil.sliceView(modelDataset, gridRowIndices, gridColumnIndices));
        }
        float xmin = Float.MAX_VALUE;
        float xmax = -3.4028235E38f;
        for (Dataset d : datasets) {
            xmin = Math.min(xmin, DatasetUtil.min(d));
            xmax = Math.max(xmax, DatasetUtil.max(d));
        }
        DefaultXYChartDataset chartDataset = new DefaultXYChartDataset();
        for (Dataset d : datasets) {
            DefaultHistogramChartSeries series = DefaultHistogramChartSeries.createInstance(d, this.numberOfBins, xmin, xmax);
            chartDataset.addSeries(series);
        }
        if (this.chartGrid.getColorByVector() != null && chartDataset.getSeriesCount() > 0) {
            float ymax = -3.4028235E38f;
            int nitems = chartDataset.getSeries(0).getItemCount();
            for (int itemIndex = 0; itemIndex < nitems; ++itemIndex) {
                float sum = 0.0f;
                int nseries = chartDataset.getSeriesCount();
                for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                    float occurences = chartDataset.getY(seriesIndex, itemIndex);
                    sum += occurences;
                }
                ymax = Math.max(ymax, sum);
            }
            chartDataset.setYMax(ymax);
        }
        chartPanel.setChartDataset(chartDataset);
        renderer.setChartToolTipProvider(new ChartToolTipProvider(){

            @Override
            public String getToolTipText(XYChartDataset chartDataset, int seriesIndex, int itemIndex) {
                StringBuilder tooltip = new StringBuilder();
                tooltip.append(Formatter.format(chartDataset.getY(seriesIndex, itemIndex)));
                return tooltip.toString();
            }
        });
    }

    public int getNumberOfBins() {
        return this.numberOfBins;
    }

    public float getXMax() {
        return this.xmax;
    }

    public float getXMin() {
        return this.xmin;
    }

    @Override
    public void init(ChartGrid chartGrid) {
        this.chartGrid = chartGrid;
    }

    public void setNumberOfBins(int numberOfBins) {
        this.numberOfBins = numberOfBins;
    }

    public void setXMax(float xmax) {
        this.xmax = xmax;
    }

    public void setXMin(float xmin) {
        this.xmin = xmin;
    }

    @Override
    public void setProperty(String property, Object value) {
        if (NUMBER_OF_BINS_PROPERTY.equals(property)) {
            this.numberOfBins = (Integer)value;
        }
    }

    @Override
    public void customizeXAxis(Axis axis, GENEEChart[][] chartPanelMatrix, int columnINdex) {
        axis.setHorizontalLabelsRotated(false);
    }

    @Override
    public void customizeYAxis(Axis axis, GENEEChart[][] chartPanelMatrix, int rowIndex) {
        axis.setIntegerTicks(true);
    }

    @Override
    public boolean isXAxisVisible() {
        return true;
    }

    @Override
    public boolean isSizeBySupported() {
        return false;
    }

    @Override
    public boolean isShapeBySupported() {
        return false;
    }
}

