/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.broadinstitute.genee.io.matrix.gct.GctDatasetWriter13;
import org.broadinstitute.genee.io.matrix.gct.GctReader;
import org.broadinstitute.genee.io.util.StringConverter;
import org.broadinstitute.genee.matrix.Dataset;

public class GeneeClient {
    private String server;
    private int port;
    private String format = "gct";

    public GeneeClient() {
        this("localhost", 9998);
    }

    public GeneeClient(String server, int port) {
        this.server = server;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toGenee(Dataset dataset) throws IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpPost post = new HttpPost("http://" + this.server + ":" + this.port + "/api/to");
            final Dataset _dataset = dataset;
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart("fileData", (ContentBody)new AbstractContentBody(this.format){

                public String getFilename() {
                    return "fileData";
                }

                public void writeTo(OutputStream os) throws IOException {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
                    final NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    GctDatasetWriter13 writer = new GctDatasetWriter13(new StringConverter(){

                        @Override
                        public String toString(Object value) {
                            if (value instanceof Float) {
                                return nf.format(((Float)value).floatValue());
                            }
                            return String.valueOf(value);
                        }

                        @Override
                        public String format(float value) {
                            return nf.format(value);
                        }
                    });
                    writer.write(_dataset, pw);
                    pw.flush();
                }

                public String getCharset() {
                    return null;
                }

                public long getContentLength() {
                    return -1L;
                }

                public String getTransferEncoding() {
                    return "binary";
                }
            });
            reqEntity.addPart("fileType", (ContentBody)new StringBody(this.format));
            reqEntity.addPart("fileName", (ContentBody)new StringBody(dataset.getName()));
            post.setEntity((HttpEntity)reqEntity);
            HttpResponse response = httpclient.execute((HttpUriRequest)post);
            HttpEntity resEntity = response.getEntity();
            EntityUtils.consume((HttpEntity)resEntity);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset fromGenee() throws IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet get = new HttpGet("http://" + this.server + ":" + this.port + "/api/from?fileType=" + this.format);
            HttpResponse response = httpclient.execute((HttpUriRequest)get);
            HttpEntity resEntity = response.getEntity();
            Header name = response.getFirstHeader("filename");
            InputStream is = resEntity.getContent();
            GctReader reader = new GctReader();
            Dataset dataset = reader.read(name != null ? name.getValue() : "GENE-E", is);
            is.close();
            Dataset dataset2 = dataset;
            return dataset2;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
    }
}

