/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.CityBlock;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Correlation;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Euclidean;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Kendall;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Spearman;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.matrix.Dataset;
import org.tigr.util.FloatMatrix;

public class MevUtil {
    private static final List<BasicMapEntry<Integer>> ALL_METRICS = new ArrayList<BasicMapEntry<Integer>>();
    public static final BasicMapEntry<Integer> PEARSON = new BasicMapEntry<Integer>("Pearson correlation", 1);
    public static final BasicMapEntry<Integer> COSINE = new BasicMapEntry<Integer>("Cosine correlation", 2);
    public static final BasicMapEntry<Integer> COVARIANCE = new BasicMapEntry<Integer>("Covariance", 3);
    public static final BasicMapEntry<Integer> EUCLIDEAN = new BasicMapEntry<Integer>("Euclidean", 4);
    public static final BasicMapEntry<Integer> DOT_PRODUCT = new BasicMapEntry<Integer>("Dot product", 5);
    public static final BasicMapEntry<Integer> PEARSON_UNCENTERED = new BasicMapEntry<Integer>("Pearson uncentered", 6);
    public static final BasicMapEntry<Integer> PEARSON_SQUARED = new BasicMapEntry<Integer>("Pearson squared", 7);
    public static final BasicMapEntry<Integer> MANHATTAN = new BasicMapEntry<Integer>("Manhattan", 8);
    public static final BasicMapEntry<Integer> SPEARMAN_RANK = new BasicMapEntry<Integer>("Spearman rank", 9);
    public static final BasicMapEntry<Integer> KENDALLS_TAU = new BasicMapEntry<Integer>("Kendall's Tau", 10);
    public static final BasicMapEntry<Integer> MUTUAL_INFO = new BasicMapEntry<Integer>("Mutual information", 11);
    public static final BasicMapEntry<Integer>[] METRICS = new BasicMapEntry[5];

    public static final int getDistance(DistanceFunction f) {
        if (f instanceof Correlation) {
            return 1;
        }
        if (f instanceof Spearman) {
            return 9;
        }
        if (f instanceof Kendall) {
            return 10;
        }
        if (f instanceof Euclidean) {
            return 4;
        }
        if (f instanceof CityBlock) {
            return 8;
        }
        return -1;
    }

    public static FloatMatrix createFloatMatrix(Dataset dataset) {
        FloatMatrix matrix = new FloatMatrix(dataset.getRowCount(), dataset.getColumnCount());
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            for (int j = 0; j < dataset.getColumnCount(); ++j) {
                matrix.set(i, j, dataset.getValue(i, j));
            }
        }
        return matrix;
    }

    static {
        MevUtil.METRICS[0] = PEARSON;
        MevUtil.METRICS[1] = SPEARMAN_RANK;
        MevUtil.METRICS[2] = KENDALLS_TAU;
        MevUtil.METRICS[3] = EUCLIDEAN;
        MevUtil.METRICS[4] = MANHATTAN;
        ALL_METRICS.add(PEARSON);
        ALL_METRICS.add(COSINE);
        ALL_METRICS.add(COVARIANCE);
        ALL_METRICS.add(EUCLIDEAN);
        ALL_METRICS.add(DOT_PRODUCT);
        ALL_METRICS.add(PEARSON_UNCENTERED);
        ALL_METRICS.add(PEARSON_SQUARED);
        ALL_METRICS.add(MANHATTAN);
        ALL_METRICS.add(SPEARMAN_RANK);
        ALL_METRICS.add(KENDALLS_TAU);
        ALL_METRICS.add(MUTUAL_INFO);
    }
}

