/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.cc;

import org.broadinstitute.genee.clustering.MevUtil;
import org.broadinstitute.genee.clustering.cc.ClusteringAlgorithm;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.util.FloatMatrix;

public abstract class AbstractMevClusterer
implements ClusteringAlgorithm {
    protected int distanceFunction = MevUtil.EUCLIDEAN.getValue();
    protected int iterations = 2000;
    protected int k = 2;
    protected FloatMatrix matrix;
    protected NodeList nodeList;

    @Override
    public int[] getIndices(int clusterIndex) {
        return this.nodeList.getNode(clusterIndex).getFeaturesIndexes();
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.matrix = MevUtil.createFloatMatrix(dataset);
        this.nodeList = null;
    }

    @Override
    public void setDistanceFunction(DistanceFunction distanceFunction) {
        this.distanceFunction = MevUtil.getDistance(distanceFunction);
    }

    public void setDistanceFunction(int distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    @Override
    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void setNumberOfClusters(int k) {
        this.k = k;
    }
}

