/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.cc;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.broadinstitute.genee.clustering.cc.ClusteringAlgorithm;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.HCLClusterHelper;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Euclidean;
import org.broadinstitute.genee.matrix.Dataset;

public class HCLClusterer
implements ClusteringAlgorithm {
    private int[][] clusters;
    private Dataset dataset;
    private Dendrogram dendrogram;
    private DistanceFunction distanceFunction = new Euclidean();
    private int k;
    private LinkageMethod linkageMethod = LinkageMethod.AVERAGE_LINKAGE;

    public int[][] cut(int k) {
        return HCLClusterer.cut(this.dendrogram, k);
    }

    @Override
    public void execute() {
        if (this.dendrogram == null) {
            HCLClusterHelper helper = new HCLClusterHelper(this.dataset, this.distanceFunction, null, this.linkageMethod, null, null, null);
            this.dendrogram = helper.getRowDendrogram();
        }
        this.clusters = HCLClusterer.cut(this.dendrogram, this.k);
    }

    @Override
    public int[] getIndices(int clusterIndex) {
        return this.clusters[clusterIndex];
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dendrogram = null;
        this.dataset = dataset;
    }

    @Override
    public void setDistanceFunction(DistanceFunction distanceFunction) {
        this.dendrogram = null;
        this.distanceFunction = distanceFunction;
    }

    @Override
    public void setIterations(int iterations) {
    }

    public void setLinkageMethod(LinkageMethod linkageMethod) {
        this.dendrogram = null;
        this.linkageMethod = linkageMethod;
    }

    @Override
    public void setNumberOfClusters(int k) {
        this.k = k;
    }

    public static int[][] cut(Dendrogram d, int k) {
        if (d == null) {
            throw new NullPointerException("dendrogram is null");
        }
        LinkedList<Node> roots = new LinkedList<Node>(Arrays.asList(d.getRootNodes()));
        while (roots.size() < k) {
            Node bestSplit = null;
            float minSim = Float.POSITIVE_INFINITY;
            ListIterator iter = roots.listIterator();
            while (iter.hasNext()) {
                Node candidateSplit = (Node)iter.next();
                if (!(candidateSplit.getDistance() < minSim) || candidateSplit.isLeaf()) continue;
                minSim = candidateSplit.getDistance();
                bestSplit = candidateSplit;
            }
            roots.remove(roots.indexOf(bestSplit));
            roots.add(bestSplit.getLeft());
            roots.add(bestSplit.getRight());
        }
        Comparator<Node> cmp = new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return Float.compare(o1.getDistance(), o2.getDistance());
            }
        };
        if (roots.size() > 1) {
            Node[] tmp = roots.toArray(new Node[0]);
            Arrays.sort(tmp, cmp);
            roots = new LinkedList();
            int i = tmp.length - 1;
            while (i >= 0) {
                roots.add(tmp[i--]);
            }
        }
        int c = 0;
        int[][] clusters = new int[k][];
        ListIterator iter = roots.listIterator();
        while (iter.hasNext()) {
            TIntArrayList list = new TIntArrayList();
            Node node = (Node)iter.next();
            int minIndex = node.getMinIndex();
            int maxIndex = node.getMaxIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                list.add(i);
            }
            clusters[c] = list.toArray();
            ++c;
        }
        return clusters;
    }
}

