/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.JComponent;
import org.broadinstitute.genee.clustering.hierarchical.AbstractDendrogramPanel;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.heatmap.HeatMapElementPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.SizesAndPositions;

public class ColumnDendrogramPanel
extends AbstractDendrogramPanel {
    private JComponent widthComponent;

    public ColumnDendrogramPanel(Dendrogram dendrogram, SizesAndPositions sizeSequence, JComponent widthComponent) {
        this(dendrogram.getLeafNodes(), dendrogram.getRootNodes(), dendrogram.getLeafNodeIds(), dendrogram.getMinDistance(), dendrogram.getMaxDistance(), sizeSequence, widthComponent, dendrogram.getDistanceFunction(), dendrogram.getLinkageMethod());
    }

    public ColumnDendrogramPanel(Map<String, Node> leafNodes, Node[] rootNodes, String[] leafNodeIds, float minDistance, float maxDistance, SizesAndPositions sizesAndPositions, JComponent widthComponent, DistanceFunction distanceFunction, LinkageMethod linkageMethod) {
        super(leafNodes, rootNodes, leafNodeIds, sizesAndPositions, distanceFunction, linkageMethod);
        this.setMinMaxDistance(minDistance, maxDistance);
        this.coordinateMapper.setYMin(this.minDistance);
        this.coordinateMapper.setYMax(this.maxDistance);
        this.cutTreePosition = this.defaultCutTreePosition = this.coordinateMapper.getYMax();
        this.widthComponent = widthComponent;
    }

    @Override
    public void drawSingleNode(Graphics2D g2, Node node, int minIndex, int maxIndex) {
        float[] y;
        float[] x;
        Node left = node.getLeft();
        Node right = node.getRight();
        float ny = this.coordinateMapper.yToPix(node.distance);
        this.drawPieChart(g2, node, node.position, ny);
        g2.setColor(this.getNodeColor(node));
        float rx = right.position;
        float ry = this.coordinateMapper.yToPix(right.distance);
        float lx = left.position;
        float ly = this.coordinateMapper.yToPix(left.distance);
        if (!this.drawLeafNodes) {
            boolean leftIsLeaf = left.isLeaf();
            boolean rightIsLeaf = right.isLeaf();
            if (leftIsLeaf) {
                ly = ny + 4.0f;
            }
            if (rightIsLeaf) {
                ry = ny + 4.0f;
            }
            x = new float[]{rx, rx, lx, lx};
            y = new float[]{ry, ny, ny, ly};
        } else {
            x = new float[]{rx, rx, lx, lx};
            y = new float[]{ry, ny, ny, ly};
        }
        this.generalPath.reset();
        this.generalPath.moveTo(x[0], y[0]);
        for (int i = 0; i < x.length; ++i) {
            this.generalPath.lineTo(x[i], y[i]);
        }
        g2.draw(this.generalPath);
    }

    @Override
    public Dimension getDrawableSize() {
        Dimension d = this.getPreferredSize();
        d.height = this.isShowing() ? this.getVisibleRect().height : 150;
        return d;
    }

    @Override
    public void getNodePosition(Node node, Point2D.Float p) {
        float x = node.position;
        float y = this.coordinateMapper.yToPix(node.getDistance());
        p.x = x;
        p.y = y;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = this.widthComponent != null ? this.widthComponent.getPreferredSize().width : HeatMapPanel.getSize(this.sizesAndPositions);
        d.height = 150;
        return d;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.BLACK);
        Line2D.Float cutTreeSlider = new Line2D.Float();
        Stroke stroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{2.0f}, 0.0f));
        float ypix = this.coordinateMapper.yToPix(this.cutTreePosition);
        cutTreeSlider.setLine(0.0f, ypix, this.getWidth(), ypix);
        g2.draw(cutTreeSlider);
        g2.setStroke(stroke);
    }

    @Override
    public void setMax(float max) {
        this.coordinateMapper.setYMin(Float.isNaN(max) ? this.maxDistance : max);
    }

    @Override
    public void setMin(float min) {
        this.coordinateMapper.setYMax(Float.isNaN(min) ? this.minDistance : min);
    }

    @Override
    protected boolean containsCutTreeSlider(MouseEvent e) {
        return Math.abs((float)e.getY() - this.coordinateMapper.yToPix(this.cutTreePosition)) < 4.0f;
    }

    @Override
    protected void drawHoverNode(Graphics2D g2, Node node) {
        float ty = this.coordinateMapper.yToPix(node.distance);
        g2.setColor(this.getNodeColor(node));
        Node left = node.getLeft();
        Node right = node.getRight();
        float rx = 0.0f;
        float lx = 0.0f;
        if (right != null) {
            rx = right.position;
        }
        if (left != null) {
            lx = left.position;
        }
        Ellipse2D.Float ellipse = new Ellipse2D.Float();
        ellipse.setFrame((rx + lx) / 2.0f - 2.0f, ty - 2.0f, 4.0f, 4.0f);
        g2.draw(ellipse);
    }

    @Override
    protected int getMaxIndex(Rectangle rect) {
        return HeatMapElementPanel.getRight(this.leafNodeIds.length, rect, this.sizesAndPositions);
    }

    @Override
    protected int getMinIndex(Rectangle rect) {
        return HeatMapElementPanel.getLeft(rect, this.sizesAndPositions);
    }

    @Override
    protected Node getNode(MouseEvent e) {
        float x = e.getX();
        float y = e.getY();
        int leafIndex = this.sizesAndPositions.getIndex((int)x, true);
        if (leafIndex < 0 || leafIndex >= this.leafNodeIds.length) {
            return null;
        }
        String leafid = this.leafNodeIds[leafIndex];
        Point2D.Float p = new Point2D.Float();
        Node n = (Node)this.leafNodes.get(leafid);
        if (n != null) {
            while (!n.isRoot()) {
                Node parent = n.getParent();
                this.getNodePosition(parent, p);
                if (Math.abs(p.x - x) < 4.0f && Math.abs(p.y - y) < 4.0f) {
                    return parent;
                }
                n = parent;
            }
        }
        return null;
    }

    @Override
    protected boolean isShowingRows() {
        return false;
    }
}

