/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical;

import java.awt.Color;
import java.io.PrintStream;
import org.broadinstitute.genee.heatmap.SizesAndPositions;

public class Node {
    protected boolean collapsed = false;
    protected Color color;
    protected float distance = 0.0f;
    protected String id = null;
    protected float index;
    protected Node left = null;
    protected int maxIndex;
    protected int minIndex;
    protected Node parent = null;
    protected float position;
    protected Node right = null;
    protected boolean selected = false;
    private boolean cut = false;
    private boolean highlighted;
    private Color clusterColor;

    public Node(String id) {
        this.id = id;
    }

    public Node(String id, Node left, Node right, float correlation) {
        this.id = id;
        this.left = left;
        this.right = right;
        this.distance = correlation;
        this.setIndex();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            return ((Node)obj).id.equals(this.id);
        }
        return false;
    }

    public Color getColor() {
        return this.color;
    }

    public float getDistance() {
        return this.distance;
    }

    public String getId() {
        return this.id;
    }

    public float getIndex() {
        return this.index;
    }

    public Node getLeft() {
        if (this.isLeaf()) {
            return this;
        }
        return this.left;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public Node getParent() {
        if (this.isRoot()) {
            return this;
        }
        return this.parent;
    }

    public float getPosition() {
        return this.position;
    }

    public Node getRight() {
        if (this.isLeaf()) {
            return this;
        }
        return this.right;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isCut() {
        return this.cut;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public boolean isLeaf() {
        return this.collapsed || this.left == null && this.right == null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void printSubtree(PrintStream ps) {
        if (!this.isLeaf()) {
            ps.println(this.getId() + ", corr " + this.getDistance() + ", index " + this.getIndex() + " min " + this.minIndex + " max " + this.maxIndex);
            ps.print("Left: ");
            this.getLeft().printSubtree(ps);
            ps.print("Right: ");
            this.getRight().printSubtree(ps);
        } else {
            ps.println("LEAF " + this.getId() + " corr " + this.getDistance() + ", index " + this.getIndex());
        }
    }

    public void resetCut() {
        this.cut = false;
        this.clusterColor = null;
        this.color = null;
        if (this.left != null) {
            this.left.resetCut();
        }
        if (this.right != null) {
            this.right.resetCut();
        }
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setDistance(float corr) {
        this.distance = corr;
    }

    public void setCut(boolean cut, boolean recursive) {
        this.cut = cut;
        if (recursive) {
            if (this.left != null) {
                this.left.setCut(cut, recursive);
            }
            if (this.right != null) {
                this.right.setCut(cut, recursive);
            }
        }
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public void setId(String newid) {
        this.id = newid;
    }

    public void setIndex() {
        if (this.left != null && this.right != null) {
            this.index = (this.right.getIndex() + this.left.getIndex()) / 2.0f;
        }
    }

    public void setIndex(float number) {
        this.index = number;
    }

    public void setLeft(Node node) {
        this.left = node;
    }

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    public void setMinIndex(int minIndex) {
        this.minIndex = minIndex;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public void setRight(Node node) {
        this.right = node;
    }

    public void setRootColor(Color color) {
        this.color = color;
        if (this.left != null) {
            this.left.setRootColor(color);
        }
        if (this.right != null) {
            this.right.setRootColor(color);
        }
    }

    public void setSelected(boolean b) {
        this.selected = b;
        if (this.left != null) {
            this.left.setSelected(b);
        }
        if (this.right != null) {
            this.right.setSelected(b);
        }
    }

    public String toString() {
        return this.getId() + ", index " + this.getIndex() + ", " + this.cut;
    }

    void recomputeIndicesAndPosition(SizesAndPositions sizeSequence) {
        if (!this.isLeaf()) {
            this.left.recomputeIndicesAndPosition(sizeSequence);
            this.right.recomputeIndicesAndPosition(sizeSequence);
            this.setIndex();
            this.position = (int)Math.floor((double)(this.left.position + this.right.position) / 2.0);
            this.maxIndex = Math.max(this.left.maxIndex, this.right.maxIndex);
            this.minIndex = Math.min(this.left.minIndex, this.right.minIndex);
        } else {
            this.position = sizeSequence.getSize() / 2.0f + sizeSequence.getPosition((int)this.index);
        }
    }

    public Color getClusterColor() {
        return this.clusterColor;
    }

    public void setClusterColor(Color clusterColor) {
        this.clusterColor = clusterColor;
        if (this.left != null) {
            this.left.setClusterColor(clusterColor);
        }
        if (this.right != null) {
            this.right.setClusterColor(clusterColor);
        }
    }
}

