/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.JComponent;
import org.broadinstitute.genee.clustering.hierarchical.AbstractDendrogramPanel;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.heatmap.HeatMapElementPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.SizesAndPositions;

public class RowDendrogramPanel
extends AbstractDendrogramPanel {
    private JComponent heightComponent;

    public RowDendrogramPanel(Dendrogram dendrogram, SizesAndPositions sizeSequence, JComponent heightComponent) {
        this(dendrogram.getLeafNodes(), dendrogram.getRootNodes(), dendrogram.getLeafNodeIds(), dendrogram.getMinDistance(), dendrogram.getMaxDistance(), sizeSequence, heightComponent, dendrogram.getDistanceFunction(), dendrogram.getLinkageMethod());
    }

    public RowDendrogramPanel(Map<String, Node> leafNodes, Node[] rootNodes, String[] leafNodeIds, float minDistance, float maxDistance, SizesAndPositions sizesAndPositions, JComponent heightComponent, DistanceFunction distanceFunction, LinkageMethod linkageMethod) {
        super(leafNodes, rootNodes, leafNodeIds, sizesAndPositions, distanceFunction, linkageMethod);
        this.setMinMaxDistance(minDistance, maxDistance);
        this.coordinateMapper.setXMax(this.minDistance);
        this.coordinateMapper.setXMin(this.maxDistance);
        this.cutTreePosition = this.defaultCutTreePosition = this.maxDistance;
        this.heightComponent = heightComponent;
    }

    @Override
    public void drawSingleNode(Graphics2D g2, Node node, int top, int bottom) {
        float[] y;
        float[] x;
        Node left = node.getLeft();
        Node right = node.getRight();
        float ry = right.position;
        float rx = this.coordinateMapper.xToPix(right.distance);
        float ly = left.position;
        float lx = this.coordinateMapper.xToPix(left.distance);
        float nx = this.coordinateMapper.xToPix(node.distance);
        this.drawPieChart(g2, node, nx, node.position);
        g2.setColor(this.getNodeColor(node));
        this.generalPath.reset();
        if (!this.drawLeafNodes) {
            boolean leftIsLeaf = left.isLeaf();
            boolean rightIsLeaf = right.isLeaf();
            if (leftIsLeaf) {
                lx = nx + 4.0f;
            }
            if (rightIsLeaf) {
                rx = nx + 4.0f;
            }
            x = new float[]{rx, nx, nx, lx};
            y = new float[]{ry, ry, ly, ly};
        } else {
            x = new float[]{rx, nx, nx, lx};
            y = new float[]{ry, ry, ly, ly};
        }
        this.generalPath.moveTo(x[0], y[0]);
        for (int i = 0; i < x.length; ++i) {
            this.generalPath.lineTo(x[i], y[i]);
        }
        g2.draw(this.generalPath);
    }

    @Override
    public Dimension getDrawableSize() {
        Dimension d = this.getPreferredSize();
        d.width = this.isShowing() ? this.getVisibleRect().width : 150;
        return d;
    }

    @Override
    public void getNodePosition(Node node, Point2D.Float p) {
        float x = this.coordinateMapper.xToPix(node.distance);
        float y = node.position;
        p.x = x;
        p.y = y;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = 150;
        d.height = this.heightComponent != null ? this.heightComponent.getPreferredSize().height : HeatMapPanel.getSize(this.sizesAndPositions);
        return d;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isVisible()) {
            float xpix = this.coordinateMapper.xToPix(this.cutTreePosition);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.BLACK);
            Line2D.Float cutTreeSlider = new Line2D.Float();
            Stroke stroke = g2.getStroke();
            g2.setStroke(new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{2.0f}, 0.0f));
            cutTreeSlider.setLine(xpix, 0.0f, xpix, this.getPreferredSize().height);
            g2.draw(cutTreeSlider);
            g2.setStroke(stroke);
        }
    }

    @Override
    public void setMax(float max) {
        this.coordinateMapper.setXMax(Float.isNaN(max) ? this.maxDistance : max);
    }

    @Override
    public void setMin(float min) {
        this.coordinateMapper.setXMin(Float.isNaN(min) ? this.minDistance : min);
    }

    @Override
    protected boolean containsCutTreeSlider(MouseEvent e) {
        return Math.abs((float)e.getX() - this.coordinateMapper.xToPix(this.cutTreePosition)) < 4.0f;
    }

    @Override
    protected void drawHoverNode(Graphics2D g2, Node node) {
        Node left = node.getLeft();
        Node right = node.getRight();
        float ry = 0.0f;
        float ly = 0.0f;
        if (right != null) {
            ry = right.position;
        }
        if (left != null) {
            ly = left.position;
        }
        float tx = this.coordinateMapper.xToPix(node.distance);
        g2.setColor(this.getNodeColor(node));
        g2.draw(new Ellipse2D.Float(tx - 2.0f, (ry + ly) / 2.0f - 2.0f, 4.0f, 4.0f));
    }

    @Override
    protected int getMaxIndex(Rectangle rect) {
        return HeatMapElementPanel.getBottom(this.leafNodeIds.length, rect, this.sizesAndPositions);
    }

    @Override
    protected int getMinIndex(Rectangle rect) {
        return HeatMapElementPanel.getTop(this.leafNodeIds.length, rect, this.sizesAndPositions);
    }

    @Override
    protected Node getNode(MouseEvent mouseEvent) {
        float x = mouseEvent.getX();
        float y = mouseEvent.getY();
        int leafIndex = this.sizesAndPositions.getIndex((int)y, true);
        if (leafIndex < 0 || leafIndex >= this.leafNodeIds.length) {
            return null;
        }
        String leafid = this.leafNodeIds[leafIndex];
        Point2D.Float p = new Point2D.Float();
        Node n = (Node)this.leafNodes.get(leafid);
        if (n != null) {
            while (!n.isRoot()) {
                Node parent = n.getParent();
                this.getNodePosition(parent, p);
                if (Math.abs(p.x - x) <= 4.0f && Math.abs(p.y - y) <= 4.0f) {
                    return parent;
                }
                n = parent;
            }
        }
        return null;
    }

    @Override
    protected boolean isShowingRows() {
        return true;
    }
}

