/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm;

import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;

public class CdtWriter
implements ProjectWriter {
    static final String FORMAT_NAME = "cdt";

    @Override
    public String checkFileExtension(String filename) {
        if (!filename.toLowerCase().endsWith(".cdt")) {
            filename = filename + ".cdt";
        }
        return filename;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    @Override
    public void write(Project project, PrintWriter pw) throws IOException {
        int j;
        Dataset dataset = project.getSortedFilteredDataset();
        int arrayIdIndex = dataset.getColumnMetadata().getColumnIndex("array id");
        int geneIdIndex = dataset.getRowMetadata().getColumnIndex("gene id");
        if (geneIdIndex != -1) {
            pw.print("GID\t");
        }
        pw.print("ID\tNAME");
        int columns = dataset.getColumnCount();
        for (j = 0; j < columns; ++j) {
            pw.print("\t");
            pw.print(Formatter.toString(dataset.getColumnMetadata().get(0).getValue(j)));
        }
        pw.println();
        pw.print("AID\t\t");
        if (geneIdIndex != -1) {
            pw.print("\t");
        }
        if (arrayIdIndex != -1) {
            columns = dataset.getColumnCount();
            for (j = 1; j < columns; ++j) {
                if (j > 0) {
                    pw.print("\t");
                }
                pw.print(Formatter.toString(dataset.getColumnMetadata().get(j).getValue(arrayIdIndex)));
            }
        }
        pw.println();
        Vector descriptionVector = dataset.getRowMetadata().get("Description");
        if (descriptionVector == null && dataset.getRowMetadata().getMetadataCount() > 1) {
            descriptionVector = dataset.getRowMetadata().get(1);
        }
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            if (geneIdIndex != -1) {
                pw.print(dataset.getRowMetadata().getValue(i, geneIdIndex));
                pw.print("\t");
            }
            pw.print(Formatter.toString(dataset.getRowMetadata().get(0).getValue(i)));
            pw.print("\t");
            Object desc = null;
            if (descriptionVector != null) {
                desc = descriptionVector.getValue(i);
            }
            pw.print(Formatter.toString(desc));
            int columns2 = dataset.getColumnCount();
            for (int j2 = 0; j2 < columns2; ++j2) {
                pw.print("\t");
                float value = dataset.getValue(i, j2);
                pw.print(Float.isNaN(value) ? "" : Formatter.format(value));
            }
            pw.println();
        }
    }
}

