/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.linkage;

import java.util.Arrays;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.linkage.LinkageAlgorithm;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.linkage.NodeComparator;

public class SingleLinkage
implements LinkageAlgorithm {
    @Override
    public Node[] cluster(int nelements, float[][] distmatrix) {
        int k;
        int j;
        int i;
        int nnodes = nelements - 1;
        float[] temp = new float[nnodes];
        int[] index = new int[nelements];
        int[] vector = new int[nnodes];
        Node[] result = new Node[nelements];
        for (i = 0; i < nelements; ++i) {
            result[i] = new Node();
        }
        for (i = 0; i < nnodes; ++i) {
            vector[i] = i;
        }
        for (i = 0; i < nelements; ++i) {
            result[i].distance = Float.MAX_VALUE;
            for (j = 0; j < i; ++j) {
                temp[j] = distmatrix[i][j];
            }
            for (j = 0; j < i; ++j) {
                k = vector[j];
                if (result[j].distance >= temp[j]) {
                    if (result[j].distance < temp[k]) {
                        temp[k] = result[j].distance;
                    }
                    result[j].distance = temp[j];
                    vector[j] = i;
                    continue;
                }
                if (!(temp[j] < temp[k])) continue;
                temp[k] = temp[j];
            }
            for (j = 0; j < i; ++j) {
                if (!(result[j].distance >= result[vector[j]].distance)) continue;
                vector[j] = i;
            }
        }
        for (i = 0; i < nnodes; ++i) {
            result[i].left = i;
        }
        Arrays.sort(result, new NodeComparator());
        for (i = 0; i < nelements; ++i) {
            index[i] = i;
        }
        for (i = 0; i < nnodes; ++i) {
            j = result[i].left;
            k = vector[j];
            result[i].left = index[j];
            result[i].right = index[k];
            index[k] = -i - 1;
        }
        Node[] result2 = new Node[nelements - 1];
        for (i = 0; i < nelements - 1; ++i) {
            result2[i] = result[i];
        }
        return result2;
    }
}

