/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics;

import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;

public class Euclidean
implements DistanceFunction {
    @Override
    public float evaluate(Dataset data1, Dataset data2, float[] weight, int index1, int index2) {
        float result = 0.0f;
        float tweight = 0.0f;
        int n = data1.getColumnCount();
        for (int i = 0; i < n; ++i) {
            float term1 = data1.getValue(index1, i);
            float term2 = data2.getValue(index2, i);
            if (Float.isNaN(term1) || Float.isNaN(term2)) continue;
            float term = term1 - term2;
            result += weight[i] * term * term;
            tweight += weight[i];
        }
        if (tweight == 0.0f) {
            return 0.0f;
        }
        return result /= tweight;
    }

    public String toString() {
        return "Euclidean distance";
    }

    public boolean isScaleToOne() {
        return true;
    }
}

