/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.nmf;

import Jama.Matrix;
import java.util.Arrays;
import java.util.Random;

public class NMF {
    private Matrix h;
    private Matrix hcl;
    private int niter;
    private int r;
    private int stoppingCriterion;
    private Matrix v;
    private Matrix w;
    private Random random;

    public NMF(float[][] data, int numFactors, long seed) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.v = new Matrix(data);
        this.r = numFactors;
        this.niter = 2000;
        this.stoppingCriterion = 40;
        this.random = new Random(seed);
        this.w = this.random(this.v.getRowDimension(), this.r);
        this.h = this.random(this.r, this.v.getColumnDimension());
    }

    private Matrix random(int m, int n) {
        Matrix A = new Matrix(m, n);
        float[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = this.random.nextFloat();
            }
        }
        return A;
    }

    public void calcMetaGenesNewSamples(float[][] newData) {
        for (int i = 0; i < newData.length; ++i) {
            for (int j = 0; j < newData[i].length; ++j) {
                if (!(newData[i][j] <= 0.0f)) continue;
                System.out.println("calcMetaGenesNewSamples():At least one matrix entry less than or equal to zero: i= " + i + " j= " + j);
                System.exit(0);
            }
        }
        Matrix clData = new Matrix(newData);
        int wRank = this.w.rank();
        if (this.w.getRowDimension() != clData.getRowDimension()) {
            System.out.println("Matrix row dimensions don't agree: " + this.w.getRowDimension() + " != " + clData.getRowDimension());
            this.w.print(8, 3);
            clData.print(8, 3);
            System.exit(1);
        }
        this.hcl = wRank == this.r ? this.w.solve(clData) : new Matrix(this.r, clData.getColumnDimension(), 0.0f);
    }

    public float[][] getH() {
        return this.h.getArray();
    }

    public float[][] getHSolved() {
        return this.hcl.getArray();
    }

    public float[][] getW() {
        return this.w.getArray();
    }

    public float[] max(Matrix mat, int dir) {
        if (dir == 1) {
            mat = mat.transpose();
        }
        float[] maxFactor = new float[mat.getRowDimension()];
        for (int i = 0; i < mat.getRowDimension(); ++i) {
            int maxIndex = -1;
            maxFactor[i] = -10.0f;
            for (int k = 0; k < mat.getColumnDimension(); ++k) {
                if (!(mat.get(i, k) > maxFactor[i])) continue;
                maxFactor[i] = mat.get(i, k);
                maxIndex = k;
            }
        }
        if (dir == 1) {
            mat = mat.transpose();
        }
        return maxFactor;
    }

    public void runNMF(boolean byGene) {
        int inc = 0;
        float elmSum = 0.0f;
        Matrix hDenom = new Matrix(this.r, this.v.getColumnDimension());
        Matrix wDenom = new Matrix(this.v.getRowDimension(), this.r);
        int[] maxIndex = new int[byGene ? this.v.getRowDimension() : this.v.getColumnDimension()];
        int[] maxIndexOld = new int[maxIndex.length];
        for (int i = 0; i < this.niter; ++i) {
            int k;
            int l;
            this.h.arrayTimesEquals(this.w.transpose().times(this.v.arrayRightDivide(this.w.times(this.h))));
            for (l = 0; l < this.r; ++l) {
                elmSum = 0.0f;
                for (k = 0; k < this.w.getRowDimension(); ++k) {
                    elmSum += this.w.get(k, l);
                }
                for (k = 0; k < hDenom.getColumnDimension(); ++k) {
                    hDenom.set(l, k, elmSum);
                }
            }
            this.h.arrayRightDivideEquals(hDenom);
            this.w.arrayTimesEquals(this.v.arrayRightDivide(this.w.times(this.h)).times(this.h.transpose()));
            for (l = 0; l < this.r; ++l) {
                elmSum = 0.0f;
                for (k = 0; k < this.h.getColumnDimension(); ++k) {
                    elmSum += this.h.get(l, k);
                }
                for (k = 0; k < this.v.getRowDimension(); ++k) {
                    wDenom.set(k, l, elmSum);
                }
            }
            this.w.arrayRightDivideEquals(wDenom);
            if (i % 10 != 0) continue;
            int[] nArray = maxIndex = byGene ? this.whichMaxW(maxIndex) : this.whichMaxH(maxIndex);
            inc = Arrays.equals(maxIndex, maxIndexOld) ? ++inc : 0;
            if (inc > this.stoppingCriterion) break;
            int[] tmp = maxIndexOld;
            maxIndexOld = maxIndex;
            maxIndex = tmp;
        }
    }

    public void setHAndW(float[][] hArray, float[][] wArray) {
        this.h = new Matrix(hArray);
        this.w = new Matrix(wArray);
    }

    public void setMaxNumIter(int n) {
        this.niter = n;
    }

    public int[] whichMaxH() {
        int[] maxIndex = new int[this.h.getColumnDimension()];
        return this.whichMaxH(maxIndex);
    }

    public int[] whichMaxH(int[] maxIndex) {
        for (int i = 0; i < this.h.getColumnDimension(); ++i) {
            maxIndex[i] = -1;
            float maxFactor = Float.NEGATIVE_INFINITY;
            for (int j = 0; j < this.h.getRowDimension(); ++j) {
                if (!(this.h.get(j, i) > maxFactor)) continue;
                maxFactor = this.h.get(j, i);
                maxIndex[i] = j;
            }
        }
        return maxIndex;
    }

    public int[] whichMaxW() {
        int[] maxIndex = new int[this.w.getRowDimension()];
        return this.whichMaxW(maxIndex);
    }

    public int[] whichMaxW(int[] maxIndex) {
        for (int i = 0; i < this.w.getRowDimension(); ++i) {
            float maxFactor = -3.4028235E38f;
            for (int j = 0; j < this.w.getColumnDimension(); ++j) {
                float value = this.w.get(i, j);
                if (Float.isNaN(value) || !(value > maxFactor)) continue;
                maxFactor = value;
                maxIndex[i] = j;
            }
        }
        return maxIndex;
    }
}

