/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.chart.ShapeUtil;
import org.broadinstitute.genee.cmap.gui.PlateViewerArgs;
import org.broadinstitute.genee.cmap.gui.PlateViewerController;
import org.broadinstitute.genee.cmap.scripts.ScriptUtil;
import org.broadinstitute.genee.gui.AbstractLegend;
import org.broadinstitute.genee.gui.ColorByIcon;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.Highlighter;
import org.broadinstitute.genee.gui.ShapeIcon;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;

public class PlateViewer {
    private String colorSeriesName;
    private int colorSeriesIndex = -1;
    private Map<Object, Color> valueToColorMap;
    private String gridColorSeriesName;
    private int gridColorSeriesIndex = -1;
    private Map<Object, Color> gridValueToColorMap;
    private String textSeriesName;
    private String shapeSeriesName;
    private int shapeSeriesIndex = -1;
    private int textSeriesIndex = -1;
    private Map<Object, Shape> valueToShapeMap;
    private HeatMapPanel heatMapPanel;
    private AbstractLegend shapeLegend;
    private AbstractLegend colorLegend;
    private AbstractLegend gridColorLegend;
    public static final String GRID_COLOR_PROPERTY = "Grid Color";
    public static final String COLOR_PROPERTY = "Color";
    public static final String SHAPE_PROPERTY = "Shape";
    public static final String TEXT_PROPERTY = "Text";
    private JPanel legendPanel;
    private Highlighter colorHighlighter;
    private Highlighter gridColorHighlighter;
    private Highlighter shapeHighlighter;
    private Set<MatrixElement> matchingSearchElements;

    public PlateViewer() {
        this.init();
    }

    public String getColorSeriesName() {
        return this.colorSeriesName;
    }

    public String getDisplay(String property) {
        if (COLOR_PROPERTY.equals(property)) {
            return this.colorSeriesName;
        }
        if (SHAPE_PROPERTY.equals(property)) {
            return this.shapeSeriesName;
        }
        if (TEXT_PROPERTY.equals(property)) {
            return this.textSeriesName;
        }
        if (GRID_COLOR_PROPERTY.equals(property)) {
            return this.gridColorSeriesName;
        }
        return null;
    }

    public String getGridColorSeriesName() {
        return this.gridColorSeriesName;
    }

    public HeatMapPanel getHeatMapPanel() {
        return this.heatMapPanel;
    }

    public String getShapeSeriesName() {
        return this.shapeSeriesName;
    }

    public String getTextSeriesName() {
        return this.textSeriesName;
    }

    public void setColor(String seriesName, Map<Object, Color> map) {
        this.colorSeriesName = seriesName;
        this.valueToColorMap = map;
        if (this.colorSeriesName != null && this.valueToColorMap == null) {
            this.valueToColorMap = new HashMap<Object, Color>();
            int colorIndex = 0;
            Dataset dataset = this.heatMapPanel.getProject().getOriginalDataset();
            this.colorSeriesIndex = DatasetUtil.getSeriesIndex(dataset, seriesName);
            Color[] colors = QualitativeColorSchemes.TWENTY_COLORS;
            int nrows = dataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                int ncolumns = dataset.getColumnCount();
                for (int j = 0; j < ncolumns; ++j) {
                    Object value = dataset.getObjectValue(i, j, this.colorSeriesIndex);
                    if (value == null || this.valueToColorMap.containsKey(value)) continue;
                    this.valueToColorMap.put(value, colors[colorIndex % colors.length]);
                    ++colorIndex;
                }
            }
        }
        if (this.valueToColorMap == null) {
            this.valueToColorMap = new HashMap<Object, Color>();
        }
        this.colorLegend.setValues(this.valueToColorMap.keySet());
    }

    public void setDataset(Dataset dataset) {
        this.heatMapPanel.getProject().setDataset(dataset);
    }

    public void setDisplay(String property, String series) {
        if (COLOR_PROPERTY.equals(property)) {
            this.setColor(series, null);
        } else if (SHAPE_PROPERTY.equals(property)) {
            this.setShape(series, null);
        } else if (TEXT_PROPERTY.equals(property)) {
            this.setText(series);
        } else if (GRID_COLOR_PROPERTY.equals(property)) {
            this.setGridColor(series, null);
        }
    }

    public void setGridColor(String seriesName, Map<Object, Color> map) {
        this.gridColorSeriesName = seriesName;
        this.gridValueToColorMap = map;
        if (this.gridColorSeriesName != null && this.gridValueToColorMap == null) {
            this.gridValueToColorMap = new HashMap<Object, Color>();
            Dataset dataset = this.heatMapPanel.getProject().getOriginalDataset();
            this.gridColorSeriesIndex = DatasetUtil.getSeriesIndex(dataset, seriesName);
            Color[] colors = QualitativeColorSchemes.TWENTY_COLORS;
            int colorIndex = 0;
            int nrows = dataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                int ncolumns = dataset.getColumnCount();
                for (int j = 0; j < ncolumns; ++j) {
                    Object value = dataset.getObjectValue(i, j, this.gridColorSeriesIndex);
                    if (value == null || this.gridValueToColorMap.containsKey(value)) continue;
                    this.gridValueToColorMap.put(value, colors[colorIndex % colors.length]);
                    ++colorIndex;
                }
            }
        }
        if (this.gridValueToColorMap == null) {
            this.gridValueToColorMap = new HashMap<Object, Color>();
        }
        this.gridColorLegend.setValues(this.gridValueToColorMap.keySet());
    }

    public void setMatchingSearchElements(Set<MatrixElement> selectedElements) {
        this.matchingSearchElements = selectedElements;
    }

    public void setShape(String seriesName, Map<Object, Shape> map) {
        this.shapeSeriesName = seriesName;
        this.valueToShapeMap = map;
        if (this.shapeSeriesName != null && this.valueToShapeMap == null) {
            this.valueToShapeMap = new HashMap<Object, Shape>();
            int shapeIndex = 0;
            Dataset dataset = this.heatMapPanel.getProject().getOriginalDataset();
            this.shapeSeriesIndex = DatasetUtil.getSeriesIndex(dataset, seriesName);
            int nrows = dataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                int ncolumns = dataset.getColumnCount();
                for (int j = 0; j < ncolumns; ++j) {
                    String value = (String)dataset.getObjectValue(i, j, this.shapeSeriesIndex);
                    if (value == null || this.valueToShapeMap.containsKey(value)) continue;
                    this.valueToShapeMap.put(value, ShapeUtil.getShape(shapeIndex, 12.0f));
                    ++shapeIndex;
                }
            }
        }
        if (this.valueToShapeMap == null) {
            this.valueToShapeMap = new HashMap<Object, Shape>();
        }
        this.shapeLegend.setValues(this.valueToShapeMap.keySet());
    }

    public void setText(String seriesName) {
        this.textSeriesName = seriesName;
        Dataset dataset = this.heatMapPanel.getProject().getOriginalDataset();
        this.textSeriesIndex = DatasetUtil.getSeriesIndex(dataset, seriesName);
    }

    private void init() {
        this.heatMapPanel = new HeatMapPanel(new DefaultProject(new RowMajorArray2DDataset("", 0, 0)));
        this.heatMapPanel.setDrawGrid(false);
        this.colorHighlighter = new Highlighter(){

            @Override
            protected void notifyChanged() {
                PlateViewer.this.shapeHighlighter.clearHighlighted(false);
                PlateViewer.this.gridColorHighlighter.clearHighlighted(false);
                PlateViewer.this.shapeLegend.createLegend();
                PlateViewer.this.gridColorLegend.createLegend();
                PlateViewer.this.heatMapPanel.invalidateImage();
            }
        };
        this.gridColorHighlighter = new Highlighter(){

            @Override
            protected void notifyChanged() {
                PlateViewer.this.shapeHighlighter.clearHighlighted(false);
                PlateViewer.this.shapeLegend.createLegend();
                PlateViewer.this.colorHighlighter.clearHighlighted(false);
                PlateViewer.this.colorLegend.createLegend();
                PlateViewer.this.heatMapPanel.invalidateImage();
            }
        };
        this.shapeHighlighter = new Highlighter(){

            @Override
            protected void notifyChanged() {
                PlateViewer.this.colorHighlighter.clearHighlighted(false);
                PlateViewer.this.colorLegend.createLegend();
                PlateViewer.this.gridColorHighlighter.clearHighlighted(false);
                PlateViewer.this.gridColorLegend.createLegend();
                PlateViewer.this.heatMapPanel.invalidateImage();
            }
        };
        this.shapeLegend = new AbstractLegend(this.shapeHighlighter){

            @Override
            protected Icon createIcon(Object value) {
                Shape shape = (Shape)PlateViewer.this.valueToShapeMap.get(value);
                return new ShapeIcon(shape);
            }

            @Override
            protected void showEditDialog(Object value) {
            }
        };
        this.colorLegend = new AbstractLegend(this.colorHighlighter){

            @Override
            protected Icon createIcon(Object value) {
                Color c = (Color)PlateViewer.this.valueToColorMap.get(value);
                return new ColorByIcon(c);
            }

            @Override
            protected void showEditDialog(Object value) {
            }
        };
        this.gridColorLegend = new AbstractLegend(this.gridColorHighlighter){

            @Override
            protected Icon createIcon(Object value) {
                Color c = (Color)PlateViewer.this.gridValueToColorMap.get(value);
                return new ColorByIcon((Paint)c, false);
            }

            @Override
            protected void showEditDialog(Object value) {
            }
        };
        this.legendPanel = new JPanel((LayoutManager)new FormLayout("p:g, 2px, p:g", "p:g:top, p:g:top"));
        this.legendPanel.setBackground(Color.WHITE);
        CellConstraints cc = new CellConstraints();
        this.legendPanel.add((Component)this.colorLegend, cc.xy(1, 1));
        this.legendPanel.add((Component)this.shapeLegend, cc.xy(3, 1));
        this.legendPanel.add((Component)this.gridColorLegend, cc.xyw(1, 2, 3));
        this.heatMapPanel.setAboveRowTableCustomComponent(UIUtil.createNoBorderScrollPane(this.legendPanel));
        this.heatMapPanel.setSquareAspect(true);
        this.heatMapPanel.setRowPopupMenu(null);
        this.heatMapPanel.setColumnPopupMenu(null);
        if (this.heatMapPanel.getToolBar() != null) {
            this.heatMapPanel.getToolBar().setAnalysisToolsVisible(false);
        }
        this.heatMapPanel.setRowSize(50.0f);
        this.heatMapPanel.setColumnSize(50.0f);
        this.heatMapPanel.setElementPainter(new ElementPainter(){

            @Override
            public ElementPainter copy() {
                return this;
            }

            @Override
            public void draw(Graphics2D g, Dataset dataset, int row, int column, float xpix, float ypix, float columnSize, float rowSize) {
                Color gridColor;
                Object text;
                Shape shape;
                boolean highlighted;
                boolean filled;
                Object colorByVal = PlateViewer.this.colorSeriesIndex != -1 ? dataset.getObjectValue(row, column, PlateViewer.this.colorSeriesIndex) : null;
                Color c = PlateViewer.this.valueToColorMap != null ? (Color)PlateViewer.this.valueToColorMap.get(colorByVal) : null;
                boolean bl = filled = c == null;
                if (c == null) {
                    c = Color.GRAY;
                }
                Object shapeByValue = PlateViewer.this.shapeSeriesIndex != -1 ? dataset.getObjectValue(row, column, PlateViewer.this.shapeSeriesIndex) : null;
                Object gridColorByValue = PlateViewer.this.gridColorSeriesIndex != -1 ? dataset.getObjectValue(row, column, PlateViewer.this.gridColorSeriesIndex) : null;
                boolean bl2 = highlighted = PlateViewer.this.matchingSearchElements != null && PlateViewer.this.matchingSearchElements.contains(new MatrixElement(row, column));
                if (PlateViewer.this.matchingSearchElements == null) {
                    boolean bl3 = colorByVal == null ? false : (highlighted = !PlateViewer.this.colorHighlighter.isHighlightedEmpty() && PlateViewer.this.colorHighlighter.isHighlighted(colorByVal));
                    if (!highlighted && shapeByValue != null) {
                        boolean bl4 = highlighted = !PlateViewer.this.shapeHighlighter.isHighlightedEmpty() && PlateViewer.this.shapeHighlighter.isHighlighted(shapeByValue);
                    }
                    if (!highlighted && gridColorByValue != null) {
                        highlighted = !PlateViewer.this.gridColorHighlighter.isHighlightedEmpty() && PlateViewer.this.gridColorHighlighter.isHighlighted(gridColorByValue);
                    }
                }
                Shape shape2 = shape = PlateViewer.this.valueToShapeMap != null ? (Shape)PlateViewer.this.valueToShapeMap.get(shapeByValue) : null;
                if (shape == null) {
                    shape = ShapeUtil.getShape(1, rowSize);
                }
                Rectangle2D bounds = shape.getBounds2D();
                AffineTransform transform = AffineTransform.getTranslateInstance(xpix, ypix);
                transform.concatenate(AffineTransform.getScaleInstance((double)columnSize / bounds.getWidth(), (double)rowSize / bounds.getHeight()));
                Shape fillShape = transform.createTransformedShape(shape);
                g.setColor(c);
                g.fill(fillShape);
                if (shapeByValue != null && colorByVal == null) {
                    g.setColor(Color.BLACK);
                    g.draw(fillShape);
                }
                Object object = text = PlateViewer.this.textSeriesIndex != -1 ? dataset.getObjectValue(row, column, PlateViewer.this.textSeriesIndex) : null;
                if (text != null) {
                    g.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
                    g.setColor(Color.BLACK);
                    String s = Formatter.toString(text);
                    g.drawString(s, xpix, ypix + (float)UIUtil.DEFAULT_FONT_SIZE);
                }
                Color color = gridColor = PlateViewer.this.gridValueToColorMap != null ? (Color)PlateViewer.this.gridValueToColorMap.get(gridColorByValue) : null;
                if (gridColor == null) {
                    gridColor = Color.LIGHT_GRAY;
                }
                g.setColor(gridColor);
                Rectangle2D.Float outline = new Rectangle2D.Float(xpix, ypix, columnSize - 1.0f, rowSize - 1.0f);
                Stroke stroke = g.getStroke();
                g.draw(outline);
                g.setStroke(stroke);
                if (highlighted) {
                    g.setStroke(new BasicStroke(4.0f));
                    g.setColor(Color.BLACK);
                    int scale = 6;
                    transform = AffineTransform.getTranslateInstance(xpix + (float)(scale / 2), ypix + (float)(scale / 2));
                    transform.concatenate(AffineTransform.getScaleInstance((double)(columnSize - (float)scale) / bounds.getWidth(), (double)(rowSize - (float)scale) / bounds.getHeight()));
                    fillShape = transform.createTransformedShape(shape);
                    g.draw(fillShape);
                    g.setStroke(stroke);
                }
            }

            @Override
            public boolean setColorScheme(HeatMapColorScheme colorScheme) {
                return false;
            }

            @Override
            public void setProject(Project p) {
            }
        });
    }

    public static void main(String[] args) throws IOException {
        try {
            Cli cli = CliFactory.createCli(PlateViewerArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            PlateViewerArgs argsp = (PlateViewerArgs)cli.parseArguments(args);
            Drawable d = PlateViewer.run(argsp);
            File outputFile = argsp.isOutputFile() ? argsp.getOutputFile() : new File(ScriptUtil.getOutputDir(argsp), IOUtil.getBaseFileName(argsp.getMapFile()));
            ScriptUtil.createReport(outputFile, argsp);
            try {
                ImageUtil.saveImage(d, argsp.getOutputFileFormat(), outputFile, true);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    public static Drawable run(PlateViewerArgs argsp) {
        UIUtil.standaloneInit();
        String color = argsp.isColor() ? argsp.getColor() : null;
        String gridColor = argsp.isGridColor() ? argsp.getGridColor() : null;
        String shape = argsp.isShape() ? argsp.getShape() : null;
        String text = argsp.isText() ? argsp.getText() : null;
        HashSet<String> names = new HashSet<String>();
        String wellHeaderName = argsp.getWell();
        names.add(wellHeaderName);
        if (color != null) {
            names.add(color);
        }
        if (shape != null) {
            names.add(shape);
        }
        if (text != null) {
            names.add(text);
        }
        int nwells = argsp.getNumWells();
        int nrows = 16;
        int ncolumns = 24;
        if (nwells == 96) {
            nrows = 8;
            ncolumns = 12;
        } else if (nwells != 384) {
            System.err.println("Unsupported plate format. Supported formats are 384 and 96 wells.");
            System.exit(1);
        }
        PlateViewerController controller = null;
        try {
            if (!new File(argsp.getMapFile()).exists()) {
                System.err.println(argsp.getMapFile() + " not found.");
                System.exit(1);
            }
            controller = new PlateViewerController(argsp.getMapFile(), nrows, ncolumns);
        }
        catch (IOException e1) {
            System.err.println("An error occurred reading " + argsp.getMapFile() + ".");
            System.exit(1);
        }
        controller.setWell(argsp.getWell());
        if (color != null) {
            controller.setColor(color);
        }
        if (gridColor != null) {
            controller.setGridColor(gridColor);
        }
        if (shape != null) {
            controller.setShape(shape);
        }
        if (text != null) {
            controller.setText(text);
        }
        PlateViewer viewer = controller.getPlateViewer();
        viewer.getHeatMapPanel().setRowSize(argsp.getRowSize());
        viewer.getHeatMapPanel().setColumnSize(argsp.getColumnSize());
        return viewer.getHeatMapPanel();
    }
}

