/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.cmap.gui.PlateViewer;
import org.broadinstitute.genee.io.excel.ColumnMajorContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.PlateUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class PlateViewerController {
    public static final String WELL_PROPERTY = "Well";
    private List<String>[] columns;
    private HashMap<String, Integer> nameToIndex;
    private PlateViewer plateViewer;
    private List<MatrixElement>[] coordinates;
    private static String DEFAULT_COLOR = "pert_type";
    private static String DEFAULT_SHAPE = "pert_type";
    private static String DEFAULT_WELL = "det_well";
    private int nrows = 16;
    private int ncolumns = 24;
    private String wellSeriesName = DEFAULT_WELL;

    public PlateViewerController(String file) throws IOException {
        this(file, 16, 24);
    }

    public PlateViewerController(String file, int nrows, int ncolumns) throws IOException {
        this.nrows = nrows;
        this.ncolumns = ncolumns;
        ColumnMajorContentHandler handler = new ColumnMajorContentHandler();
        new ExcelReader(file, handler);
        this.columns = handler.getColumns();
        this.nameToIndex = new HashMap();
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i].size() <= 0) continue;
            this.nameToIndex.put(this.columns[i].get(0), i);
        }
        this.plateViewer = new PlateViewer();
    }

    public String getDisplay(String property) {
        if (property.equals(WELL_PROPERTY)) {
            return this.wellSeriesName;
        }
        return this.plateViewer.getDisplay(property);
    }

    public PlateViewer getPlateViewer() {
        return this.plateViewer;
    }

    public void reset() {
        this.setWell(DEFAULT_WELL);
        this.setColor(DEFAULT_COLOR);
        this.setShape(DEFAULT_SHAPE);
        this.setText(null);
        this.setGridColor(null);
        this.plateViewer.getHeatMapPanel().invalidateImage();
    }

    public void setColor(String name) {
        this.plateViewer.setColor(name, null);
    }

    public void setGridColor(String name) {
        this.plateViewer.setGridColor(name, null);
    }

    public void setDisplay(String property, String series) {
        if (WELL_PROPERTY.equals(property)) {
            this.setWell(series);
            this.plateViewer.setGridColor(this.plateViewer.getGridColorSeriesName(), null);
            this.plateViewer.setColor(this.plateViewer.getColorSeriesName(), null);
            this.plateViewer.setShape(this.plateViewer.getShapeSeriesName(), null);
            this.plateViewer.setText(this.plateViewer.getTextSeriesName());
        } else {
            this.plateViewer.setDisplay(property, series);
        }
    }

    public void setShape(String name) {
        this.plateViewer.setShape(name, null);
    }

    public void setText(String name) {
        this.plateViewer.setText(name);
    }

    public void setWell(String wellColumnName) {
        List<String> wellColumn = this.columns[this.nameToIndex.get(wellColumnName)];
        this.coordinates = new List[wellColumn.size() - 1];
        int length = wellColumn.size();
        for (int i = 1; i < length; ++i) {
            String[] wells;
            String wellString = wellColumn.get(i);
            this.coordinates[i - 1] = new ArrayList<MatrixElement>();
            if (wellString == null) continue;
            for (String well : wells = wellString.split(",")) {
                if ((well = well.trim()).equals("")) continue;
                well = PlateUtil.checkWellFormat(well);
                int row = PlateUtil.convertWellRowToInt(String.valueOf(well.charAt(0)));
                int column = ParserHelper.parseInt(well.substring(1)) - 1;
                this.coordinates[i - 1].add(new MatrixElement(row, column));
            }
        }
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("", this.nrows, this.ncolumns);
        Vector plateRowVector = MetadataUtil.addRowVector(dataset.getRowMetadata(), "", String.class);
        int nrows = dataset.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            plateRowVector.setValue(i, PlateUtil.convertRowIndexToString(i));
        }
        Vector plateColumnVector = MetadataUtil.addRowVector(dataset.getColumnMetadata(), "plate column", Integer.class);
        int ncols = dataset.getColumnCount();
        for (int j = 0; j < ncols; ++j) {
            plateColumnVector.setValue(j, j + 1);
        }
        PlateViewerController.addSeries(dataset, this.columns, this.coordinates);
        this.plateViewer.setDataset(dataset);
    }

    private static void addSeries(RowMajorArray2DDataset dataset, List<String>[] columns, List<MatrixElement>[] coordinates) {
        for (List<String> values : columns) {
            int series = dataset.addSeries(values.get(0), String.class);
            int length = values.size();
            for (int i = 1; i < length; ++i) {
                String val = values.get(i);
                List<MatrixElement> c = coordinates[i - 1];
                for (MatrixElement p : c) {
                    int row = p.getRow();
                    int column = p.getColumn();
                    dataset.setObjectValue(row, column, val, series);
                }
            }
        }
    }
}

