/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import java.util.HashSet;
import java.util.Set;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.matrix.Vector;

public class ATCCodeIndexedFilter
implements IndexedFilter {
    private static final int ATC_CODE_LENGTH = "A10BA02".length();
    private Set<String> codes;
    private Set<String> comparisonStrings;
    private int level = 5;
    private Vector atcCodeValueProvider;

    public ATCCodeIndexedFilter(Set<String> atcCode, int level) {
        this.codes = atcCode;
        this.level = level;
        this.comparisonStrings = new HashSet<String>();
        for (String code : this.codes) {
            String comparisonString = level != -1 ? ATCCodeIndexedFilter.getComparisonString(code, level) : null;
            if (comparisonString == null) continue;
            this.comparisonStrings.add(comparisonString);
        }
    }

    private static String getComparisonString(String code, int level) {
        String comparisonString;
        if (code == null || code.length() != ATC_CODE_LENGTH) {
            return null;
        }
        if (level == 1) {
            comparisonString = code.substring(0, 1);
        } else if (level == 2) {
            comparisonString = code.substring(0, 3);
        } else if (level == 3) {
            comparisonString = code.substring(0, 4);
        } else if (level == 4) {
            comparisonString = code.substring(0, 5);
        } else if (level == 5) {
            comparisonString = code;
        } else {
            throw new IllegalArgumentException();
        }
        return comparisonString;
    }

    @Override
    public void setValueProvider(Vector atcCodeValueProvider) {
        this.atcCodeValueProvider = atcCodeValueProvider;
    }

    @Override
    public boolean accept(int index) {
        String atcCodes = (String)this.atcCodeValueProvider.getValue(index);
        if (atcCodes != null && atcCodes.length() > 0) {
            String[] codes;
            for (String atc : codes = atcCodes.split(" ")) {
                if (!this.comparisonStrings.contains(ATCCodeIndexedFilter.getComparisonString(atc, this.level))) continue;
                return true;
            }
        }
        return false;
    }
}

