/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.broadinstitute.genee.cmap.rankedlist.ATCCodeIndexedFilter;
import org.broadinstitute.genee.filter.FilterSelectionComponent;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;

public class ATCRankedListFilterUI
implements FilterUI {
    private int level;
    private JPanel p;
    private Set selection;
    private FilterSelectionComponent selectionPanel;
    private JComboBox levelComboBox;

    public ATCRankedListFilterUI(Set<String> values) {
        this.selectionPanel = new FilterSelectionComponent(values){

            @Override
            protected Object parseTextAreaLine(String token) {
                return token;
            }
        };
        String[] levels = new String[]{"(anatomical main group)", "(therapeutic subgroup)", "(pharmacological subgroup)", "(chemical subgroup)", "(chemical substance)"};
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Level:");
        this.levelComboBox = UIUtil.createComboBox();
        formBuilder.add(this.levelComboBox);
        for (int i = 1; i < 6; ++i) {
            String name = "Level " + i + " " + levels[i - 1];
            this.levelComboBox.addItem(name);
        }
        this.levelComboBox.setSelectedIndex(0);
        this.p = new JPanel((LayoutManager)new FormLayout("p:g", "p:g, p:g"));
        CellConstraints cc = new CellConstraints();
        this.p.add((Component)this.selectionPanel.getComponent(), cc.xy(1, 1));
        this.p.add((Component)formBuilder.getPanel(), cc.xy(1, 2));
        this.level = 1;
        this.selection = this.selectionPanel.getSelectedItems();
    }

    @Override
    public IndexedFilter apply() {
        this.selectionPanel.saveState();
        this.selection = this.selectionPanel.getSelectedItems();
        this.level = 1 + this.levelComboBox.getSelectedIndex();
        return new ATCCodeIndexedFilter(this.selection, this.level);
    }

    @Override
    public void cancel() {
        this.levelComboBox.setSelectedIndex(this.level - 1);
        this.selectionPanel.restoreState();
    }

    @Override
    public String getFilterName() {
        return "ATC Code";
    }

    @Override
    public Component getUserInterfaceComponent() {
        return this.p;
    }
}

