/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackEvent;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackListener;
import org.broadinstitute.genee.cmap.rankedlist.IdSupplier;
import org.broadinstitute.genee.gui.ColorByIcon;
import org.broadinstitute.genee.gui.JLabelFaded;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeLegend;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class ColorByLegend
extends JPanel {
    private CellConstraints cc;
    private FormLayout formLayout;
    private HighlightTrack highlightTrack;

    public ColorByLegend(final HighlightTrack highlightTrack) {
        this.highlightTrack = highlightTrack;
        this.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
        this.setBackground(Color.WHITE);
        this.formLayout = new FormLayout("p", "");
        this.setLayout((LayoutManager)this.formLayout);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.cc = new CellConstraints();
        highlightTrack.addHighlightTrackListener(new HighlightTrackListener(){

            @Override
            public void trackChanged(HighlightTrackEvent e) {
                ColorByLegend.this.formLayout = new FormLayout("p", "");
                ColorByLegend.this.setLayout((LayoutManager)ColorByLegend.this.formLayout);
                ColorByLegend.this.removeAll();
                ColorByLegend.this.setVisible(highlightTrack.getColorBy() != null && !highlightTrack.isEmpty());
                if (highlightTrack.getColorBy() != null && !highlightTrack.isEmpty()) {
                    JLabel label = new JLabel(highlightTrack.getColorBy().getName());
                    label.setFont(label.getFont().deriveFont(1));
                    ColorByLegend.this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
                    ColorByLegend.this.add((Component)label, ColorByLegend.this.cc.xy(1, ColorByLegend.this.formLayout.getRowCount()));
                    ColorByLegend.this.formLayout.appendRow(UIUtil.decodeRowSpec("6px"));
                    ColorByLegend.this.createColorLegend();
                }
                ColorByLegend.this.revalidate();
                ColorByLegend.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                highlightTrack.clearHighlightedColors();
            }
        });
        this.setVisible(false);
        this.setMinimumSize(new Dimension());
    }

    private void createColorLegend() {
        boolean highlightedColorsEmpty = this.highlightTrack.isHighlightedColorsEmpty();
        IdSupplier colorByVector = this.highlightTrack.getColorBy();
        if (MetadataUtil.getBoolean(colorByVector, "Discrete Key")) {
            boolean first = true;
            Collection<Object> ids = this.highlightTrack.getAllInstanceIds();
            HashSet<Object> values = new HashSet<Object>();
            for (Object id : ids) {
                Object value = colorByVector.get(id);
                if (values.contains(value)) continue;
                values.add(value);
                boolean faded = !highlightedColorsEmpty && !this.highlightTrack.isColorHighlighted(value);
                boolean highlighted = !highlightedColorsEmpty && this.highlightTrack.isColorHighlighted(value);
                JLabel label = this.createLabel(faded, highlighted, value);
                label.setIcon(new ColorByIcon((Paint)this.highlightTrack.getColorModel().getMappedValue(colorByVector, value)));
                if (!first) {
                    this.formLayout.appendRow(UIUtil.decodeRowSpec("4px"));
                }
                this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
                this.add((Component)label, this.cc.xy(1, this.formLayout.getRowCount()));
                first = false;
            }
        } else {
            HeatMapColorScheme colorScheme = this.highlightTrack.getColorModel().getContinuousColorScheme(colorByVector);
            HeatMapColorSchemeLegend legend = (HeatMapColorSchemeLegend)colorScheme.getLegend();
            legend.setPreferredSize(new Dimension(200, 100));
            legend.setMinimumSize(new Dimension());
            legend.setScalingStringVisible(false);
            this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
            this.add((Component)legend, this.cc.xy(1, this.formLayout.getRowCount()));
        }
    }

    private JLabel createLabel(boolean faded, final boolean bolded, final Object value) {
        JLabel label = null;
        label = faded ? new JLabelFaded(true) : new JLabel();
        if (value != null) {
            label.setText(Formatter.toString(value));
        }
        if (bolded) {
            label.setFont(label.getFont().deriveFont(1));
        }
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean additional = e.isShiftDown();
                if (!bolded) {
                    ColorByLegend.this.highlightTrack.addHighlightedColor(value, !additional);
                } else if (!additional) {
                    ColorByLegend.this.highlightTrack.clearHighlightedColors();
                } else {
                    ColorByLegend.this.highlightTrack.removeHighlightedColor(value);
                }
            }
        });
        return label;
    }
}

