/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import com.google.common.collect.Sets;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.broadinstitute.genee.application.UniqueEventListenerList;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackEvent;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackListener;
import org.broadinstitute.genee.cmap.rankedlist.IdSupplier;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollection;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollectionEvent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollectionListener;
import org.broadinstitute.genee.gui.CartesianProduct;
import org.broadinstitute.genee.gui.Combination;
import org.broadinstitute.genee.gui.TextSpanPair;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class HighlightTrack
implements CartesianProduct {
    private IdSupplier colorBy = null;
    private float defaultLineWidth = 30.0f;
    private IdSupplier[] groupColumnsBy;
    private IdSupplier[] groupRowsBy;
    private Set<Object> highlightedIds = new HashSet<Object>();
    private Set<Object> highlightedColors = new HashSet<Object>();
    private Set<Object> highlightedSizes = new HashSet<Object>();
    private List<Object>[][] instanceMatrix;
    private UniqueEventListenerList listenerList = new UniqueEventListenerList();
    private float maxSize = 70.0f;
    private float minSize = 16.0f;
    private RankedListFilterCollection rankedListFilterCollection;
    private IdSupplier sizeBy;
    private boolean sizeByContinuous;
    private Color inactiveColor = new Color(205, 207, 205);
    private Map<Object, Float> valueToSize = new TreeMap<Object, Float>();
    private Set<Object> animationFrameInstanceIds;
    private List<TextSpanPair>[] rowTextSpanPairs;
    private List<TextSpanPair>[] columnTextSpanPairs;
    private Color defaultColor = Color.BLACK;
    private VectorColorModel colorModel;
    private RankedList referenceRankedList;

    public HighlightTrack(RankedListFilterCollection rankedListFilterCollection, VectorColorModel colorModel) {
        this.rankedListFilterCollection = rankedListFilterCollection;
        this.colorModel = colorModel;
        rankedListFilterCollection.addRankedListFilterListener(new RankedListFilterCollectionListener(){

            @Override
            public void filterChanged(RankedListFilterCollectionEvent e) {
                HighlightTrack.this.setColorBy(HighlightTrack.this.colorBy, false);
                HighlightTrack.this.setSizeBy(HighlightTrack.this.sizeBy, HighlightTrack.this.sizeByContinuous, false);
                HighlightTrack.this.setGroupBy(HighlightTrack.this.groupRowsBy, HighlightTrack.this.groupColumnsBy, false);
                HighlightTrack.this.placeActiveInstancesLast();
                HighlightTrack.this.notifyListeners();
            }
        });
    }

    public void addHighlightedColor(Object value, boolean clear) {
        if (clear) {
            this.highlightedColors.clear();
        }
        this.highlightedColors.add(value);
        this.highlightedSizes.clear();
        this.highlightedIds.clear();
        this.placeActiveInstancesLast();
        this.notifyListeners();
    }

    public void addHighlightedIds(Collection<Object> ids, boolean clear) {
        if (clear) {
            this.highlightedIds.clear();
        }
        this.highlightedIds.addAll(ids);
        this.highlightedColors.clear();
        this.highlightedSizes.clear();
        this.placeActiveInstancesLast();
        this.notifyListeners();
    }

    public void addHighlightedSize(Object value, boolean clear) {
        if (clear) {
            this.highlightedSizes.clear();
        }
        this.highlightedSizes.add(value);
        this.highlightedColors.clear();
        this.highlightedIds.clear();
        this.placeActiveInstancesLast();
        this.notifyListeners();
    }

    public void addHighlightTrackListener(HighlightTrackListener l) {
        this.listenerList.add(HighlightTrackListener.class, l);
    }

    public void clearHighlightedColors() {
        this.highlightedColors.clear();
        this.notifyListeners();
    }

    public void clearHighlightedSizes() {
        this.highlightedSizes.clear();
        this.notifyListeners();
    }

    public boolean contains(int rowIndex, int columnIndex, Object id) {
        return this.getInstanceIds(rowIndex, columnIndex).contains(id);
    }

    public boolean contains(Object id) {
        return this.getAllInstanceIds().contains(id);
    }

    public Collection<Object> getAllInstanceIds() {
        return this.rankedListFilterCollection.getInstanceIds();
    }

    public Color getColor(Object id) {
        if (this.highlightedSizes.size() > 0 && !this.highlightedSizes.contains(this.sizeBy.get(id))) {
            return this.inactiveColor;
        }
        Color c = this.defaultColor;
        if (this.colorBy != null) {
            Object colorByValue = this.colorBy.get(id);
            if (this.highlightedColors.size() > 0 && !this.highlightedColors.contains(colorByValue)) {
                return this.inactiveColor;
            }
            c = (Color)this.colorModel.getMappedValue(this.colorBy, colorByValue);
        }
        return c;
    }

    public IdSupplier getColorBy() {
        return this.colorBy;
    }

    public VectorColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public int getColumnCount() {
        return this.columnTextSpanPairs == null ? 1 : this.columnTextSpanPairs.length;
    }

    @Override
    public List<TextSpanPair>[] getColumnNames() {
        return this.columnTextSpanPairs;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public float getDefaultLineWidth() {
        return this.defaultLineWidth;
    }

    public IdSupplier[] getGroupColumnsBy() {
        return this.groupColumnsBy;
    }

    @Override
    public int getGroupColumnsByCount() {
        return this.groupColumnsBy == null ? 0 : this.groupColumnsBy.length;
    }

    public IdSupplier[] getGroupRowsBy() {
        return this.groupRowsBy;
    }

    @Override
    public int getGroupRowsByCount() {
        return this.groupRowsBy == null ? 0 : this.groupRowsBy.length;
    }

    public Collection<Object> getInstanceIds(int rowIndex, int columnIndex) {
        Sets.SetView ids;
        Object object = ids = this.instanceMatrix == null ? this.rankedListFilterCollection.getInstanceIds() : this.instanceMatrix[rowIndex][columnIndex];
        return this.animationFrameInstanceIds != null ? Sets.intersection(ids instanceof Set ? ids : new HashSet(ids), this.animationFrameInstanceIds) : ids;
    }

    public float getLineWidth(Object id) {
        Float width = null;
        if (this.sizeBy != null) {
            Object key = this.sizeBy.get(id);
            width = this.valueToSize.get(key);
        }
        return width != null ? width.floatValue() : this.defaultLineWidth;
    }

    public float getMaxSize() {
        return this.maxSize;
    }

    public float getMinSize() {
        return this.minSize;
    }

    public RankedList getReferenceRankedList() {
        return this.referenceRankedList;
    }

    @Override
    public int getRowCount() {
        return this.rowTextSpanPairs == null ? 1 : this.rowTextSpanPairs.length;
    }

    @Override
    public List<TextSpanPair>[] getRowNames() {
        return this.rowTextSpanPairs;
    }

    public IdSupplier getSizeBy() {
        return this.sizeBy;
    }

    public Map<Object, Float> getValueToSizeMap() {
        return this.valueToSize;
    }

    public boolean isColorHighlighted(Object value) {
        return this.highlightedColors.contains(value);
    }

    public boolean isEmpty() {
        return this.rankedListFilterCollection.getFilterCount() == 0 || this.getAllInstanceIds().size() == 0;
    }

    public boolean isHighlighted(Object id) {
        if (this.highlightedIds.size() > 0) {
            return this.highlightedIds.contains(id);
        }
        if (this.sizeBy != null && this.highlightedColors.size() > 0 && this.highlightedSizes.contains(this.sizeBy.get(id))) {
            return true;
        }
        return this.colorBy != null && this.highlightedColors.size() > 0 && this.highlightedColors.contains(this.colorBy.get(id));
    }

    public boolean isHighlightedColorsEmpty() {
        return this.highlightedColors.size() == 0;
    }

    public boolean isHighlightedIdsEmpty() {
        return this.highlightedIds.size() == 0;
    }

    public boolean isHighlightedSizesEmpty() {
        return this.highlightedSizes.size() == 0;
    }

    public boolean isSizeByContinuous() {
        return this.sizeByContinuous;
    }

    public boolean isSizeHighlighted(Object value) {
        return this.highlightedSizes.contains(value);
    }

    public void removeHighlightedColor(Object value) {
        this.highlightedColors.remove(value);
        this.placeActiveInstancesLast();
        this.notifyListeners();
    }

    public void removeHighlightedSize(Object value) {
        this.highlightedSizes.remove(value);
        this.placeActiveInstancesLast();
        this.notifyListeners();
    }

    public void removeHighlightTrackListener(HighlightTrackListener l) {
        this.listenerList.remove(HighlightTrackListener.class, l);
    }

    public void setAnimationFrameInstanceIds(Set<Object> animationFrameInstanceIds) {
        this.animationFrameInstanceIds = animationFrameInstanceIds;
        this.notifyListeners();
    }

    public void setColorBy(IdSupplier colorBy, boolean notify) {
        this.highlightedColors.clear();
        this.colorBy = colorBy;
        if (notify) {
            this.notifyListeners();
        }
    }

    public void setDefaultLineWidth(float defaultLineWidth) {
        this.defaultLineWidth = defaultLineWidth;
    }

    public void setGroupBy(IdSupplier[] groupRowsBy, IdSupplier[] groupColumnsBy, boolean notify) {
        if (groupRowsBy != null && groupRowsBy.length == 0) {
            groupRowsBy = null;
        }
        if (groupColumnsBy != null && groupColumnsBy.length == 0) {
            groupColumnsBy = null;
        }
        this.groupRowsBy = groupRowsBy;
        this.groupColumnsBy = groupColumnsBy;
        this.rowTextSpanPairs = null;
        this.columnTextSpanPairs = null;
        if (groupColumnsBy != null || groupRowsBy != null) {
            List<Combination> columnProduct = groupColumnsBy == null ? null : VectorUtil.getCombinations(groupColumnsBy);
            List<Combination> rowProduct = groupRowsBy == null ? null : VectorUtil.getCombinations(groupRowsBy);
            this.instanceMatrix = new List[rowProduct != null ? rowProduct.size() : 1][columnProduct != null ? columnProduct.size() : 1];
            int rows = this.instanceMatrix.length;
            int cols = 0;
            if (this.instanceMatrix.length > 0) {
                cols = this.instanceMatrix[0].length;
            }
            HashMap<Collection<Object>, Integer> columnGroupToIndex = null;
            List[] columnGroups = null;
            if (columnProduct != null) {
                columnGroups = new List[cols];
                columnGroupToIndex = new HashMap<Collection<Object>, Integer>();
                int index = 0;
                for (Combination item : columnProduct) {
                    columnGroups[index] = item.getValues();
                    columnGroupToIndex.put(item.getValues(), index);
                    ++index;
                }
            }
            HashMap<Collection<Object>, Integer> rowGroupToIndex = null;
            List[] rowGroups = null;
            if (rowProduct != null) {
                rowGroups = new List[rows];
                int index = 0;
                rowGroupToIndex = new HashMap<Collection<Object>, Integer>();
                for (Combination item : rowProduct) {
                    rowGroups[index] = item.getValues();
                    rowGroupToIndex.put(item.getValues(), index);
                    ++index;
                }
            }
            if (rowGroups != null) {
                this.rowTextSpanPairs = new List[rows];
                for (int i = 0; i < rows; ++i) {
                    this.rowTextSpanPairs[i] = new ArrayList<TextSpanPair>();
                }
                HighlightTrack.createNames(this.rowTextSpanPairs, rowProduct, groupRowsBy.length);
            }
            if (columnGroups != null) {
                this.columnTextSpanPairs = new List[cols];
                for (int i = 0; i < cols; ++i) {
                    this.columnTextSpanPairs[i] = new ArrayList<TextSpanPair>();
                }
                HighlightTrack.createNames(this.columnTextSpanPairs, columnProduct, groupColumnsBy.length);
            }
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    this.instanceMatrix[i][j] = new ArrayList<Object>();
                }
            }
            Collection<Object> ids = this.getAllInstanceIds();
            ArrayList<Object> rowList = new ArrayList<Object>();
            ArrayList<Object> columnList = new ArrayList<Object>();
            for (Object id : ids) {
                int rowIndex = 0;
                int columnIndex = 0;
                if (groupRowsBy != null) {
                    rowList.clear();
                    for (IdSupplier groupBy : groupRowsBy) {
                        rowList.add(groupBy.get(id));
                    }
                    rowIndex = (Integer)rowGroupToIndex.get(rowList);
                }
                if (groupColumnsBy != null) {
                    columnList.clear();
                    for (IdSupplier groupBy : groupColumnsBy) {
                        columnList.add(groupBy.get(id));
                    }
                    columnIndex = (Integer)columnGroupToIndex.get(columnList);
                }
                this.instanceMatrix[rowIndex][columnIndex].add(id);
            }
            boolean removeEmpty = true;
            if (removeEmpty && this.instanceMatrix.length != 0 && (this.instanceMatrix.length != 1 || this.instanceMatrix[0].length != 0)) {
                TIntArrayList rowIndices = this.getNonEmptyRowIndices();
                TIntArrayList columnIndices = this.getNonEmptyColumnIndices();
                if (this.columnTextSpanPairs != null && columnIndices.size() != this.columnTextSpanPairs.length) {
                    this.columnTextSpanPairs = IOUtil.subset(this.columnTextSpanPairs, columnIndices);
                }
                if (this.rowTextSpanPairs != null && rowIndices.size() != this.rowTextSpanPairs.length) {
                    this.rowTextSpanPairs = IOUtil.subset(this.rowTextSpanPairs, rowIndices);
                }
                this.instanceMatrix = IOUtil.subset(this.instanceMatrix, rowIndices, columnIndices);
            }
            if (this.instanceMatrix.length == 0 || this.instanceMatrix.length == 1 && this.instanceMatrix[0].length == 0) {
                this.instanceMatrix = null;
                this.rowTextSpanPairs = null;
                this.columnTextSpanPairs = null;
            }
        } else {
            this.instanceMatrix = null;
            this.rowTextSpanPairs = null;
            this.columnTextSpanPairs = null;
        }
        if (notify) {
            this.notifyListeners();
        }
    }

    public void setGroupColumnsBy(IdSupplier[] groupBy, boolean notify) {
        this.setGroupBy(this.groupRowsBy, groupBy, notify);
    }

    public void setGroupRowsBy(IdSupplier[] groupBy, boolean notify) {
        this.setGroupBy(groupBy, this.groupColumnsBy, notify);
    }

    public void setMaxSize(float maxSize) {
        this.maxSize = maxSize;
        this.setSizeBy(this.sizeBy, this.sizeByContinuous, false);
    }

    public void setMinSize(float minSize) {
        this.minSize = minSize;
        this.setSizeBy(this.sizeBy, this.sizeByContinuous, false);
    }

    public void setReferenceRankedList(RankedList rankedList) {
        this.referenceRankedList = rankedList;
        this.notifyListeners();
    }

    public void setSizeBy(IdSupplier sizeBy, boolean notify) {
        this.setSizeBy(sizeBy, this.sizeByContinuous, notify);
    }

    public void setSizeBy(IdSupplier sizeBy, boolean sizeByContinuous, boolean notify) {
        if (sizeByContinuous) {
            this.highlightedSizes.clear();
        }
        if (this.sizeBy != sizeBy) {
            this.highlightedSizes.clear();
            this.valueToSize.clear();
        }
        if (sizeBy != null) {
            if (sizeByContinuous) {
                sizeByContinuous = this.isNumber(sizeBy);
            }
            Collection<Object> ids = this.getAllInstanceIds();
            if (!sizeByContinuous) {
                float step;
                for (Object id : ids) {
                    Object value = sizeBy.get(id);
                    if (this.valueToSize.containsKey(value)) continue;
                    this.valueToSize.put(value, Float.valueOf(0.0f));
                }
                float pixels = step = this.defaultLineWidth / (float)this.valueToSize.size();
                for (Object value : this.valueToSize.keySet()) {
                    this.valueToSize.put(value, Float.valueOf(pixels));
                    pixels += step;
                }
            } else {
                float[] minMax = HighlightTrack.getMinMax(ids, sizeBy);
                for (Object id : ids) {
                    float f;
                    Object value = sizeBy.get(id);
                    Number n = (Number)value;
                    float pix = 0.0f;
                    if (n != null && !Float.isNaN(f = n.floatValue())) {
                        pix = WorldCoordinateMapper.linearScale(f, minMax[0], minMax[1], this.minSize, this.maxSize);
                    }
                    this.valueToSize.put(value, Float.valueOf(pix));
                }
            }
        }
        this.sizeBy = sizeBy;
        this.sizeByContinuous = sizeByContinuous;
        if (notify) {
            this.notifyListeners();
        }
    }

    public void setSizeByContinuous(boolean sizeByContinuous) {
        this.setSizeBy(this.sizeBy, sizeByContinuous, true);
    }

    void notifyListeners() {
        Object[] listeners = this.listenerList.getListenerList();
        HighlightTrackEvent e = new HighlightTrackEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HighlightTrackListener.class) continue;
            ((HighlightTrackListener)listeners[i + 1]).trackChanged(e);
        }
    }

    private TIntArrayList getNonEmptyColumnIndices() {
        TIntArrayList columnIndices = new TIntArrayList();
        for (int j = 0; j < this.instanceMatrix[0].length; ++j) {
            boolean empty = true;
            for (int i = 0; i < this.instanceMatrix.length && empty; ++i) {
                if (this.instanceMatrix[i][j].size() <= 0) continue;
                empty = false;
            }
            if (empty) continue;
            columnIndices.add(j);
        }
        return columnIndices;
    }

    private TIntArrayList getNonEmptyRowIndices() {
        TIntArrayList rowIndices = new TIntArrayList();
        for (int i = 0; i < this.instanceMatrix.length; ++i) {
            boolean empty = true;
            for (int j = 0; j < this.instanceMatrix[0].length && empty; ++j) {
                if (this.instanceMatrix[i][j].size() <= 0) continue;
                empty = false;
            }
            if (empty) continue;
            rowIndices.add(i);
        }
        return rowIndices;
    }

    private boolean isNumber(IdSupplier supplier) {
        if (supplier == null) {
            return false;
        }
        return Number.class.isAssignableFrom(supplier.getColumnClass());
    }

    private void placeActiveInstancesLast() {
        Comparator<Object> c = null;
        if (this.colorBy != null && this.highlightedColors.size() == 0) {
            c = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    boolean two;
                    boolean one = HighlightTrack.this.highlightedColors.contains(HighlightTrack.this.colorBy.get(o1));
                    if (one == (two = HighlightTrack.this.highlightedColors.contains(HighlightTrack.this.colorBy.get(o2)))) {
                        return 0;
                    }
                    if (one) {
                        return 1;
                    }
                    return -1;
                }
            };
        } else if (this.sizeBy != null && this.highlightedSizes.size() > 0) {
            c = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    boolean two;
                    boolean one = HighlightTrack.this.highlightedSizes.contains(HighlightTrack.this.sizeBy.get(o1));
                    if (one == (two = HighlightTrack.this.highlightedSizes.contains(HighlightTrack.this.sizeBy.get(o2)))) {
                        return 0;
                    }
                    if (one) {
                        return 1;
                    }
                    return -1;
                }
            };
        } else if (this.highlightedIds.size() > 0) {
            c = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    boolean two;
                    boolean one = HighlightTrack.this.highlightedIds.contains(o1);
                    if (one == (two = HighlightTrack.this.highlightedIds.contains(o2))) {
                        return 0;
                    }
                    if (one) {
                        return 1;
                    }
                    return -1;
                }
            };
        }
        if (c == null) {
            return;
        }
        if (this.instanceMatrix != null) {
            int rows = this.instanceMatrix.length;
            for (int i = 0; i < rows; ++i) {
                int cols = this.instanceMatrix[0].length;
                for (int j = 0; j < cols; ++j) {
                    if (this.instanceMatrix[i][j] == null) continue;
                    Collections.sort(this.instanceMatrix[i][j], c);
                }
            }
        } else {
            ArrayList<Object> tmp = new ArrayList<Object>(this.rankedListFilterCollection.getInstanceIds());
            Collections.sort(tmp, c);
            this.rankedListFilterCollection.setInstanceIds(new LinkedHashSet<Object>(tmp));
        }
    }

    public static void createNames(List<TextSpanPair>[] namesPerLevel, List<Combination> valuesForCartesianProduct, int nlevels) {
        int numberOfRowsOrColumns = namesPerLevel.length;
        for (int i = 0; i < numberOfRowsOrColumns; ++i) {
            Collection<Object> values = valuesForCartesianProduct.get(i).getValues();
            for (Object group : values) {
                String text = Formatter.toString(group);
                TextSpanPair pair = new TextSpanPair(text, -1);
                namesPerLevel[i].add(pair);
            }
        }
        for (int level = 0; level < nlevels; ++level) {
            int i = 0;
            while (i < numberOfRowsOrColumns) {
                List<TextSpanPair> pairs = namesPerLevel[i];
                String text = pairs.get(level).getText();
                int before = i;
                int after = i = HighlightTrack.getLastIndexOf(text, namesPerLevel, level, i + 1, numberOfRowsOrColumns);
                int span = after - before;
                namesPerLevel[before].get(level).setSpan(span);
            }
        }
    }

    private static int getLastIndexOf(String text, List<TextSpanPair>[] namesPerLevel, int level, int i, int length) {
        while (i < length && text.equals(namesPerLevel[i].get(level).getText())) {
            ++i;
        }
        return i;
    }

    private static float[] getMinMax(Collection<Object> ids, IdSupplier supplier) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (Object id : ids) {
            float f;
            Number n = (Number)supplier.get(id);
            if (n == null || Float.isNaN(f = n.floatValue()) || Float.isInfinite(f)) continue;
            min = Math.min(min, f);
            max = Math.max(max, f);
        }
        return new float[]{min, max};
    }
}

