/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import org.broadinstitute.genee.cmap.rankedlist.CartesianProductDisplay;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.filter.AbstractFloatFilter;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class RankedListComponent
extends JPanel
implements Drawable,
CartesianProductDisplay {
    static final int SPACE_BETWEEN_LIST_AND_GROUP = 2;
    private int barHeight = 300;
    private int barWidth = 30;
    private int bottomPadding;
    private int columnWidth;
    private HighlightTrack highlightTrack;
    private int leftPadding;
    private Color negativeColor = Color.BLUE;
    private Color nullColor = Color.LIGHT_GRAY;
    private Color positiveColor = Color.RED;
    private RankedList rankedList;
    private int rankedListSizeStringWidth;
    private int rightPadding;
    private int rowHeight;
    private int topPadding;
    private CoordinateMapper yCoordinateMapper;
    private boolean drawGrid;
    private boolean drawGradient = false;
    private float lineThickness = 1.0f;
    private boolean drawRanks = false;
    private AbstractFloatFilter maskFilter;
    private int maskAlpha = 60;
    public static final int DRAW_REFERENCE_ANGLE = 0;
    public static final int DRAW_REFERENCE_BARPLOT = 1;
    public static final int DRAW_REFERENCE_LINE = 2;
    private int drawReferenceMode = 0;

    public RankedListComponent(RankedList rankedList, HighlightTrack highlightTrack) {
        this.rankedList = rankedList;
        this.highlightTrack = highlightTrack;
        this.setBackground(Color.WHITE);
        this.setMinimumSize(new Dimension());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
    }

    @Override
    public int columnAtPix(int x) {
        int result = x / this.columnWidth;
        if (result < 0) {
            return 0;
        }
        if (result >= this.highlightTrack.getColumnCount()) {
            return this.highlightTrack.getColumnCount() - 1;
        }
        return result;
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        int j;
        int cols;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(UIUtil.RENDERING_HINTS);
        Stroke stroke = g2.getStroke();
        int rows = this.highlightTrack.getRowCount();
        for (int i = 0; i < rows; ++i) {
            cols = this.highlightTrack.getColumnCount();
            for (j = 0; j < cols; ++j) {
                this.drawBar(g2, i, j);
                this.drawLines(g2, this.highlightTrack, i, j);
            }
        }
        if (this.drawGrid && (this.highlightTrack.getColumnCount() > 1 || this.highlightTrack.getRowCount() > 1)) {
            g2.setColor(Color.LIGHT_GRAY);
            Rectangle clipBounds = g.getClipBounds();
            int maxYPix = this.rowToPix(this.highlightTrack.getRowCount());
            if (clipBounds != null) {
                maxYPix = Math.min(maxYPix, clipBounds.y + clipBounds.height);
            }
            cols = 1 + this.highlightTrack.getColumnCount();
            for (j = 0; j < cols; ++j) {
                int gridX = this.columnToPix(j);
                g2.drawLine(gridX, clipBounds != null ? clipBounds.y : 0, gridX, maxYPix);
            }
            int maxXPix = this.columnToPix(this.highlightTrack.getColumnCount());
            if (clipBounds != null) {
                maxXPix = Math.min(maxXPix, clipBounds.x + clipBounds.width);
            }
            int rows2 = 1 + this.highlightTrack.getRowCount();
            for (int i = 0; i < rows2; ++i) {
                int gridY = this.rowToPix(i);
                g2.drawLine(clipBounds != null ? clipBounds.x : 0, gridY, maxXPix, gridY);
            }
        }
        g2.setStroke(stroke);
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    @Override
    public int getColumnPixEnd(int columnIndex) {
        return this.getColumnPixStart(columnIndex) + this.columnWidth;
    }

    @Override
    public int getColumnPixStart(int columnIndex) {
        return this.columnToPix(columnIndex) + this.leftPadding;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    @Override
    public Dimension getDrawableSize() {
        Dimension size = this.getPreferredSize();
        size.height += 20;
        return size;
    }

    public int getDrawReferenceMode() {
        return this.drawReferenceMode;
    }

    public Set<Object> getHighligtedInstances(MouseEvent e) {
        int rowIndex = this.rowAtPix(e.getPoint().y);
        int columnIndex = this.columnAtPix(e.getPoint().x);
        int lineXPixStart = this.columnToLineXPixStart(columnIndex);
        float lineXPixEnd = (float)lineXPixStart + this.highlightTrack.getMaxSize();
        if (e.getX() < lineXPixStart || (float)e.getX() > lineXPixEnd) {
            columnIndex = -1;
        }
        if (rowIndex == -1 || columnIndex == -1) {
            return Collections.EMPTY_SET;
        }
        HashSet<Object> ids = new HashSet<Object>();
        int lowerIndex = (int)Math.floor(this.pixToRankedListIndex(rowIndex, (float)e.getY() - 1.0f));
        lowerIndex = Math.max(lowerIndex, 0);
        int upperIndex = (int)Math.floor(this.pixToRankedListIndex(rowIndex, (float)e.getY() + 1.0f));
        upperIndex = Math.min(upperIndex, this.rankedList.size() - 1);
        for (int index = lowerIndex; index <= upperIndex; ++index) {
            Object id = this.rankedList.getId(index);
            if (!this.highlightTrack.contains(rowIndex, columnIndex, id)) continue;
            ids.add(id);
        }
        return ids.size() > 0 ? ids : Collections.EMPTY_SET;
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public int getMaskAlpha() {
        return this.maskAlpha;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension();
    }

    public Color getNegativeColor() {
        return this.negativeColor;
    }

    public Color getNullColor() {
        return this.nullColor;
    }

    public Color getPositiveColor() {
        return this.positiveColor;
    }

    @Override
    public Dimension getPreferredSize() {
        Font font = this.getFont();
        font = font.deriveFont(1);
        FontMetrics fm = this.getFontMetrics(font);
        this.rankedListSizeStringWidth = this.drawRanks ? 4 + fm.stringWidth("" + this.rankedList.size()) : 0;
        Insets insets = this.getInsets();
        this.bottomPadding = Math.max(1, insets.bottom);
        this.leftPadding = Math.max(1, insets.left);
        this.rightPadding = Math.max(1, insets.right);
        this.topPadding = Math.max(1, insets.top);
        int maxLineWidth = (int)(this.highlightTrack.getSizeBy() != null || this.drawReferenceMode == 2 ? this.highlightTrack.getMaxSize() : this.highlightTrack.getDefaultLineWidth());
        this.columnWidth = this.barWidth + maxLineWidth + 2 + this.leftPadding + this.rightPadding;
        int totalFontHeight = 0;
        if (this.highlightTrack.getGroupColumnsBy() != null) {
            totalFontHeight += fm.getHeight() * this.highlightTrack.getGroupColumnsBy().length;
        }
        if (this.highlightTrack.getGroupRowsBy() != null) {
            totalFontHeight += fm.getHeight() * this.highlightTrack.getGroupRowsBy().length;
        }
        if (totalFontHeight > this.columnWidth) {
            int increase = (int)Math.ceil((float)totalFontHeight - (float)this.columnWidth / 2.0f);
            this.leftPadding += increase;
            this.rightPadding += increase;
        }
        this.columnWidth = this.barWidth + maxLineWidth + 2 + this.leftPadding + this.rightPadding;
        this.rowHeight = this.barHeight + this.bottomPadding + this.topPadding;
        this.yCoordinateMapper = new WorldCoordinateMapper();
        this.yCoordinateMapper.setBottomGutter(0.0f);
        this.yCoordinateMapper.setTopGutter(0.0f);
        this.yCoordinateMapper.setYMin(this.rankedList.size() - 1);
        this.yCoordinateMapper.setYMax(0.0f);
        this.yCoordinateMapper.setYPixelScale((float)this.barHeight + this.yCoordinateMapper.getBottomGutter() + this.yCoordinateMapper.getTopGutter());
        return new Dimension(this.rankedListSizeStringWidth + this.columnWidth * this.highlightTrack.getColumnCount(), this.rowHeight * this.highlightTrack.getRowCount());
    }

    public RankedList getRankedList() {
        return this.rankedList;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    @Override
    public float getRowPixEnd(int rowIndex) {
        return this.topPadding + this.barHeight + this.rowHeight * rowIndex;
    }

    @Override
    public float getRowPixStart(int rowIndex) {
        return this.topPadding + this.rowHeight * rowIndex;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Set<Object> ids = this.getHighligtedInstances(e);
        if (ids.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<html>");
        buf.append("<table>");
        for (Object e2 : ids) {
            int rank = this.rankedList.getIndex(e2);
            buf.append("<tr><td>Rank:<td>");
            buf.append(rank + 1);
            buf.append("<tr><td>Score:<td>");
            buf.append(Formatter.format(this.rankedList.getScore(rank)));
            int count = this.rankedList.getMetadata().getMetadataCount();
            for (int j = 0; j < count; ++j) {
                buf.append("<tr><td>");
                buf.append(this.rankedList.getMetadata().get(j).getName());
                buf.append(":");
                buf.append("<td>");
                Object value = this.rankedList.getMetadata().getValue(rank, j);
                buf.append(Formatter.toString(value));
            }
        }
        buf.append("</table>");
        return buf.toString();
    }

    public boolean isDrawGradient() {
        return this.drawGradient;
    }

    public boolean isDrawRanks() {
        return this.drawRanks;
    }

    public int pixToRankedListIndex(int rowIndex, float pix) {
        pix -= (float)(rowIndex * this.rowHeight);
        int index = Math.round(this.yCoordinateMapper.pixToY(pix -= (float)this.topPadding));
        if (index < 0) {
            index = 0;
        }
        if (index >= this.rankedList.size()) {
            index = this.rankedList.size() - 1;
        }
        return index;
    }

    public float rankedListIndexToPix(int rowIndex, int y) {
        float pix = this.yCoordinateMapper.yToPix(y);
        return pix + (float)this.topPadding + (float)(rowIndex * this.rowHeight);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip(this);
    }

    @Override
    public int rowAtPix(int y) {
        int result = y / this.rowHeight;
        if (result < 0) {
            return 0;
        }
        if (result >= this.highlightTrack.getRowCount()) {
            return this.highlightTrack.getRowCount() - 1;
        }
        return result;
    }

    public void setBarHeight(int barHeight) {
        this.barHeight = barHeight;
        this.revalidate();
        this.repaint();
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
        this.revalidate();
        this.repaint();
    }

    public void setDrawGradient(boolean drawGradient) {
        this.drawGradient = drawGradient;
        this.repaint();
    }

    public void setDrawRanks(boolean drawRanks) {
        this.drawRanks = drawRanks;
        this.revalidate();
        this.repaint();
    }

    public void setDrawReferenceMode(int drawReferenceMode) {
        this.drawReferenceMode = drawReferenceMode;
    }

    public void setLineThickness(float lineThickness) {
        this.lineThickness = lineThickness;
        this.repaint();
    }

    public void setMaskAlpha(int maskAlpha) {
        this.maskAlpha = maskAlpha;
    }

    public void setMaskFilter(AbstractFloatFilter maskFilter) {
        this.maskFilter = maskFilter;
    }

    public void setNegativeColor(Color negativeColor) {
        this.negativeColor = negativeColor;
        this.repaint();
    }

    public void setNullColor(Color nullColor) {
        this.nullColor = nullColor;
        this.repaint();
    }

    public void setPositiveColor(Color positiveColor) {
        this.positiveColor = positiveColor;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.draw(g, null);
    }

    private int columnToLineXPixStart(int columnIndex) {
        return this.columnToPix(columnIndex) + this.leftPadding + this.barWidth + 2;
    }

    private int columnToPix(int columnIndex) {
        return columnIndex * this.columnWidth;
    }

    private void drawBar(Graphics2D g2, int rowIndex, int columnIndex) {
        float ypixBarStart = this.getRowPixStart(rowIndex);
        float ypixBarEnd = this.getRowPixEnd(rowIndex);
        int xpixBarStart = this.getColumnPixStart(columnIndex);
        int posToZeroIndex = this.rankedList.getPositiveToZeroIndex();
        int negToZeroIndex = this.rankedList.getNegativeToZeroIndex();
        float posToZeroYPix = ypixBarStart;
        float negToZeroYPix = ypixBarEnd;
        if (posToZeroIndex == -1) {
            g2.setPaint(this.positiveColor);
            g2.fill(new Rectangle2D.Float(xpixBarStart, ypixBarStart, this.barWidth, this.barHeight));
            return;
        }
        posToZeroYPix = this.rankedListIndexToPix(rowIndex, posToZeroIndex);
        if (negToZeroIndex == -1) {
            g2.setPaint(this.negativeColor);
            g2.fill(new Rectangle2D.Float(xpixBarStart, ypixBarStart, this.barWidth, this.barHeight));
            return;
        }
        negToZeroYPix = this.rankedListIndexToPix(rowIndex, negToZeroIndex);
        g2.setPaint(this.nullColor);
        g2.fill(new Rectangle2D.Float(xpixBarStart, posToZeroYPix, this.barWidth, ypixBarEnd - posToZeroYPix));
        float posBarHeight = posToZeroYPix - ypixBarStart;
        g2.setPaint(this.drawGradient ? new LinearGradientPaint(0.0f, ypixBarStart, 0.0f, posToZeroYPix, new float[]{0.0f, 1.0f}, new Color[]{this.positiveColor, this.nullColor}) : this.positiveColor);
        g2.fill(new Rectangle2D.Float(xpixBarStart, ypixBarStart, this.barWidth, posBarHeight));
        float negBarHeight = ypixBarEnd - negToZeroYPix;
        g2.setPaint(this.drawGradient ? new LinearGradientPaint(0.0f, negToZeroYPix, 0.0f, ypixBarEnd, new float[]{0.0f, 1.0f}, new Color[]{this.nullColor, this.negativeColor}) : this.negativeColor);
        g2.fill(new Rectangle2D.Float(xpixBarStart, negToZeroYPix, this.barWidth, negBarHeight));
    }

    private void drawCurve(Graphics2D g2, int rowIndex, int columnIndex) {
        float xpix;
        float percent;
        float score;
        float ypix;
        int i;
        int xpixBarStart = this.getColumnPixStart(columnIndex);
        Path2D.Float path = new Path2D.Float();
        float max = this.rankedList.getScore(0);
        float min = this.rankedList.getScore(this.rankedList.size() - 1);
        max = Math.max(max, Math.abs(min));
        min = 0.0f;
        float range = max - min;
        int posToZeroIndex = this.rankedList.getPositiveToZeroIndex();
        int negToZeroIndex = this.rankedList.getNegativeToZeroIndex();
        path.moveTo(xpixBarStart, this.rankedListIndexToPix(rowIndex, 0));
        for (i = 0; i < posToZeroIndex; ++i) {
            ypix = this.rankedListIndexToPix(rowIndex, i);
            score = this.rankedList.getScore(i);
            percent = (score - min) / range;
            xpix = (float)xpixBarStart + (float)this.barWidth * percent;
            path.lineTo(xpix, ypix);
        }
        path.moveTo(xpixBarStart, this.rankedListIndexToPix(rowIndex, posToZeroIndex - 1));
        path.closePath();
        g2.setColor(this.positiveColor);
        g2.fill(path);
        path.reset();
        path.moveTo(xpixBarStart, this.rankedListIndexToPix(rowIndex, this.rankedList.size() - 1));
        for (i = this.rankedList.size() - 1; i > negToZeroIndex; --i) {
            ypix = this.rankedListIndexToPix(rowIndex, i);
            score = Math.abs(this.rankedList.getScore(i));
            percent = (score - min) / range;
            xpix = (float)xpixBarStart + (float)this.barWidth * percent;
            path.lineTo(xpix, ypix);
        }
        path.moveTo(xpixBarStart, this.rankedListIndexToPix(rowIndex, negToZeroIndex + 1));
        path.closePath();
        g2.setColor(this.negativeColor);
        g2.fill(path);
    }

    private void drawLines(Graphics2D g2, HighlightTrack highlightTrack, int rowIndex, int columnIndex) {
        Line2D.Float line = new Line2D.Float();
        Font font = g2.getFont();
        Font smallFont = font.deriveFont(8.0f);
        Font boldFont = g2.getFont().deriveFont(9.0f).deriveFont(1);
        g2.setFont(smallFont);
        boolean doHighlight = !highlightTrack.isHighlightedColorsEmpty() || !highlightTrack.isHighlightedSizesEmpty() || !highlightTrack.isHighlightedIdsEmpty();
        int descent = g2.getFontMetrics().getDescent();
        RankedList referenceRankedList = highlightTrack.getReferenceRankedList();
        boolean hasReference = referenceRankedList != null && referenceRankedList != this.getRankedList();
        BasicStroke stroke = new BasicStroke(this.lineThickness);
        g2.setStroke(stroke);
        Stroke oldStroke = g2.getStroke();
        Point2D.Float start = new Point2D.Float();
        Point2D.Float end = new Point2D.Float();
        for (Object id : highlightTrack.getInstanceIds(rowIndex, columnIndex)) {
            int index = this.rankedList.getIndex(id);
            if (index == -1) {
                System.err.println(id + " not found.");
                continue;
            }
            Color color = highlightTrack.getColor(id);
            int refIndex = -1;
            int diff = -1;
            if (hasReference) {
                refIndex = referenceRankedList.getIndex(id);
                diff = index - refIndex;
                if (this.maskFilter != null && this.maskFilter.apply(diff)) {
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.maskAlpha);
                }
            }
            this.getCoordinates(rowIndex, columnIndex, id, index, hasReference, diff, start, end);
            g2.setColor(color);
            line.setLine(start.x, start.y, end.x, end.y);
            boolean isHighlighted = false;
            if (doHighlight && highlightTrack.isHighlighted(id)) {
                isHighlighted = true;
                g2.setStroke(new BasicStroke(3.0f));
            }
            g2.draw(line);
            if (hasReference && this.drawReferenceMode == 1) {
                float xRefPix;
                line.x2 = line.x1 = (xRefPix = WorldCoordinateMapper.linearScale(refIndex, 0.0f, referenceRankedList.size() - 1, start.x, end.x));
                line.y2 = line.y1 - 4.0f;
                g2.draw(line);
            }
            if (isHighlighted) {
                g2.setStroke(stroke);
            }
            if (!this.drawRanks) continue;
            g2.setColor(Color.BLACK);
            String rank = String.valueOf(this.rankedList.getIndex(id) + 1);
            if (isHighlighted) {
                g2.setFont(boldFont);
            }
            g2.setStroke(oldStroke);
            g2.drawString(rank, end.x + 1.5f, end.y + (float)descent);
            g2.setFont(smallFont);
        }
        g2.setStroke(oldStroke);
        g2.setFont(font);
    }

    private void getCoordinates(int rowIndex, int columnIndex, Object id, int index, boolean hasReference, int diff, Point2D.Float start, Point2D.Float end) {
        float ypix1;
        float xstart = this.columnToLineXPixStart(columnIndex);
        float lineLength = this.highlightTrack.getLineWidth(id);
        float xend = xstart + lineLength;
        float ypix2 = ypix1 = this.rankedListIndexToPix(rowIndex, index);
        if (hasReference && this.drawReferenceMode == 0) {
            float theta;
            if (diff > 0) {
                theta = WorldCoordinateMapper.linearScale(diff, 0.0f, this.rankedList.size() - 1, 0.0f, 89.0f);
                double radians = Math.toRadians(theta);
                ypix2 = ypix1 - (float)(Math.sin(radians) * (double)lineLength);
                xend = xstart + (float)(Math.cos(radians) * (double)lineLength);
            } else if (diff < 0) {
                theta = WorldCoordinateMapper.linearScale(diff, 0.0f, this.rankedList.size() - 1, 360.0f, 271.0f);
                double radians = Math.toRadians(theta);
                ypix2 = ypix1 + (float)(Math.sin(radians) * (double)lineLength);
                xend = xstart + (float)(Math.cos(radians) * (double)lineLength);
            }
        }
        if (hasReference && this.drawReferenceMode == 2) {
            float length = WorldCoordinateMapper.linearScale(Math.abs(diff), 0.0f, this.rankedList.size() - 1, this.highlightTrack.getMinSize(), this.highlightTrack.getMaxSize());
            xend = xstart + length;
        }
        start.x = xstart;
        start.y = ypix1;
        end.x = xend;
        end.y = ypix2;
    }

    private int rowToPix(int rowIndex) {
        return rowIndex * this.rowHeight;
    }
}

