/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.cmap.rankedlist.RankedListComponent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListController;
import org.broadinstitute.genee.filter.AbstractFloatFilter;
import org.broadinstitute.genee.filter.GT;
import org.broadinstitute.genee.filter.GTE;
import org.broadinstitute.genee.filter.LT;
import org.broadinstitute.genee.filter.LTE;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.IncreaseDecreasePanel;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

class RankedListOptionsPanel
extends JPanel {
    static final String POSITIVE_COLOR = "positive.color";
    static final String SHOW_HIGHLIGHTED_ONLY = "show.highlighted.only";
    static final String LINE_WIDTH = "line.width";
    static final String LINE_THICKNESS = "line.thickness";
    static final String BAR_HEIGHT = "bar.height";
    static final String BAR_WIDTH = "bar.width";
    static final String NEGATIVE_COLOR = "negative.color";
    static final String NULL_COLOR = "null.color";
    static final String DRAW_GRADIENT = "draw.gradient";
    static final String SYNC_SELECTION = "sync.selection";
    static final String DRAW_RANKS = "draw.ranks";
    static final String MIN_LINE_WIDTH = "min.line.width";
    static final String MAX_LINE_WIDTH = "max.line.width";
    static final String TABLE_IN_IMAGE = "table.in.image";
    static final String WRAP = "wrap";
    static final String GRID_COLUMNS_WRAP = "grid.columns.wrap";
    private final RankedListController rankedListController;
    private JComboBox savedSettingsComboBox;
    private JCheckBox drawRanksCheckBox;
    private JCheckBox useGradient;
    private EditColorButton nullColorBtn;
    private EditColorButton negativeColorBtn;
    private EditColorButton upColorBtn;
    private JCheckBox syncSelectionCheckBox;
    private IncreaseDecreasePanel barWidth;
    private IncreaseDecreasePanel barHeight;
    private IncreaseDecreasePanel lineWidth;
    private IncreaseDecreasePanel lineThickness;
    private IncreaseDecreasePanel minLineWidth;
    private IncreaseDecreasePanel maxLineWidth;
    private JCheckBox showHighlightedInstancesOnlyCheckBox;
    private JButton loadButton;
    private JButton removeSettingsButton;
    private JCheckBox includeTableInSavedImageCheckBox;
    private JCheckBox maskCheckBox;
    private JTextField maskTextField;
    private JComboBox maskComboBox;
    private TimerTextField opacityTextField;
    private JLabel opacityLabel;

    public RankedListOptionsPanel(final RankedListController rankedListController) {
        this.rankedListController = rankedListController;
        Preferences p = this.getPreferences();
        FormBuilder formBuilder = new FormBuilder(new JPanel(), 4);
        formBuilder.nextRow();
        rankedListController.setIncludeTableInSavedImage(p.getBoolean(TABLE_IN_IMAGE, true));
        this.includeTableInSavedImageCheckBox = new JCheckBox("Include table in saved image", rankedListController.isIncludeTableInSavedImage());
        this.includeTableInSavedImageCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rankedListController.setIncludeTableInSavedImage(RankedListOptionsPanel.this.includeTableInSavedImageCheckBox.isSelected());
            }
        });
        formBuilder.addSpanned(this.includeTableInSavedImageCheckBox);
        formBuilder.nextRow();
        rankedListController.setShowHighlightedInstancesOnly(p.getBoolean(SHOW_HIGHLIGHTED_ONLY, false));
        this.showHighlightedInstancesOnlyCheckBox = new JCheckBox("Show highlighted instances only in table", rankedListController.isShowHighlightedInstancesOnly());
        this.showHighlightedInstancesOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rankedListController.setShowHighlightedInstancesOnly(RankedListOptionsPanel.this.showHighlightedInstancesOnlyCheckBox.isSelected());
                rankedListController.setSelectedRankedListComponent(rankedListController.getSelectedRankedListComponent(), true);
            }
        });
        formBuilder.addSpanned(this.showHighlightedInstancesOnlyCheckBox);
        formBuilder.nextRow();
        this.syncSelectionCheckBox = new JCheckBox("Synchronize ranked list view with heat map column selection", p.getBoolean(SYNC_SELECTION, true));
        if (this.syncSelectionCheckBox.isSelected()) {
            rankedListController.getRankedListCollection().addChangeListener(rankedListController.getModelChangeListener());
        }
        this.syncSelectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RankedListOptionsPanel.this.syncSelectionCheckBox.isSelected()) {
                    rankedListController.getRankedListCollection().addChangeListener(rankedListController.getModelChangeListener());
                } else {
                    rankedListController.getRankedListCollection().removeChangeListener(rankedListController.getModelChangeListener());
                }
            }
        });
        formBuilder.addSpanned(this.syncSelectionCheckBox);
        formBuilder.nextRow();
        this.useGradient = new JCheckBox("Draw gradient", p.getBoolean(DRAW_GRADIENT, false));
        this.useGradient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = RankedListOptionsPanel.this.useGradient.isSelected();
                rankedListController.setDrawGradient(b);
            }
        });
        formBuilder.addSpanned(this.useGradient);
        formBuilder.nextRow();
        this.drawRanksCheckBox = new JCheckBox("Draw ranks", p.getBoolean(DRAW_RANKS, false));
        this.drawRanksCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = RankedListOptionsPanel.this.drawRanksCheckBox.isSelected();
                rankedListController.setDrawRanks(b);
            }
        });
        formBuilder.addSpanned(this.drawRanksCheckBox);
        formBuilder.nextRow();
        JPanel maskPanel = new JPanel((LayoutManager)new FormLayout("p, 6px, p, 6px, p", "p"));
        this.maskCheckBox = new JCheckBox("Mask instances where difference to reference rank is:");
        this.maskComboBox = new JComboBox<AbstractFloatFilter>(new AbstractFloatFilter[]{new GT(), new GTE(), new LT(), new LTE()});
        this.maskTextField = new TimerTextField("", 10){

            @Override
            public void update() {
                try {
                    float value = ParserHelper.parseFloat(this.getText().trim());
                    AbstractFloatFilter filter = (AbstractFloatFilter)RankedListOptionsPanel.this.maskComboBox.getSelectedItem();
                    filter.setValue(value);
                    rankedListController.setMaskFilter(filter);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.maskTextField.setEnabled(this.maskCheckBox.isSelected());
        this.maskComboBox.setEnabled(this.maskCheckBox.isSelected());
        maskPanel.add((Component)this.maskCheckBox, CC.xy((int)1, (int)1));
        maskPanel.add((Component)this.maskComboBox, CC.xy((int)3, (int)1));
        maskPanel.add((Component)this.maskTextField, CC.xy((int)5, (int)1));
        formBuilder.addSpanned(maskPanel);
        formBuilder.nextRow();
        FormBuilder opacityBuilder = new FormBuilder();
        opacityBuilder.setIndentedBorder(1);
        opacityBuilder.nextRowNoSpace();
        this.opacityLabel = opacityBuilder.addLabel("Opacity (0 - 255):");
        this.opacityTextField = new TimerTextField("60", 10){

            @Override
            public void update() {
                try {
                    float value = ParserHelper.parseFloat(this.getText().trim());
                    rankedListController.setMaskAlpha((int)value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        opacityBuilder.add(this.opacityTextField);
        formBuilder.addSpanned(opacityBuilder.getPanel());
        this.maskTextField.setEnabled(this.maskCheckBox.isSelected());
        this.opacityTextField.setEnabled(this.maskCheckBox.isSelected());
        this.maskCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rankedListController.setMaskFilter((AbstractFloatFilter)(RankedListOptionsPanel.this.maskCheckBox.isSelected() ? RankedListOptionsPanel.this.maskComboBox.getSelectedItem() : null));
                RankedListOptionsPanel.this.maskTextField.setEnabled(RankedListOptionsPanel.this.maskCheckBox.isSelected());
                RankedListOptionsPanel.this.maskComboBox.setEnabled(RankedListOptionsPanel.this.maskCheckBox.isSelected());
                RankedListOptionsPanel.this.opacityTextField.setEnabled(RankedListOptionsPanel.this.maskCheckBox.isSelected());
                RankedListOptionsPanel.this.opacityLabel.setEnabled(RankedListOptionsPanel.this.maskCheckBox.isSelected());
            }
        });
        formBuilder.nextRow();
        formBuilder.addLabel("Bar width:");
        this.barWidth = new IncreaseDecreasePanel(3, p.getInt(BAR_WIDTH, 30), 5.0f, 0.0f, Float.MAX_VALUE);
        this.barWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = (int)RankedListOptionsPanel.this.barWidth.getValue();
                rankedListController.setBarWidth(value);
            }
        });
        formBuilder.add(this.barWidth);
        formBuilder.nextColumn();
        formBuilder.addLabel("Bar height:");
        this.barHeight = new IncreaseDecreasePanel(3, p.getInt(BAR_HEIGHT, 300), 10.0f, 0.0f, Float.MAX_VALUE);
        this.barHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = (int)RankedListOptionsPanel.this.barHeight.getValue();
                rankedListController.setBarHeight(value);
            }
        });
        formBuilder.add(this.barHeight);
        formBuilder.previousColumn();
        formBuilder.nextRow();
        formBuilder.addLabel("Default Line Width:");
        this.lineWidth = new IncreaseDecreasePanel(3, rankedListController.getRankedListDropComponent().getHighlightTrack().getDefaultLineWidth(), 2.0f, 1.0f, Float.MAX_VALUE);
        this.lineWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rankedListController.getRankedListDropComponent().getHighlightTrack().setDefaultLineWidth(RankedListOptionsPanel.this.lineWidth.getValue());
                rankedListController.revalidateAndRepaintAll();
            }
        });
        formBuilder.add(this.lineWidth);
        formBuilder.nextColumn();
        formBuilder.addLabel("Line Thickness:");
        this.lineThickness = new IncreaseDecreasePanel(3, p.getFloat(LINE_THICKNESS, 1.0f), 1.0f, 0.1f, Float.MAX_VALUE);
        this.lineThickness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float value = RankedListOptionsPanel.this.lineThickness.getValue();
                rankedListController.setLineThickness(value);
            }
        });
        formBuilder.add(this.lineThickness);
        formBuilder.previousColumn();
        formBuilder.nextRow();
        formBuilder.addLabel("Minimum Line Width:");
        this.minLineWidth = new IncreaseDecreasePanel(3, rankedListController.getRankedListDropComponent().getHighlightTrack().getMinSize(), 2.0f, 1.0f, Float.MAX_VALUE);
        this.minLineWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rankedListController.getRankedListDropComponent().getHighlightTrack().setMinSize((int)RankedListOptionsPanel.this.minLineWidth.getValue());
                rankedListController.revalidateAndRepaintAll();
            }
        });
        formBuilder.add(this.minLineWidth);
        formBuilder.nextColumn();
        formBuilder.addLabel("Maximum Line Width:");
        this.maxLineWidth = new IncreaseDecreasePanel(3, rankedListController.getRankedListDropComponent().getHighlightTrack().getMaxSize(), 2.0f, 1.0f, Float.MAX_VALUE);
        this.maxLineWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rankedListController.getRankedListDropComponent().getHighlightTrack().setMaxSize((int)RankedListOptionsPanel.this.maxLineWidth.getValue());
                rankedListController.revalidateAndRepaintAll();
            }
        });
        formBuilder.add(this.maxLineWidth);
        formBuilder.previousColumn();
        formBuilder.nextRow();
        formBuilder.nextRow();
        formBuilder.addLabel("Positive color:");
        this.upColorBtn = new EditColorButton(RankedListOptionsPanel.getColor(p, POSITIVE_COLOR, Color.RED));
        this.upColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = RankedListOptionsPanel.this.upColorBtn.getColor();
                rankedListController.setPositiveColor(color);
            }
        });
        formBuilder.add(this.upColorBtn);
        formBuilder.nextColumn();
        formBuilder.addLabel("Negative color:");
        this.negativeColorBtn = new EditColorButton(RankedListOptionsPanel.getColor(p, NEGATIVE_COLOR, Color.BLUE));
        this.negativeColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = RankedListOptionsPanel.this.negativeColorBtn.getColor();
                rankedListController.setNegativeColor(color);
            }
        });
        formBuilder.add(this.negativeColorBtn);
        formBuilder.previousColumn();
        formBuilder.nextRow();
        formBuilder.addLabel("Null color:");
        this.nullColorBtn = new EditColorButton(RankedListOptionsPanel.getColor(p, NULL_COLOR, Color.GRAY));
        this.nullColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = RankedListOptionsPanel.this.nullColorBtn.getColor();
                rankedListController.setNullColor(c);
            }
        });
        formBuilder.add(this.nullColorBtn);
        this.savedSettingsComboBox = UIUtil.createComboBox();
        this.loadButton = new JButton("Load");
        this.loadButton.setToolTipText("Load setting");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedViewSettingsName = (String)RankedListOptionsPanel.this.savedSettingsComboBox.getSelectedItem();
                RankedListOptionsPanel.this.setPropertiesFromSavedSettings(selectedViewSettingsName);
            }
        });
        this.removeSettingsButton = new JButton("Remove");
        this.removeSettingsButton.setToolTipText("Remove setting");
        this.removeSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = (String)RankedListOptionsPanel.this.savedSettingsComboBox.getSelectedItem();
                Preferences p = RankedListOptionsPanel.this.getPreferences().node(name);
                try {
                    p.removeNode();
                }
                catch (BackingStoreException e1) {
                    e1.printStackTrace();
                }
                RankedListOptionsPanel.this.updateSavedSettingsComboBox();
            }
        });
        JButton saveBtn = new JButton("Save As\u2026");
        saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = UIUtil.showInputDialog(RankedListOptionsPanel.this, "Saved setting name", null);
                if (name != null) {
                    RankedListOptionsPanel.this.save(name);
                }
                RankedListOptionsPanel.this.updateSavedSettingsComboBox();
            }
        });
        JButton saveAsDefaults = new JButton("Save As Defaults");
        saveAsDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RankedListOptionsPanel.this.save(null);
            }
        });
        JButton restoreDefaults = new JButton("Restore Defaults");
        restoreDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences p = RankedListOptionsPanel.this.getPreferences();
                try {
                    p.clear();
                    p.sync();
                }
                catch (BackingStoreException e1) {
                    e1.printStackTrace();
                }
                RankedListOptionsPanel.this.setPropertiesFromSavedSettings(null);
            }
        });
        this.updateSavedSettingsComboBox();
        formBuilder.nextRow();
        this.loadButton.setEnabled(this.savedSettingsComboBox.getSelectedIndex() != -1);
        this.removeSettingsButton.setEnabled(this.loadButton.isEnabled());
        this.savedSettingsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RankedListOptionsPanel.this.loadButton.setEnabled(RankedListOptionsPanel.this.savedSettingsComboBox.getSelectedIndex() != -1);
                RankedListOptionsPanel.this.removeSettingsButton.setEnabled(RankedListOptionsPanel.this.loadButton.isEnabled());
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new FormLayout("p, p:g", "p,p"));
        CellConstraints cc = new CellConstraints();
        bottomPanel.add((Component)this.savedSettingsComboBox, cc.xy(1, 1));
        bottomPanel.add((Component)UIUtil.buildLeftRightAlignedBar(new JButton[]{this.removeSettingsButton, this.loadButton}, new JButton[0]), cc.xy(2, 1));
        bottomPanel.add((Component)UIUtil.buildLeftRightAlignedBar(new JButton[]{saveAsDefaults, restoreDefaults}, new JButton[]{saveBtn}), cc.xyw(1, 2, 2));
        formBuilder.getPanel().setMinimumSize(new Dimension());
        this.setLayout(new BorderLayout());
        this.add(formBuilder.getPanel());
        this.add((Component)bottomPanel, "South");
        this.setMinimumSize(new Dimension());
    }

    public boolean isSyncSelection() {
        return this.syncSelectionCheckBox.isSelected();
    }

    void setPropertiesFromSavedSettings(String nodeName) {
        RankedListComponent[][] elements = this.rankedListController.getRankedListComponents();
        Preferences p = this.getPreferences();
        if (nodeName != null) {
            p = p.node(nodeName);
        }
        Color nullColor = RankedListOptionsPanel.getColor(p, NULL_COLOR, Color.LIGHT_GRAY);
        Color posColor = RankedListOptionsPanel.getColor(p, POSITIVE_COLOR, Color.RED);
        Color negColor = RankedListOptionsPanel.getColor(p, NEGATIVE_COLOR, Color.BLUE);
        int barWidthValue = p.getInt(BAR_WIDTH, 30);
        int barHeightValue = p.getInt(BAR_HEIGHT, 300);
        float lineWidthValue = p.getFloat(LINE_WIDTH, 30.0f);
        float lineThicknessValue = p.getFloat(LINE_THICKNESS, 1.0f);
        float minLineWidthValue = p.getFloat(MIN_LINE_WIDTH, 16.0f);
        float maxLineWidthValue = p.getFloat(MAX_LINE_WIDTH, 70.0f);
        this.rankedListController.setShowHighlightedInstancesOnly(p.getBoolean(SHOW_HIGHLIGHTED_ONLY, false));
        this.rankedListController.setIncludeTableInSavedImage(p.getBoolean(TABLE_IN_IMAGE, true));
        this.rankedListController.getRankedListDropComponent().getHighlightTrack().setDefaultLineWidth(lineWidthValue);
        this.rankedListController.getRankedListDropComponent().getHighlightTrack().setMinSize(minLineWidthValue);
        this.rankedListController.getRankedListDropComponent().getHighlightTrack().setMaxSize(maxLineWidthValue);
        this.rankedListController.setGridColumns(p.getBoolean(WRAP, true), p.getInt(GRID_COLUMNS_WRAP, 10), false);
        boolean drawGradient = p.getBoolean(DRAW_GRADIENT, false);
        boolean drawRanks = p.getBoolean(DRAW_RANKS, false);
        RankedListComponent[][] arr$ = elements;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RankedListComponent[] array;
            for (RankedListComponent rl : array = arr$[i$]) {
                if (rl == null) continue;
                rl.setNullColor(nullColor);
                rl.setPositiveColor(posColor);
                rl.setNegativeColor(negColor);
                rl.setBarWidth(barWidthValue);
                rl.setBarHeight(barHeightValue);
                rl.setLineThickness(lineThicknessValue);
                rl.setDrawGradient(drawGradient);
                rl.setDrawRanks(drawRanks);
            }
        }
        this.drawRanksCheckBox.setSelected(drawRanks);
        this.useGradient.setSelected(drawGradient);
        this.nullColorBtn.setColor(nullColor);
        this.negativeColorBtn.setColor(negColor);
        this.upColorBtn.setColor(posColor);
        this.barWidth.setValue(barWidthValue);
        this.barHeight.setValue(barHeightValue);
        this.lineWidth.setValue(lineWidthValue);
        this.lineThickness.setValue(lineThicknessValue);
        this.minLineWidth.setValue(this.rankedListController.getRankedListDropComponent().getHighlightTrack().getMinSize());
        this.maxLineWidth.setValue(this.rankedListController.getRankedListDropComponent().getHighlightTrack().getMaxSize());
        this.showHighlightedInstancesOnlyCheckBox.setSelected(this.rankedListController.isShowHighlightedInstancesOnly());
        this.includeTableInSavedImageCheckBox.setSelected(this.rankedListController.isIncludeTableInSavedImage());
    }

    private Preferences getPreferences() {
        Preferences p = Preferences.userNodeForPackage(RankedListComponent.class);
        p = p.node("RL-prefs");
        return p;
    }

    private void save(String name) {
        RankedListComponent rl = this.rankedListController.getRankedListComponents()[0][0];
        Preferences p = this.getPreferences();
        if (name != null) {
            p = p.node(name);
        }
        p.putInt(NULL_COLOR, rl.getNullColor().getRGB());
        p.putInt(POSITIVE_COLOR, rl.getPositiveColor().getRGB());
        p.putInt(NEGATIVE_COLOR, rl.getNegativeColor().getRGB());
        p.putInt(BAR_WIDTH, rl.getBarWidth());
        p.putInt(BAR_HEIGHT, rl.getBarHeight());
        p.putFloat(LINE_WIDTH, this.rankedListController.getRankedListDropComponent().getHighlightTrack().getDefaultLineWidth());
        p.putFloat(MIN_LINE_WIDTH, this.rankedListController.getRankedListDropComponent().getHighlightTrack().getMinSize());
        p.putFloat(MAX_LINE_WIDTH, this.rankedListController.getRankedListDropComponent().getHighlightTrack().getMaxSize());
        p.putFloat(LINE_THICKNESS, rl.getLineThickness());
        p.putBoolean(SHOW_HIGHLIGHTED_ONLY, this.rankedListController.isShowHighlightedInstancesOnly());
        p.putBoolean(TABLE_IN_IMAGE, this.rankedListController.isIncludeTableInSavedImage());
        p.putBoolean(SYNC_SELECTION, this.syncSelectionCheckBox.isSelected());
        p.putBoolean(DRAW_GRADIENT, rl.isDrawGradient());
        p.putBoolean(DRAW_RANKS, rl.isDrawRanks());
        p.putBoolean(WRAP, this.rankedListController.isWrapRankedLists());
        p.putInt(GRID_COLUMNS_WRAP, this.rankedListController.getGridColumns());
        try {
            p.sync();
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
    }

    private void updateSavedSettingsComboBox() {
        Object selection = this.savedSettingsComboBox.getSelectedItem();
        this.savedSettingsComboBox.removeAllItems();
        Preferences p = this.getPreferences();
        try {
            String[] childrenNames;
            for (String child : childrenNames = p.childrenNames()) {
                this.savedSettingsComboBox.addItem(child);
            }
            this.savedSettingsComboBox.setSelectedItem(selection);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    static Color getColor(Preferences p, String key, Color defaultColor) {
        int val = p.getInt(key, -2147483647);
        return val == -2147483647 ? defaultColor : new Color(val);
    }
}

