/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.cmap.rankedlist.RankedListTableModel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.table.TableUtil;

class RankedListTable
extends JTable {
    private boolean initted = false;
    private HighlightTrack highlightTrack;

    public RankedListTable(HighlightTrack highlightTrack, TableModel thisModel) {
        super(thisModel);
        this.highlightTrack = highlightTrack;
        this.setAutoResizeMode(0);
        this.setMinimumSize(new Dimension());
        this.setFont(new Font(UIUtil.getFontName(), 0, 12));
        this.setColumnSelectionAllowed(true);
        TableUtil.setRenderers(this, true);
        this.setGridColor(UIUtil.LIGHT_BLUE);
        TableUtil.addHandCursorMouseMotionListener(this, URL.class);
        this.initted = true;
    }

    @Override
    public void addColumn(TableColumn c) {
        super.addColumn(c);
        if (this.initted) {
            TableUtil.sizeColumn(this, c);
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        RankedListTableModel model = (RankedListTableModel)this.getModel();
        Object id = model.getVisibleRankedList().getId(row);
        int modelColumn = this.convertColumnIndexToModel(column);
        Vector vector = modelColumn >= 2 ? model.getMetadata().get(modelColumn - 2) : null;
        Color color = null;
        if (vector != null && MetadataUtil.getBoolean(vector, "Text Color Visible")) {
            color = (Color)this.highlightTrack.getColorModel().getMappedValue(vector, vector.getValue(row));
        }
        if (color == null) {
            color = Color.BLACK;
        }
        JComponent jc = (JComponent)c;
        jc.setForeground(color);
        if (this.convertColumnIndexToModel(column) == 0) {
            boolean highlighted;
            Color iconColor = null;
            boolean bl = highlighted = !this.highlightTrack.isEmpty() && this.highlightTrack.contains(id);
            if (highlighted) {
                iconColor = this.highlightTrack.getColor(id);
            }
            if (iconColor != null) {
                ((JLabel)c).setHorizontalTextPosition(2);
                ((JLabel)c).setIcon(new ColorIcon(iconColor));
            } else {
                ((JLabel)c).setIcon(null);
            }
        } else if (c instanceof JLabel) {
            ((JLabel)c).setIcon(null);
        }
        return c;
    }

    private static class ColorIcon
    implements Icon {
        private int colorWidth = 8;
        private int colorHeight = 8;
        private Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        @Override
        public int getIconHeight() {
            return this.colorHeight;
        }

        @Override
        public int getIconWidth() {
            return this.colorWidth;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.colorWidth, this.colorHeight);
        }
    }
}

