/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.cmap.rankedlist.RankedListDropComponent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterData;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterDropPanel;
import org.broadinstitute.genee.filter.CheckBoxListFilterUI;
import org.broadinstitute.genee.filter.FilterSelectionComponent;
import org.broadinstitute.genee.filter.RankedListFilterableAttribute;
import org.broadinstitute.genee.gui.grid.DropListPanel;
import org.broadinstitute.genee.matrix.Comparators;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class SavedRankedListSettings {
    private GroupBy[] groupRowsBy;
    private GroupBy[] groupColumnsBy;
    private SizeBy sizeBy;
    private ColorBy colorBy;
    private CheckBoxListSelection[] instances;
    private String name;

    public SavedRankedListSettings(String name, DropListPanel instancesPanel, HighlightTrack ht) {
        this.name = name;
        List<Object> instancesData = instancesPanel.getDroppedData();
        ArrayList<CheckBoxListSelection> checkBoxListSelectionList = new ArrayList<CheckBoxListSelection>();
        for (Object obj : instancesData) {
            RankedListFilterData filterData = (RankedListFilterData)obj;
            if (filterData.getFilterDialog().getFilterUI() instanceof CheckBoxListFilterUI) {
                CheckBoxListFilterUI filterUI = (CheckBoxListFilterUI)filterData.getFilterDialog().getFilterUI();
                FilterSelectionComponent filterSelectionComponent = filterUI.getFilterSelectionComponent();
                CheckBoxListSelection checkBoxListSelection = new CheckBoxListSelection();
                checkBoxListSelection.name = filterData.toString();
                checkBoxListSelection.selection = filterSelectionComponent.getSelectedItems();
                checkBoxListSelectionList.add(checkBoxListSelection);
            }
            this.instances = checkBoxListSelectionList.toArray(new CheckBoxListSelection[0]);
        }
        if (ht.getGroupColumnsBy() != null) {
            this.groupColumnsBy = new GroupBy[ht.getGroupColumnsBy().length];
            SavedRankedListSettings.setGroupBy(this.groupColumnsBy, ht.getGroupColumnsBy());
        }
        if (ht.getGroupRowsBy() != null) {
            this.groupRowsBy = new GroupBy[ht.getGroupRowsBy().length];
            SavedRankedListSettings.setGroupBy(this.groupRowsBy, ht.getGroupRowsBy());
        }
        if (ht.getSizeBy() != null) {
            this.sizeBy = new SizeBy();
            this.sizeBy.name = ht.getSizeBy().getName();
            this.sizeBy.continuous = ht.isSizeByContinuous();
        }
        if (ht.getColorBy() != null) {
            this.colorBy = new ColorBy();
            this.colorBy.name = ht.getColorBy().getName();
            this.colorBy.continuous = MetadataUtil.getBoolean(ht.getColorBy(), "Discrete Key");
        }
    }

    public void load(DropListPanel groupRowsByPanel, DropListPanel groupColumnsByPanel, DropListPanel sizeByPanel, DropListPanel colorByPanel, DropListPanel instancesPanel, RankedListFilterableAttribute[] attributes) {
        RankedListFilterableAttribute attr;
        if (this.groupRowsBy != null) {
            SavedRankedListSettings.loadGroupBy(groupRowsByPanel, this.groupRowsBy, attributes);
        }
        if (this.groupColumnsBy != null) {
            SavedRankedListSettings.loadGroupBy(groupColumnsByPanel, this.groupColumnsBy, attributes);
        }
        if (this.sizeBy != null && (attr = RankedListDropComponent.getFilterAttributeByName(attributes, this.sizeBy.name)) != null) {
            sizeByPanel.drop(attr, false);
        }
        if (this.colorBy != null && (attr = RankedListDropComponent.getFilterAttributeByName(attributes, this.colorBy.name)) != null) {
            colorByPanel.drop(attr, false);
        }
        if (this.instances != null) {
            for (CheckBoxListSelection selection : this.instances) {
                RankedListFilterableAttribute attr2 = RankedListDropComponent.getFilterAttributeByName(attributes, selection.name);
                if (attr2 == null) continue;
                ((RankedListFilterDropPanel)instancesPanel).programatticDrop(attr2, selection.selection);
            }
        }
    }

    public String toXML() {
        return SavedRankedListSettings.getXStream().toXML((Object)this);
    }

    public static SavedRankedListSettings fromXML(String xml) {
        return (SavedRankedListSettings)SavedRankedListSettings.getXStream().fromXML(xml);
    }

    private static XStream getXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.alias("setting", SavedRankedListSettings.class);
        xstream.alias("filter-selection", CheckBoxListSelection.class);
        xstream.alias("groupBy", GroupBy.class);
        xstream.alias("colorBy", ColorBy.class);
        xstream.alias("sizeBy", SizeBy.class);
        return xstream;
    }

    private static void loadGroupBy(DropListPanel dropListPanel, GroupBy[] groupByArray, RankedListFilterableAttribute[] attributes) {
        if (groupByArray != null) {
            for (GroupBy groupBy : groupByArray) {
                RankedListFilterableAttribute attribute = RankedListDropComponent.getFilterAttributeByName(attributes, groupBy.name);
                if (attribute == null) continue;
                dropListPanel.drop(attribute, false);
            }
        }
    }

    private static void setGroupBy(GroupBy[] groupBy, Vector[] groupByVectors) {
        for (int i = 0; i < groupBy.length; ++i) {
            groupBy[i] = new GroupBy();
            groupBy[i].name = groupByVectors[i].getName();
            Comparator<Object> comparator = groupByVectors[i].getComparator();
            if (comparator == null) {
                groupBy[i].sortOrderFlag = GroupBy.SORT_ORDER.ASCENDING;
                continue;
            }
            if (comparator instanceof Comparators.DescendingComparator) {
                groupBy[i].sortOrderFlag = GroupBy.SORT_ORDER.DESCENDING;
                continue;
            }
            Object[] values = VectorUtil.getValues(groupByVectors[i]).toArray();
            Arrays.sort(values, groupByVectors[i].getComparator());
            GroupBy.access$1202(groupBy[i], values);
        }
    }

    private static class SizeBy {
        private String name;
        private boolean continuous;

        private SizeBy() {
        }
    }

    private static class GroupBy {
        private String name;
        private Object[] sortOrder;
        private SORT_ORDER sortOrderFlag;

        private GroupBy() {
        }

        static /* synthetic */ Object[] access$1202(GroupBy x0, Object[] x1) {
            x0.sortOrder = x1;
            return x1;
        }

        private static enum SORT_ORDER {
            ASCENDING,
            DESCENDING,
            CUSTOM;

        }
    }

    private static class ColorBy {
        private String name;
        private boolean continuous;

        private ColorBy() {
        }
    }

    private static class CheckBoxListSelection {
        private Collection<Object> selection;
        private String name;

        private CheckBoxListSelection() {
        }
    }
}

