/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackEvent;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrackListener;
import org.broadinstitute.genee.gui.JLabelFaded;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.Formatter;

public class SizeByLegend
extends JPanel {
    private CellConstraints cc;
    private FormLayout formLayout;
    private HighlightTrack highlightTrack;

    public SizeByLegend(final HighlightTrack highlightTrack) {
        this.highlightTrack = highlightTrack;
        this.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
        this.setBackground(Color.WHITE);
        this.formLayout = new FormLayout("p", "");
        this.setLayout((LayoutManager)this.formLayout);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.cc = new CellConstraints();
        highlightTrack.addHighlightTrackListener(new HighlightTrackListener(){

            @Override
            public void trackChanged(HighlightTrackEvent e) {
                SizeByLegend.this.formLayout = new FormLayout("p", "");
                SizeByLegend.this.setLayout((LayoutManager)SizeByLegend.this.formLayout);
                SizeByLegend.this.removeAll();
                SizeByLegend.this.setVisible(highlightTrack.getSizeBy() != null && !highlightTrack.isEmpty());
                if (highlightTrack.getSizeBy() != null && !highlightTrack.isEmpty()) {
                    JLabel label = new JLabel(highlightTrack.getSizeBy().getName());
                    label.setFont(label.getFont().deriveFont(1));
                    SizeByLegend.this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
                    SizeByLegend.this.add((Component)label, SizeByLegend.this.cc.xy(1, SizeByLegend.this.formLayout.getRowCount()));
                    SizeByLegend.this.formLayout.appendRow(UIUtil.decodeRowSpec("6px"));
                    SizeByLegend.this.createSizeByLegend(!highlightTrack.isSizeByContinuous(), highlightTrack.getValueToSizeMap());
                }
                SizeByLegend.this.revalidate();
                SizeByLegend.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                highlightTrack.clearHighlightedSizes();
            }
        });
        this.setVisible(false);
        this.setMinimumSize(new Dimension());
    }

    private void createSizeByLegend(boolean discrete, Map<Object, Float> valueToSizeMap) {
        boolean highlightedSizesEmpty = this.highlightTrack.isHighlightedSizesEmpty();
        if (discrete) {
            boolean first = true;
            for (Object value : valueToSizeMap.keySet()) {
                boolean faded = !highlightedSizesEmpty && !this.highlightTrack.isSizeHighlighted(value);
                boolean highlighted = !highlightedSizesEmpty && this.highlightTrack.isSizeHighlighted(value);
                JLabel label = this.createLabel(faded, highlighted, value);
                float width = valueToSizeMap.get(value).floatValue();
                label.setIcon(new SizeIcon(width, this.highlightTrack.getMaxSize()));
                if (value != null) {
                    label.setText(Formatter.toString(value));
                }
                if (!first) {
                    this.formLayout.appendRow(UIUtil.decodeRowSpec("4px"));
                }
                this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
                this.add((Component)label, this.cc.xy(1, this.formLayout.getRowCount()));
                first = false;
            }
        } else {
            boolean first = true;
            int index = 0;
            HashSet<Integer> indices = new HashSet<Integer>();
            indices.add(0);
            indices.add(valueToSizeMap.size() / 2);
            indices.add(valueToSizeMap.size() - 1);
            for (Object value : valueToSizeMap.keySet()) {
                if (indices.contains(index)) {
                    JLabel label = new JLabel();
                    float width = valueToSizeMap.get(value).floatValue();
                    label.setIcon(new SizeIcon(width, this.highlightTrack.getMaxSize()));
                    if (value != null) {
                        label.setText(Formatter.toString(value));
                    }
                    if (!first) {
                        this.formLayout.appendRow(UIUtil.decodeRowSpec("4px"));
                    }
                    this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
                    this.add((Component)label, this.cc.xy(1, this.formLayout.getRowCount()));
                    first = false;
                }
                ++index;
            }
        }
    }

    private JLabel createLabel(boolean faded, final boolean bolded, final Object value) {
        JLabel label = null;
        label = faded ? new JLabelFaded(true) : new JLabel();
        if (bolded) {
            label.setFont(label.getFont().deriveFont(1));
        }
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean additional = e.isShiftDown();
                if (!bolded) {
                    SizeByLegend.this.highlightTrack.addHighlightedSize(value, !additional);
                } else if (!additional) {
                    SizeByLegend.this.highlightTrack.clearHighlightedSizes();
                } else {
                    SizeByLegend.this.highlightTrack.removeHighlightedSize(value);
                }
            }
        });
        return label;
    }

    private static class SizeIcon
    implements Icon {
        private float maxSize;
        private Line2D.Float shape = new Line2D.Float();
        private float size;

        public SizeIcon(float size, float maxSize) {
            this.size = size;
            this.maxSize = maxSize;
        }

        @Override
        public int getIconHeight() {
            return 2;
        }

        @Override
        public int getIconWidth() {
            return (int)(1.0f + this.maxSize);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            this.shape.x1 = x;
            this.shape.y1 = y;
            this.shape.x2 = (float)x + this.size;
            this.shape.y2 = y;
            ((Graphics2D)g).draw(this.shape);
        }
    }
}

