/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideButton;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.UIUtil;

class AddMetadataPanel
extends JPanel {
    JList list;

    AddMetadataPanel() {
        this.setLayout((LayoutManager)new JideBorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 24, 0, 24));
        this.list = new JList(new DefaultListModel());
        this.list.setVisibleRowCount(5);
        ((DefaultListModel)this.list.getModel()).addElement("Plate");
        ((DefaultListModel)this.list.getModel()).addElement("Well");
        ((DefaultListModel)this.list.getModel()).addElement("Cell");
        ((DefaultListModel)this.list.getModel()).addElement("Drug");
        JPanel btnPanel = this.createButtonPanel();
        JScrollPane sp = UIUtil.createNoBorderScrollPane(this.list);
        this.add((Component)new JLabel("Metadata fields"), "North");
        this.add(sp);
        this.add((Component)btnPanel, "West");
        JButton addButton = new JButton("Add metadata field");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = UIUtil.showInputDialog(AddMetadataPanel.this.list, "Please enter a metadata name", "");
                if (name != null && !name.equals("")) {
                    ((DefaultListModel)AddMetadataPanel.this.list.getModel()).addElement(name);
                }
            }
        });
        this.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)addButton), "South");
    }

    public String[] getFields() {
        ListModel listModel = this.list.getModel();
        String[] fields = new String[listModel.getSize()];
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            fields[i] = (String)listModel.getElementAt(i);
        }
        return fields;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new FormLayout("pref:none", "15px, pref:none, 5px, pref:none, 5px, pref:none"));
        CellConstraints cc = new CellConstraints();
        final JideButton moveUpButton = new JideButton((Icon)new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveUp.png")));
        moveUpButton.setToolTipText("Move the selected items up");
        final JideButton moveDownButton = new JideButton((Icon)new ImageIcon(this.getClass().getResource("/com/jidesoft/list/icons/moveDown.png")));
        moveDownButton.setToolTipText("Move the selected items down");
        final JideButton deleteBtn = new JideButton((Icon)IconManager.loadIcon("16x16/14763.delete.gif"));
        deleteBtn.setToolTipText("Delete the selected items");
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block5: {
                    int[] selected;
                    DefaultListModel model;
                    block6: {
                        block4: {
                            model = (DefaultListModel)AddMetadataPanel.this.list.getModel();
                            selected = AddMetadataPanel.this.list.getSelectedIndices();
                            if (selected == null || selected.length == 0) {
                                return;
                            }
                            if (e.getSource() != deleteBtn) break block4;
                            for (int idx : selected) {
                                model.remove(idx);
                            }
                            break block5;
                        }
                        if (e.getSource() != moveDownButton) break block6;
                        for (int idx : selected) {
                            if (idx >= model.size() - 1) continue;
                            Object obj = model.remove(idx);
                            model.add(idx + 1, obj);
                        }
                        break block5;
                    }
                    if (e.getSource() != moveUpButton) break block5;
                    for (int idx : selected) {
                        if (idx <= 0) continue;
                        Object obj = model.remove(idx);
                        model.add(idx - 1, obj);
                    }
                }
            }
        };
        moveUpButton.addActionListener(l);
        moveDownButton.addActionListener(l);
        deleteBtn.addActionListener(l);
        panel.add((Component)moveUpButton, cc.xy(1, 2));
        panel.add((Component)moveDownButton, cc.xy(1, 4));
        panel.add((Component)deleteBtn, cc.xy(1, 6));
        return panel;
    }
}

