/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import com.google.common.collect.Iterables;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.broadinstitute.genee.compound.painter.DefaultImageSupplier;
import org.broadinstitute.genee.compound.painter.ImageElement;
import org.broadinstitute.genee.compound.painter.ImageSupplier;
import org.broadinstitute.genee.heatmap.ElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class ImageElementPainter
implements ElementPainter {
    private ImageSupplier imageSupplier;
    private int seriesIndex;

    public ImageElementPainter() {
        this(new DefaultImageSupplier());
    }

    public ImageElementPainter(ImageSupplier imageSupplier) {
        this.imageSupplier = imageSupplier;
    }

    @Override
    public ElementPainter copy() {
        ImageElementPainter imageElementPainter = new ImageElementPainter(this.imageSupplier);
        return imageElementPainter;
    }

    @Override
    public void draw(Graphics2D g, Dataset dataset, int row, int column, float xpix, float ypix, float columnSize, float rowSize) {
        if (this.seriesIndex < 0) {
            return;
        }
        ImageElement element = (ImageElement)dataset.getObjectValue(row, column, this.seriesIndex);
        if (element == null || element.getFiles() == null || element.getFiles().size() == 0) {
            g.setColor(Color.BLACK);
            String s = "?";
            g.drawString(s, (int)(xpix + columnSize / 2.0f - (float)(g.getFontMetrics().stringWidth(s) / 2)), (int)(ypix + rowSize / 2.0f));
            return;
        }
        List<Collection<File>> imageTypesList = element.getFiles();
        if (imageTypesList != null) {
            int ntypes = imageTypesList.size();
            if (ntypes == 0) {
                return;
            }
            float imageWidth = columnSize;
            float imageHeight = rowSize;
            int numImages = 0;
            for (int i = 0; i < ntypes; ++i) {
                numImages += imageTypesList.get(i).size();
            }
            if (numImages > 1) {
                imageWidth /= 2.0f;
                int heightFactor = numImages / 2;
                imageHeight /= (float)heightFactor;
            }
            AffineTransform t = g.getTransform();
            Collection<File> allFiles = null;
            for (int i = 0; i < ntypes; ++i) {
                Collection<File> files = imageTypesList.get(i);
                allFiles = allFiles == null ? files : Iterables.concat(allFiles, files);
            }
            try {
                this.drawFiles(allFiles, g, (int)xpix, (int)ypix, false, (int)imageWidth, (int)imageHeight, numImages);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            g.setTransform(t);
            if (numImages > 1 && numImages < 10) {
                Stroke stroke = g.getStroke();
                g.setStroke(new BasicStroke(0.5f, 2, 2, 0.5f, new float[]{2.0f, imageHeight / 10.0f}, 0.0f));
                Line2D.Float line = new Line2D.Float();
                g.setColor(Color.YELLOW);
                line.setLine(xpix + imageWidth, ypix, xpix + imageWidth, ypix + rowSize);
                g.draw(line);
                float y = ypix;
                int nrows = (int)Math.ceil((float)numImages / 2.0f);
                if (nrows > 1) {
                    for (int i = 0; i < nrows; ++i) {
                        line.setLine(xpix, y, xpix + 2.0f * imageWidth, y);
                        g.draw(line);
                        y += imageHeight;
                    }
                }
                g.setStroke(stroke);
            }
        }
    }

    @Override
    public boolean setColorScheme(HeatMapColorScheme colorScheme) {
        return false;
    }

    @Override
    public void setProject(Project p) {
        this.seriesIndex = DatasetUtil.getSeriesIndex(p.getOriginalDataset(), ImageElement.class);
    }

    private int drawFiles(Iterable<File> files, Graphics2D g, int xpix, int ypix, boolean c0, int imageWidth, int imageHeight, int numFiles) throws IOException {
        int i = 0;
        for (File file : files) {
            Image image = this.imageSupplier.getImage(file, imageWidth, imageHeight);
            int imageX = ImageElementPainter.getImageX(i, xpix, imageWidth);
            int imageY = ImageElementPainter.getImageY(i, ypix, imageHeight);
            if (image != null) {
                g.drawImage(image, imageX, imageY, null);
            } else {
                System.out.println("Unable to get image");
            }
            ++i;
        }
        return i;
    }

    public static int getImageX(int i, int imageX, int columnSizePerImage) {
        return i % 2 == 1 ? imageX + columnSizePerImage : imageX;
    }

    public static int getImageY(int i, int imageY, int rowSizePerImage) {
        return i / 2 * rowSizePerImage + imageY;
    }
}

