/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.compound.painter.DefaultImageSupplier;
import org.broadinstitute.genee.compound.painter.ImageElementPainter;
import org.broadinstitute.genee.compound.painter.ImageImportCustomizer;
import org.broadinstitute.genee.compound.painter.ImageLayoutChooser;
import org.broadinstitute.genee.compound.painter.ImageTypePanel;
import org.broadinstitute.genee.compound.painter.PlateLayoutPanel;
import org.broadinstitute.genee.compound.painter.WellLayoutPanel;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.CloseablePanel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class ImportImageWindow
extends JPanel {
    private CellConstraints cc = new CellConstraints();
    private FormLayout formLayout;
    private JPanel typeListPanel;
    private List<ImageTypePanel> imageTypePanels = new ArrayList<ImageTypePanel>();
    private GENEEWindow window = Application.createDialog("Import Images");
    private JScrollPane scrollPane;
    private JComboBox savedSettingsComboBox;

    public ImportImageWindow() {
        this.formLayout = new FormLayout("p", "");
        this.typeListPanel = new JPanel((LayoutManager)this.formLayout);
        this.typeListPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new BorderLayout());
        this.scrollPane = UIUtil.createNoBorderScrollPane(this.typeListPanel);
        this.add(this.scrollPane);
        JButton addImageTypeButton = new JButton("Add image type");
        addImageTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportImageWindow.this.addImageType();
            }
        });
        JButton saveSettings = new JButton("Save Current Settings\u2026");
        saveSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ImageTypePanel p : ImportImageWindow.this.imageTypePanels) {
                    p.updateValues();
                }
                String savedSettingsName = UIUtil.showInputDialog(ImportImageWindow.this.window.getContentPane(), "Saved settings name", "");
                if (savedSettingsName != null && !savedSettingsName.equals("")) {
                    Preferences parent = Preferences.userNodeForPackage(ImportImageWindow.class).node(savedSettingsName);
                    int size = ImportImageWindow.this.imageTypePanels.size();
                    for (int i = 0; i < size; ++i) {
                        ImageTypePanel p = (ImageTypePanel)ImportImageWindow.this.imageTypePanels.get(i);
                        Preferences prefs = parent.node(String.valueOf(i));
                        boolean userSuppliedRegex = p.isUserSuppliedRegex();
                        prefs.putBoolean("userSuppliedRegex", userSuppliedRegex);
                        if (!userSuppliedRegex) {
                            char metadataSeparatorChar = p.getMetadataSeparatorChar();
                            prefs.putInt("metadataSeparatorChar", metadataSeparatorChar);
                            List<String> patternGroupNames = p.getPatternGroupNames();
                            IOUtil.saveList(patternGroupNames, prefs, "patternGroupName");
                        } else {
                            String regex = p.getUserRegularExpression();
                            prefs.put("regex", regex);
                        }
                        String textImagesHaveInCommon = p.getTextImagesHaveInCommon();
                        prefs.put("textImagesHaveInCommon", textImagesHaveInCommon);
                        boolean searchRecursively = p.isRecursive();
                        prefs.putBoolean("searchRecursively", searchRecursively);
                        String imageTypeName = p.getImageTypeName();
                        prefs.put("imageTypeName", imageTypeName);
                        File imageDirectory = p.getImageDirectory();
                        prefs.put("imageDirectory", IOUtil.getPath(imageDirectory));
                    }
                }
                ImportImageWindow.this.updateSavedSettings();
            }
        });
        JPanel loadSavedPanel = new JPanel((LayoutManager)new FormLayout("p, 6px, p, 6px, p, 6px, p", "p"));
        loadSavedPanel.add((Component)new JLabel("Saved settings:"), this.cc.xy(1, 1));
        this.savedSettingsComboBox = UIUtil.createComboBox();
        loadSavedPanel.add((Component)this.savedSettingsComboBox, this.cc.xy(3, 1));
        this.updateSavedSettings();
        JButton loadSettings = new JButton("Load");
        loadSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String savedSettingName = (String)ImportImageWindow.this.savedSettingsComboBox.getSelectedItem();
                    if (savedSettingName != null) {
                        String[] children;
                        ImportImageWindow.this.typeListPanel.removeAll();
                        ImportImageWindow.this.imageTypePanels.clear();
                        ImportImageWindow.this.formLayout = new FormLayout("p", "");
                        ImportImageWindow.this.typeListPanel.setLayout((LayoutManager)ImportImageWindow.this.formLayout);
                        ImportImageWindow.this.typeListPanel.revalidate();
                        ImportImageWindow.this.typeListPanel.repaint();
                        Preferences rootPref = Preferences.userNodeForPackage(ImportImageWindow.class);
                        Preferences settingPref = rootPref.node(savedSettingName);
                        for (String child : children = settingPref.childrenNames()) {
                            ImageTypePanel imageTypePanel = ImportImageWindow.this.addImageType();
                            Preferences prefs = settingPref.node(child);
                            boolean userSuppliedRegex = prefs.getBoolean("userSuppliedRegex", false);
                            imageTypePanel.setUserSuppliedRegex(userSuppliedRegex);
                            if (!userSuppliedRegex) {
                                char metadataSeparatorChar = (char)prefs.getInt("metadataSeparatorChar", 95);
                                imageTypePanel.setMetadataSeparatorChar(metadataSeparatorChar);
                                List<String> patternGroupNames = IOUtil.loadList(prefs, "patternGroupName");
                                imageTypePanel.setPatternGroupNames(patternGroupNames);
                            } else {
                                String regex = prefs.get("regex", "");
                                imageTypePanel.setUserRegularExpression(regex);
                            }
                            String textImagesHaveInCommon = prefs.get("textImagesHaveInCommon", "");
                            imageTypePanel.setTextImagesHaveInCommon(textImagesHaveInCommon);
                            boolean searchRecursively = prefs.getBoolean("searchRecursively", true);
                            imageTypePanel.setSearchRecursively(searchRecursively);
                            String imageTypeName = prefs.get("imageTypeName", "");
                            imageTypePanel.setImageTypeName(imageTypeName);
                            String imageDirectory = prefs.get("imageDirectory", "");
                            imageTypePanel.setImageDirectory(imageDirectory);
                        }
                    }
                }
                catch (BackingStoreException e1) {
                    e1.printStackTrace();
                }
            }
        });
        loadSavedPanel.add((Component)loadSettings, this.cc.xy(5, 1));
        JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String savedSettingName = (String)ImportImageWindow.this.savedSettingsComboBox.getSelectedItem();
                if (savedSettingName != null) {
                    Preferences rootPref = Preferences.userNodeForPackage(ImportImageWindow.class);
                    Preferences settingPref = rootPref.node(savedSettingName);
                    try {
                        settingPref.removeNode();
                    }
                    catch (BackingStoreException e1) {
                        e1.printStackTrace();
                    }
                    ImportImageWindow.this.updateSavedSettings();
                }
            }
        });
        loadSavedPanel.add((Component)deleteButton, this.cc.xy(7, 1));
        JButton importButton = new JButton("Import");
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ImageTypePanel p : ImportImageWindow.this.imageTypePanels) {
                    p.updateValues();
                }
                ImportImageWindow.this.window.dispose();
                new BackgroundTask<Void>("Searching"){

                    @Override
                    protected Void doInBackground() throws Exception {
                        this.setPercentComplete(1.0f);
                        int npanels = ImportImageWindow.this.imageTypePanels.size();
                        for (int i = 0; i < npanels; ++i) {
                            ImageTypePanel imageTypePanel = (ImageTypePanel)ImportImageWindow.this.imageTypePanels.get(i);
                            this.setPercentComplete(((float)i + 1.0f) / (float)(1 + npanels));
                            imageTypePanel.findFiles(this);
                        }
                        return null;
                    }

                    @Override
                    protected void succeeded(Void v) {
                        String label;
                        ImageElementPainter imageElementPainter = new ImageElementPainter(new DefaultImageSupplier());
                        int[] nfiles = new int[ImportImageWindow.this.imageTypePanels.size()];
                        for (int i = 0; i < nfiles.length; ++i) {
                            ImageTypePanel imageTypePanel = (ImageTypePanel)ImportImageWindow.this.imageTypePanels.get(i);
                            File[] files = imageTypePanel.getImageFiles();
                            nfiles[i] = files.length;
                        }
                        if (nfiles.length > 1) {
                            StringBuilder buf = new StringBuilder();
                            for (int i = 0; i < nfiles.length; ++i) {
                                ImageTypePanel imageTypePanel = (ImageTypePanel)ImportImageWindow.this.imageTypePanels.get(i);
                                buf.append(nfiles[i] + " " + imageTypePanel.getImageTypeName() + " images found. ");
                            }
                            label = buf.toString();
                        } else {
                            label = nfiles[0] + " images found";
                        }
                        DefaultProject sharedProject = new DefaultProject(new RowMajorArray2DDataset("Image Import", 1, 1));
                        ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(sharedProject, new History("Import Images"));
                        Application.add(new GENEEFolderNode("Import Images", node.getAuditTrail().last(), node));
                        new ImageImportCustomizer(imageElementPainter).customize(node.getDisplayInfo().getComponent());
                        GENEEWindow imagesRowsAndColumnsDialog = Application.createDialog("Select heat map rows and columns");
                        JTabbedPane tabbedPane = UIUtil.createTabbedPane();
                        HeatMapPanel heatMapPanel = (HeatMapPanel)node.getDisplayInfo().getComponent();
                        heatMapPanel.setColumnSize(100.0f);
                        heatMapPanel.setRowSize(100.0f);
                        tabbedPane.addTab("Heat Map Layout", new ImageLayoutChooser(heatMapPanel, sharedProject, ImportImageWindow.this.imageTypePanels));
                        tabbedPane.addTab("Plate View", new PlateLayoutPanel(heatMapPanel, sharedProject, ImportImageWindow.this.imageTypePanels));
                        tabbedPane.addTab("Well View", new WellLayoutPanel(heatMapPanel, sharedProject, ImportImageWindow.this.imageTypePanels));
                        imagesRowsAndColumnsDialog.getContentPane().add(tabbedPane);
                        imagesRowsAndColumnsDialog.getContentPane().add((Component)new JLabel(label), "South");
                        imagesRowsAndColumnsDialog.pack();
                        imagesRowsAndColumnsDialog.setVisible(true);
                    }
                }.execute();
            }
        });
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)addImageTypeButton), "North");
        JPanel buttonPanel = new JPanel((LayoutManager)new FormLayout("p:g", "12px, p, 6px, p, 6px, p, 6px, p"));
        buttonPanel.add((Component)new JSeparator(), this.cc.xy(1, 2));
        JPanel p1 = new JPanel((LayoutManager)new FormLayout("p", "p"));
        p1.add((Component)saveSettings, this.cc.xy(1, 1));
        buttonPanel.add((Component)p1, this.cc.xy(1, 4));
        buttonPanel.add((Component)loadSavedPanel, this.cc.xy(1, 6));
        JPanel p2 = ButtonBarFactory.buildRightAlignedBar((JButton)importButton);
        buttonPanel.add((Component)p2, new CellConstraints(1, 8, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        southPanel.add((Component)buttonPanel, "Center");
        this.add((Component)southPanel, "South");
        addImageTypeButton.doClick();
        this.window.getRootPane().setDefaultButton(importButton);
        this.window.getContentPane().add(this);
        this.window.pack();
        this.window.setVisible(true);
    }

    private void updateSavedSettings() {
        Preferences rootPref = Preferences.userNodeForPackage(ImportImageWindow.class);
        String[] rootChildren = new String[]{};
        try {
            rootChildren = rootPref.childrenNames();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.savedSettingsComboBox.getModel();
        model.removeAllElements();
        for (String child : rootChildren) {
            model.addElement(child);
        }
    }

    private ImageTypePanel addImageType() {
        this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
        final ImageTypePanel imageTypePanel = new ImageTypePanel(this.imageTypePanels.size() > 0 ? this.imageTypePanels.get(this.imageTypePanels.size() - 1) : null);
        this.imageTypePanels.add(imageTypePanel);
        final CloseablePanel cp = new CloseablePanel(imageTypePanel, "");
        ActionListener closeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportImageWindow.this.typeListPanel.remove(cp.getComponent());
                ImportImageWindow.this.imageTypePanels.remove(imageTypePanel);
                ImportImageWindow.this.typeListPanel.revalidate();
                ImportImageWindow.this.typeListPanel.repaint();
            }
        };
        cp.addCloseActionListener(closeListener);
        this.typeListPanel.add(cp.getComponent(), this.cc.xy(1, this.formLayout.getRowCount()));
        this.typeListPanel.revalidate();
        this.typeListPanel.repaint();
        this.window.pack();
        this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
        return imageTypePanel;
    }
}

