/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.google.common.base.Function;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import org.broadinstitute.genee.filter.FilterSelectionComponent;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.filter.SetIndexedFilter;

public class CheckBoxListFilterUI<T>
implements FilterUI {
    protected String filterName;
    protected Set selectedValuesSet;
    protected FilterSelectionComponent filterSelectionComponent;
    private Function<String, Object> stringToValueConverter;

    public CheckBoxListFilterUI(String filterName, Collection values, Function<String, Object> stringToValueConverter) {
        this.filterName = filterName;
        this.stringToValueConverter = stringToValueConverter;
        this.init(values);
    }

    @Override
    public IndexedFilter apply() {
        this.filterSelectionComponent.saveState();
        this.selectedValuesSet = this.filterSelectionComponent.getSelectedItems();
        return new SetIndexedFilter(this.selectedValuesSet);
    }

    @Override
    public void cancel() {
        this.filterSelectionComponent.restoreState();
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    public FilterSelectionComponent getFilterSelectionComponent() {
        return this.filterSelectionComponent;
    }

    @Override
    public Component getUserInterfaceComponent() {
        return this.filterSelectionComponent.getComponent();
    }

    private void init(Collection values) {
        this.filterSelectionComponent = new FilterSelectionComponent(values){

            @Override
            protected Object parseTextAreaLine(String token) {
                return CheckBoxListFilterUI.this.stringToValueConverter.apply((Object)token);
            }
        };
        this.selectedValuesSet = this.filterSelectionComponent.getSelectedItems();
    }
}

