/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.filter.FilterComponent;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.filter.GT;
import org.broadinstitute.genee.filter.GTE;
import org.broadinstitute.genee.filter.LT;
import org.broadinstitute.genee.filter.LTE;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

public class ComparisonFilterComponent
extends JPanel
implements FilterComponent {
    protected static final int GREATER_THAN = 0;
    protected static final int GREATER_THAN_OR_EQUAL = 2;
    protected static final int LESS_THAN = 1;
    protected static final int LESS_THAN_OR_EQUAL = 3;
    private Filters.FloatFilterAdapter filter;

    @Override
    public String toString() {
        return this.filter.toString();
    }

    public ComparisonFilterComponent(Filters.FloatFilterAdapter filter) {
        this.filter = filter;
        final JComboBox comparisonComboBox = UIUtil.createComboBox(new Object[]{">", "<", ">=", "<="});
        comparisonComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComparisonFilterComponent.this.setComparison(comparisonComboBox.getSelectedIndex());
            }
        });
        CellConstraints cc = new CellConstraints();
        TimerTextField valueTextField = new TimerTextField(""){

            @Override
            public void update() {
                try {
                    String text = this.getText();
                    if (text != null) {
                        ComparisonFilterComponent.this.setValue(ParserHelper.parseFloat(text.trim()));
                    } else {
                        ComparisonFilterComponent.this.setValue(Float.NaN);
                    }
                }
                catch (NumberFormatException nfe) {
                    ComparisonFilterComponent.this.setValue(Float.NaN);
                }
            }
        };
        this.setLayout((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(3), "p"));
        this.add((Component)comparisonComboBox, cc.xy(1, 1));
        this.add((Component)valueTextField, cc.xy(3, 1));
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    protected void setComparison(int comparison) {
        if (comparison == 0) {
            this.filter.setFloatFilter(new GT());
        } else if (comparison == 1) {
            this.filter.setFloatFilter(new LT());
        } else if (comparison == 2) {
            this.filter.setFloatFilter(new GTE());
        } else if (comparison == 3) {
            this.filter.setFloatFilter(new LTE());
        }
    }

    protected void setValue(float d) {
        this.filter.setValue(d);
    }
}

