/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.filter.CombinedFilter;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.filter.FilterComponent;
import org.broadinstitute.genee.filter.FilterComponentCreator;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.CloseablePanel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class FilterPanel {
    private CellConstraints cc = new CellConstraints();
    private CombinedFilter combinedFilter;
    private JPanel filtersPanel;
    private JScrollPane filtersScrollPane;
    private FormLayout formLayout;
    private AddFilterControl addFilterControl;

    public FilterPanel(Project project, List<? extends FilterComponentCreator> filterComponents) {
        FormBuilder topPanel = new FormBuilder();
        ButtonGroupHelper buttonGroupHelper = new ButtonGroupHelper();
        final JRadioButton andButton = buttonGroupHelper.createRadioButton("Require rows to pass all filters");
        JRadioButton orButton = buttonGroupHelper.createRadioButton("Require rows to pass at least one filter", true);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterPanel.this.combinedFilter.setAndFilter(e.getSource() == andButton);
            }
        };
        andButton.addActionListener(l);
        orButton.addActionListener(l);
        topPanel.nextRow();
        topPanel.addFirstColumn(orButton);
        topPanel.add(andButton);
        this.formLayout = new FormLayout("p", "");
        this.filtersPanel = new JPanel((LayoutManager)this.formLayout);
        this.filtersPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel filtersPanelPlusAddButton = new JPanel(new BorderLayout());
        filtersPanelPlusAddButton.add((Component)topPanel.getPanel(), "North");
        filtersPanelPlusAddButton.add((Component)this.filtersPanel, "Center");
        this.addFilterControl = new AddFilterControl(filterComponents);
        filtersPanelPlusAddButton.add((Component)this.addFilterControl.getComponent(), "South");
        this.filtersScrollPane = new JScrollPane(filtersPanelPlusAddButton, 20, 31);
        this.filtersScrollPane.setBorder(null);
        Filter filter = project.getRowFilter();
        if (filter instanceof CombinedFilter) {
            this.combinedFilter = (CombinedFilter)filter;
            for (Filter f : this.combinedFilter.getFilters()) {
                FilterComponent c = Filters.createFilterComponent(f);
                if (c == null) continue;
                this.addFilterControl.addFilter(c, false);
            }
            andButton.setSelected(this.combinedFilter.isAndFilter());
        } else {
            this.combinedFilter = new CombinedFilter();
            project.setRowFilter(this.combinedFilter);
        }
    }

    public Component getComponent() {
        return this.filtersScrollPane;
    }

    public Filter getFilter() {
        return this.combinedFilter;
    }

    public static List<FilterComponentCreator> getDefaultFilterComponentCreators(MetadataModel model) {
        List<String> moleculeColumns;
        ArrayList<FilterComponentCreator> list = new ArrayList<FilterComponentCreator>();
        list.add(Filters.createTopFilterComponent());
        list.addAll(Filters.createNumberMetadataFilters());
        list.add(Filters.createTextFilterComponent());
        if (UserUtil.isBroadUser() && (moleculeColumns = MetadataUtil.getColumnNames(model, MoleculeUtil.getMoleculeClass())).size() > 0) {
            list.add(Filters.createStructuralFilterComponent(moleculeColumns.get(0)));
        }
        return list;
    }

    private class AddFilterControl {
        private JComboBox filterSelect;
        private JPanel mainPanel;
        private JComponent panel;
        private JLabel selectLabel;

        public AddFilterControl(List<? extends FilterComponentCreator> filterComponents) {
            this.filterSelect = UIUtil.createComboBox(filterComponents.toArray());
            this.filterSelect.setSelectedIndex(-1);
            this.filterSelect.setOpaque(false);
            this.selectLabel = new JLabel("Add a filter: ");
            this.panel = new JPanel();
            this.panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.panel.setLayout(new GridBagLayout());
            this.panel.add((Component)this.selectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.filterSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.filterSelect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    FilterComponentCreator selectedFilterComponent = (FilterComponentCreator)AddFilterControl.this.filterSelect.getSelectedItem();
                    AddFilterControl.this.addFilter(selectedFilterComponent.createFilterComponent(), true);
                }
            });
            this.mainPanel = new JPanel(new FlowLayout(3));
            this.mainPanel.add(this.panel);
        }

        public void addFilter(final FilterComponent fc, boolean add) {
            FilterPanel.this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
            final CloseablePanel closeablePanel = new CloseablePanel(fc.getComponent(), fc.toString(), true);
            closeablePanel.getEnabledCheckBox().setSelected(true);
            ActionListener deleteActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterPanel.this.filtersPanel.remove(closeablePanel.getComponent());
                    FilterPanel.this.combinedFilter.remove(fc.getFilter());
                    FilterPanel.this.filtersPanel.revalidate();
                    FilterPanel.this.filtersPanel.repaint();
                }
            };
            closeablePanel.addEnabledActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox source = (JCheckBox)e.getSource();
                    fc.getFilter().setEnabled(source.isSelected());
                }
            });
            closeablePanel.addCloseActionListener(deleteActionListener);
            FilterPanel.this.filtersPanel.add(closeablePanel.getComponent(), FilterPanel.this.cc.xy(1, FilterPanel.this.formLayout.getRowCount()));
            if (add) {
                FilterPanel.this.combinedFilter.add(fc.getFilter());
            }
            FilterPanel.this.filtersPanel.revalidate();
            FilterPanel.this.filtersPanel.repaint();
            this.filterSelect.setSelectedItem(null);
        }

        public JComponent getComponent() {
            return this.mainPanel;
        }
    }
}

