/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.google.common.base.Function;
import java.util.Collection;
import org.broadinstitute.genee.filter.CheckBoxListFilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.matrix.Vector;

public class GeneSetFilterUI
extends CheckBoxListFilterUI {
    public GeneSetFilterUI(String filterName, Collection<GeneSet> geneSets, Function stringToValueConverter) {
        super(filterName, geneSets, (Function<String, Object>)stringToValueConverter);
    }

    @Override
    public IndexedFilter apply() {
        this.filterSelectionComponent.saveState();
        this.selectedValuesSet = this.filterSelectionComponent.getSelectedItems();
        return new GeneSetIndexedFilter();
    }

    private class GeneSetIndexedFilter
    implements IndexedFilter {
        private Vector filterValueProvider;

        private GeneSetIndexedFilter() {
        }

        @Override
        public void setValueProvider(Vector filterValueProvider) {
            this.filterValueProvider = filterValueProvider;
        }

        @Override
        public boolean accept(int index) {
            String gene = (String)this.filterValueProvider.getValue(index);
            for (Object geneSet : GeneSetFilterUI.this.selectedValuesSet) {
                GeneSet set = (GeneSet)geneSet;
                if (!set.contains(gene)) continue;
                return true;
            }
            return false;
        }
    }
}

