/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import java.awt.Component;
import java.util.Comparator;
import javax.swing.JTabbedPane;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.filter.RangeFilterUI;
import org.broadinstitute.genee.filter.TopFilterUI;
import org.broadinstitute.genee.gui.UIUtil;

public class NumberFilterUI<T>
implements FilterUI {
    private String filterName;
    private RangeFilterUI rangeFilterUI;
    private JTabbedPane tabbedPane;
    private TopFilterUI topFilterUI;

    public NumberFilterUI(String filterName, float min, float max) {
        this.filterName = filterName;
        this.tabbedPane = UIUtil.createTabbedPane();
        this.rangeFilterUI = new RangeFilterUI(filterName, min, max);
        this.topFilterUI = new TopFilterUI(filterName, new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                return Float.compare(o1.floatValue(), o2.floatValue());
            }
        });
        this.tabbedPane.addTab("Range", this.rangeFilterUI.getUserInterfaceComponent());
        this.tabbedPane.addTab("Top", this.topFilterUI.getUserInterfaceComponent());
    }

    @Override
    public IndexedFilter apply() {
        return this.tabbedPane.getSelectedIndex() == 0 ? this.rangeFilterUI.apply() : this.topFilterUI.apply();
    }

    @Override
    public void cancel() {
        this.rangeFilterUI.cancel();
        this.topFilterUI.cancel();
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public Component getUserInterfaceComponent() {
        return this.tabbedPane;
    }
}

