/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.filter.RangeIndexedFilter;
import org.broadinstitute.genee.filter.RangeSlider;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;

public class RangeFilterUI<T>
implements FilterUI {
    private String filterName;
    private JPanel mainPanel;
    private JTextField maxTextField;
    private JTextField minTextField;
    private RangeSlider rangeSlider;
    private float savedMax;
    private float savedMin;
    private boolean setMaxValueFromTextField;
    private boolean setMinValueFromTextField;

    public RangeFilterUI(String filterName, float min, float max) {
        this.filterName = filterName;
        this.savedMin = min;
        this.savedMax = max;
        JPanel topPanel = new JPanel((LayoutManager)new FormLayout("left:p:g, 10px, right:p:g", "p"));
        this.minTextField = new JTextField(22);
        this.maxTextField = new JTextField(22);
        this.minTextField.setText(Formatter.format(min));
        this.maxTextField.setText(Formatter.format(max));
        CellConstraints cc = new CellConstraints();
        topPanel.add((Component)this.minTextField, cc.xy(1, 1));
        topPanel.add((Component)this.maxTextField, cc.xy(3, 1));
        this.rangeSlider = new RangeSlider(min, max);
        this.rangeSlider.addPropertyChangeListener("minValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RangeFilterUI.this.minTextField.setText(Formatter.format(RangeFilterUI.this.rangeSlider.getMinValue()));
                RangeFilterUI.this.setMinValueFromTextField = false;
            }
        });
        this.rangeSlider.addPropertyChangeListener("maxValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RangeFilterUI.this.maxTextField.setText(Formatter.format(RangeFilterUI.this.rangeSlider.getMaxValue()));
                RangeFilterUI.this.setMaxValueFromTextField = false;
            }
        });
        this.minTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                RangeFilterUI.this.setMinValueFromTextField = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RangeFilterUI.this.setMinValueFromTextField = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RangeFilterUI.this.setMinValueFromTextField = true;
            }
        });
        this.maxTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                RangeFilterUI.this.setMaxValueFromTextField = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RangeFilterUI.this.setMaxValueFromTextField = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RangeFilterUI.this.setMaxValueFromTextField = true;
            }
        });
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)topPanel, "North");
        this.mainPanel.add(this.rangeSlider);
    }

    @Override
    public IndexedFilter apply() {
        if (this.setMinValueFromTextField) {
            float min = 0.0f;
            try {
                min = ParserHelper.parseFloat(this.minTextField.getText().trim());
            }
            catch (Exception x) {
                // empty catch block
            }
            this.setMinValueFromTextField = false;
            this.rangeSlider.setMinValue(min);
        }
        if (this.setMaxValueFromTextField) {
            float max = 0.0f;
            try {
                max = ParserHelper.parseFloat(this.maxTextField.getText().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setMaxValueFromTextField = false;
            this.rangeSlider.setMaxValue(max);
        }
        this.savedMin = this.rangeSlider.getMinValue();
        this.savedMax = this.rangeSlider.getMaxValue();
        return new RangeIndexedFilter(this.savedMin, this.savedMax);
    }

    @Override
    public void cancel() {
        this.rangeSlider.setMinValue(this.savedMin);
        this.rangeSlider.setMaxValue(this.savedMax);
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public Component getUserInterfaceComponent() {
        return this.mainPanel;
    }
}

