/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import chemaxon.struc.Molecule;
import java.awt.Component;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.filter.TanimotoIndexedFilter;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Vector;

public class TanimotoFilterComponent
implements FilterUI {
    private JCheckBox excludeSampleCheckBox;
    private JTextField highTextField;
    private JTextField lowTextField;
    private String lastMoleculeName;
    private JTextField moleculeNameTextField;
    private TanimotoIndexedFilter tanimotoFilter;
    private JPanel panel;
    private boolean exclude;
    private String lowText;
    private String highText;
    private String moleculeName;
    private Vector compoundNameProvider;
    private Vector moleculeProvider;

    public TanimotoFilterComponent(final Vector compoundNameProvider, Vector moleculeProvider) {
        this.compoundNameProvider = compoundNameProvider;
        this.moleculeProvider = moleculeProvider;
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Pertubagen:");
        this.moleculeNameTextField = new JTextField(20);
        new DelimListDataIntelliHints(this.moleculeNameTextField){

            @Override
            public Collection<String> getMatches(String text) {
                boolean caseSensitive = this.isCaseSensitive();
                TreeSet<String> matches = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                int size = compoundNameProvider.size();
                for (int i = 0; i < size; ++i) {
                    String id;
                    String _id = id = (String)compoundNameProvider.getValue(i);
                    if (!caseSensitive) {
                        _id = _id.toLowerCase();
                    }
                    if (!_id.startsWith(text)) continue;
                    matches.add(id);
                }
                return matches;
            }
        };
        formBuilder.add(this.moleculeNameTextField);
        formBuilder.nextRow();
        this.lowTextField = new JTextField(12);
        this.lowTextField.setText("0");
        formBuilder.addLabel("Minimum distance:");
        formBuilder.add(this.lowTextField);
        this.highTextField = new JTextField(12);
        this.highTextField.setText("0.2");
        formBuilder.nextRow();
        formBuilder.addLabel("Maximum distance:");
        formBuilder.add(this.highTextField);
        formBuilder.nextRow();
        this.excludeSampleCheckBox = new JCheckBox("Exclude identical compounds", true);
        formBuilder.add(this.excludeSampleCheckBox);
        formBuilder.nextRow();
        this.panel = formBuilder.getPanel();
        this.exclude = this.excludeSampleCheckBox.isSelected();
        this.lowText = this.lowTextField.getText().trim();
        this.highText = this.highTextField.getText().trim();
    }

    @Override
    public IndexedFilter apply() {
        try {
            this.exclude = this.excludeSampleCheckBox.isSelected();
            this.lowText = this.lowTextField.getText().trim();
            this.highText = this.highTextField.getText().trim();
            this.moleculeName = this.moleculeNameTextField.getText().trim();
            float min = ParserHelper.parseFloat(this.lowText);
            float max = ParserHelper.parseFloat(this.highText);
            if (!this.moleculeName.equals(this.lastMoleculeName)) {
                Molecule m = null;
                int size = this.compoundNameProvider.size();
                for (int i = 0; i < size; ++i) {
                    if (!this.moleculeName.equalsIgnoreCase((String)this.compoundNameProvider.getValue(i))) continue;
                    m = (Molecule)this.moleculeProvider.getValue(i);
                    break;
                }
                this.lastMoleculeName = this.moleculeName;
                this.tanimotoFilter = new TanimotoIndexedFilter(this.lastMoleculeName, m);
            }
            this.tanimotoFilter.setMinDistance(min);
            this.tanimotoFilter.setMaxDistance(max);
            this.tanimotoFilter.setExcludeSame(this.exclude);
            return this.tanimotoFilter;
        }
        catch (Exception nfe) {
            return null;
        }
    }

    @Override
    public Component getUserInterfaceComponent() {
        return this.panel;
    }

    @Override
    public String getFilterName() {
        return "Compound Structure";
    }

    @Override
    public void cancel() {
        this.excludeSampleCheckBox.setSelected(this.exclude);
        this.lowTextField.setText(this.lowText);
        this.highTextField.setText(this.highText);
        this.moleculeNameTextField.setText(this.moleculeName);
    }
}

