/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.filter.FilterComponent;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.gui.TextComponentListener;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class TextFilterComponent
extends JPanel
implements FilterComponent {
    private Filters.TextFilter filter;

    public TextFilterComponent(final Filters.TextFilter filter) {
        this.filter = filter;
        final JComboBox comparisonComboBox = UIUtil.createComboBox(new Object[]{"contains", "exact match"});
        comparisonComboBox.setSelectedIndex(0);
        comparisonComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                filter.setMatchMode(comparisonComboBox.getSelectedIndex() == 0 ? 0 : 3);
            }
        });
        CellConstraints cc = new CellConstraints();
        final JTextField valueTextComponent = new JTextField(14);
        new TextComponentListener(valueTextComponent, 500){

            @Override
            protected void update() {
                String text = valueTextComponent.getText();
                if (text != null) {
                    text = text.trim();
                }
                filter.setText(text);
            }
        };
        final JComboBox columnComboBox = UIUtil.createComboBox();
        Project project = Application.getProject();
        if (project != null) {
            List<String> columns = MetadataUtil.getColumnNames(project.getOriginalDataset().getRowMetadata(), String.class);
            for (String s : columns) {
                columnComboBox.addItem(s);
            }
        }
        columnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                filter.setMetadataColumnName((String)columnComboBox.getSelectedItem());
            }
        });
        columnComboBox.setSelectedIndex(0);
        final JCheckBox caseSensitiveCheckBox = new JCheckBox("Case sensitive", false);
        caseSensitiveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                filter.setCaseSensitive(caseSensitiveCheckBox.isSelected());
            }
        });
        FormLayout fl = new FormLayout(UIUtil.createColumnStringForFormLayout(5), "p, 6px, p");
        this.setLayout((LayoutManager)fl);
        this.add((Component)columnComboBox, cc.xy(1, 1));
        this.add((Component)comparisonComboBox, cc.xy(3, 1));
        this.add((Component)valueTextComponent, cc.xy(5, 1));
        this.add((Component)caseSensitiveCheckBox, cc.xyw(1, 3, fl.getColumnCount()));
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public String toString() {
        return "Text";
    }
}

