/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gsea;

import com.enterprisedt.net.ftp.FTPException;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gsea.MSigDBGeneSetSelectorPanel;
import org.broadinstitute.genee.gui.FTPFile;
import org.broadinstitute.genee.gui.FTPFileModel;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSet;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSetMatrix;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;

public class GeneSetMatrixParameterInput
extends JTabbedPane
implements InputParameter<Object[]> {
    static String latestVersion;
    static FTPFile[] msigDBFileNames;
    private MSigDBGeneSetSelectorPanel msigDBPanel;
    private List<File> selectedFiles = new ArrayList<File>();
    private JTextArea selectedFilesTextArea;
    private JTextArea textEntryTextArea;

    public GeneSetMatrixParameterInput() {
        this.putClientProperty("Quaqua.TabbedPane.shortenTabs", false);
        this.msigDBPanel = new MSigDBGeneSetSelectorPanel();
        this.addTab("MSigDB Website", this.msigDBPanel);
        JButton browseButton = new JButton("Browse\u2026");
        this.selectedFilesTextArea = new JTextArea(10, 20);
        UIUtil.setLabelProperties(this.selectedFilesTextArea);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] files = FileChooserUtil.showMultiSelectOpenDialog(GeneSetMatrixParameterInput.this, "Select Gene Set File(s)");
                if (files != null) {
                    GeneSetMatrixParameterInput.this.selectedFiles.clear();
                    for (File f : files) {
                        GeneSetMatrixParameterInput.this.selectedFiles.add(f);
                    }
                    GeneSetMatrixParameterInput.this.selectedFilesTextArea.setText(ToStringUtil.toString(GeneSetMatrixParameterInput.this.selectedFiles, "\n"));
                }
            }
        });
        CellConstraints cc = new CellConstraints();
        JPanel tmp = new JPanel(new FlowLayout(3));
        tmp.add(browseButton);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)tmp, "North");
        JPanel localFilesPanel = new JPanel((LayoutManager)new FormLayout("p:g", "p:g, 6px, p:g"));
        localFilesPanel.add((Component)UIUtil.createNoBorderScrollPane(this.selectedFilesTextArea), cc.xy(1, 3));
        p.add(localFilesPanel);
        this.addTab("Local File(s)", p);
        JPanel textEntryPanel = new JPanel(new BorderLayout());
        textEntryPanel.add((Component)new JLabel("Enter one feature per line:"), "North");
        this.textEntryTextArea = new JTextArea(10, 60);
        textEntryPanel.add(UIUtil.createNoBorderScrollPane(this.textEntryTextArea));
        this.addTab("Text Entry", textEntryPanel);
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public Object[] getParameterValue() {
        int tabIndex = this.getSelectedIndex();
        if (tabIndex == 0 || tabIndex == 1) {
            Object[] selection = null;
            if (tabIndex == 0) {
                selection = this.msigDBPanel.getSelectedValues();
            } else {
                selection = new Object[this.selectedFiles.size()];
                for (int i = 0; i < selection.length; ++i) {
                    selection[i] = this.selectedFiles.get(i);
                }
            }
            return selection;
        }
        return new Object[]{this.textEntryTextArea.getText().trim()};
    }

    @Override
    public Class<?> getValueClass() {
        return Object[].class;
    }

    public void init() {
        this.msigDBPanel.init();
    }

    @Override
    public void init(Object value) {
    }

    @Override
    public void setValueFromString(String s) {
        String[] tokens = s.split("\n");
        StringBuilder files = new StringBuilder();
        HashSet<String> geneSetUrls = new HashSet<String>();
        for (String token : tokens) {
            if (token.startsWith("ftp://")) {
                geneSetUrls.add(token);
                continue;
            }
            if (new File(token).exists()) {
                if (files.length() > 0) {
                    files.append("\n");
                }
                files.append(IOUtil.getPath(new File(token)));
                continue;
            }
            this.textEntryTextArea.setText(token.replace(',', '\n'));
        }
        if (files.length() > 0) {
            this.selectedFilesTextArea.setText(files.toString());
        }
        if (geneSetUrls.size() > 0) {
            this.msigDBPanel.setSelectedByURL(geneSetUrls);
        }
    }

    public static File getCacheDir() {
        File cacheDir = new File(Application.getGENEEDir(), "MSigDB");
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir;
    }

    public static GeneSet[] getGeneSets(Object[] selection) {
        Object[] array = new Object[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            if (selection[i] instanceof FTPFile) {
                FTPFile ftpFile = (FTPFile)selection[i];
                File cacheDir = GeneSetMatrixParameterInput.getCacheDir();
                File geneSetFile = null;
                if (new File(cacheDir, ftpFile.getName()).exists()) {
                    geneSetFile = new File(cacheDir, ftpFile.getName());
                } else {
                    try {
                        geneSetFile = new File(cacheDir, ftpFile.getName());
                        FTPFileModel.mSigDBDownload(geneSetFile, ftpFile.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("Unable to download " + ftpFile.getName() + ".");
                    }
                }
                try {
                    array[i] = GeneSetIO.readGeneSetMatrix(geneSetFile);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Unable to parse " + geneSetFile.getName() + ".");
                }
            }
            if (selection[i] instanceof File) {
                File file = (File)selection[i];
                try {
                    if (file.getName().toLowerCase().endsWith(".gmt")) {
                        array[i] = GeneSetIO.readGeneSetMatrix(file);
                        continue;
                    }
                    array[i] = GeneSetIO.readGeneSetMatrix(file);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to parse " + file.getName() + ".");
                }
            }
            DefaultGeneSet set = new DefaultGeneSet("Text Entry", GeneSetMatrixParameterInput.getMembers((String)selection[i]));
            array[i] = new DefaultGeneSetMatrix("Text Entry", Arrays.asList(set));
        }
        return GeneSetMatrixParameterInput.convert(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createMSigDBFilenames() {
        if (msigDBFileNames != null) {
            return;
        }
        FTPFileModel model = null;
        try {
            int endIndex;
            int i;
            model = FTPFileModel.createMSigDBInstance();
            String[] names = model.getFileNames();
            if (names != null) {
                Arrays.sort(names, Collections.reverseOrder(new GeneSetsFromFTPSiteComparator()));
            }
            latestVersion = names[0];
            for (i = endIndex = latestVersion.indexOf(".symbols.gmt"); i >= 0; --i) {
                if (latestVersion.charAt(i) != 'v') continue;
                latestVersion = latestVersion.substring(i, endIndex);
                break;
            }
            msigDBFileNames = new FTPFile[names.length];
            int length = names.length;
            for (i = 0; i < length; ++i) {
                GeneSetMatrixParameterInput.msigDBFileNames[i] = new FTPFile(model.getHost(), model.getDir(), names[i]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                if (model != null) {
                    model.quit();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (FTPException e) {
                e.printStackTrace();
            }
        }
    }

    private static GeneSet[] convert(Object[] objs) {
        ArrayList<GeneSet> gsets = new ArrayList<GeneSet>();
        for (Object obj : objs) {
            if (obj instanceof GeneSetMatrix) {
                gsets.addAll(((GeneSetMatrix)obj).getGeneSets());
                continue;
            }
            if (obj instanceof GeneSet) {
                gsets.add((GeneSet)obj);
                continue;
            }
            throw new IllegalArgumentException("Unknown object: " + obj.getClass());
        }
        return gsets.toArray(new GeneSet[gsets.size()]);
    }

    private static Set<String> getMembers(String text) {
        HashSet<String> members = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token == null || (token = token.trim()).equals("")) continue;
            members.add(token);
        }
        return members;
    }

    public static class GeneSetsFromFTPSiteRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof FTPFile) {
                String name = ((FTPFile)value).getName();
                String slc = (name = IOUtil.getBaseFileName(name)).toLowerCase();
                if (slc.indexOf("c1.") != -1) {
                    name = name + " [Positional]";
                } else if (slc.indexOf("c2.") != -1) {
                    name = name + " [Curated]";
                } else if (slc.indexOf("c3.") != -1) {
                    name = name + " [Motif]";
                } else if (slc.indexOf("c4.") != -1) {
                    name = name + " [Computational]";
                } else if (slc.indexOf("c5.") != -1) {
                    name = name + " [Gene ontology]";
                }
                if (!slc.contains(latestVersion)) {
                    this.setForeground(Color.GRAY);
                } else {
                    this.setForeground(Color.BLACK);
                }
                this.setText(name);
            }
            return this;
        }
    }

    public static class GeneSetsFromFTPSiteComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            int result = Float.compare(this.getVersion(s1), this.getVersion(s2));
            if (result == 0) {
                return s1.compareToIgnoreCase(s2);
            }
            return result;
        }

        private float getVersion(String s) {
            int i1;
            for (int i = i1 = s.indexOf(".symbols.gmt"); i >= 0; --i) {
                if (s.charAt(i) != 'v') continue;
                return Float.parseFloat(s.substring(i + 1, i1));
            }
            return 0.0f;
        }
    }
}

