/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.broadinstitute.genee.category.VectorVisualMapper;
import org.broadinstitute.genee.gui.Highlighter;
import org.broadinstitute.genee.gui.JLabelFaded;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.AbstractIndexedQuickSearch;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public abstract class AbstractLegend
extends JPanel {
    private static final String GENEE_VALUE = "genee.value";
    protected Highlighter highlighter;
    protected Vector vector;
    protected VectorVisualMapper visualMapper;
    private Collection<Object> allValues;
    private CellConstraints cc;
    private Collection<Object> filteredValues;
    private FormLayout formLayout;
    private boolean keepHidden;
    private JLabel lastSelectedLabel;
    private SearchComponent searchComponent;

    public AbstractLegend(Highlighter highlighter) {
        this.highlighter = highlighter;
        this.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.cc = new CellConstraints();
        AbstractAction moveUp = new AbstractAction("moveUp"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLegend.this.changeSelection(true);
            }
        };
        AbstractAction moveDn = new AbstractAction("moveDn"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLegend.this.changeSelection(false);
            }
        };
        KeyStroke up = KeyStroke.getKeyStroke(38, 0);
        this.getInputMap(1).put(up, "moveUp");
        this.getInputMap().put(up, "moveUp");
        this.getActionMap().put("moveUp", moveUp);
        KeyStroke dn = KeyStroke.getKeyStroke(40, 0);
        this.getInputMap(1).put(dn, "moveDn");
        this.getInputMap().put(dn, "moveDn");
        this.getActionMap().put("moveDn", moveDn);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AbstractLegend.this.highlighter.clearHighlighted();
                AbstractLegend.this.createLegend();
            }
        });
        this.searchComponent = new SearchComponent();
        this.setVisible(false);
    }

    public void createLegend() {
        this.removeAll();
        this.formLayout = new FormLayout("p", "");
        this.setLayout((LayoutManager)this.formLayout);
        if (this.filteredValues != null) {
            this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
            this.add((Component)((Object)this.searchComponent), this.cc.xy(1, this.formLayout.getRowCount()));
            this.formLayout.appendRow(UIUtil.decodeRowSpec("2px"));
            boolean highlightedColorsEmpty = this.highlighter == null ? true : this.highlighter.isHighlightedEmpty();
            for (Object value : this.filteredValues) {
                boolean faded;
                boolean bl = this.highlighter == null ? false : (faded = !highlightedColorsEmpty && !this.highlighter.isHighlighted(value));
                boolean highlighted = this.highlighter == null ? false : !highlightedColorsEmpty && this.highlighter.isHighlighted(value);
                JLabel label = this.createLabel(faded, highlighted, value);
                label.setIcon(this.createIcon(value));
                if (value != null) {
                    label.setText(Formatter.toString(value));
                }
                this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
                this.add((Component)label, this.cc.xy(1, this.formLayout.getRowCount()));
            }
        }
        this.setVisible(this.allValues != null);
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension();
    }

    @Override
    public void print(Graphics g) {
        this.searchComponent.setVisible(false);
        super.print(g);
        this.searchComponent.setVisible(true);
    }

    public void setKeepHidden(boolean b) {
        this.keepHidden = b;
        this.setVisible(this.allValues != null);
    }

    public void setValues(Collection<Object> values) {
        this.allValues = values;
        this.filteredValues = values;
        this.searchComponent.getTextField().setText("");
        this.createLegend();
    }

    public void setVector(Vector vector) {
        this.vector = vector;
        this.setValues(vector == null ? null : VectorUtil.getValues(vector));
    }

    public void setVectorVisualMapper(VectorVisualMapper visualMapper) {
        this.visualMapper = visualMapper;
    }

    @Override
    public void setVisible(boolean visible) {
        visible = visible && !this.keepHidden;
        super.setVisible(visible);
    }

    protected abstract Icon createIcon(Object var1);

    protected abstract void showEditDialog(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSelection(boolean up) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int index = -1;
            Component[] components = this.getComponents();
            if (this.lastSelectedLabel != null) {
                int length = components.length;
                for (int i = 0; i < length; ++i) {
                    if (this.lastSelectedLabel != components[i]) continue;
                    index = i;
                    break;
                }
            }
            if (index == -1) {
                index = 1;
            } else {
                index = up ? --index : ++index;
                if (index < 1) {
                    index = components.length - 1;
                }
                if (index == components.length) {
                    index = 1;
                }
            }
            this.labelMousePressed((JLabel)components[index], false);
        }
    }

    private JLabel createLabel(boolean faded, boolean bolded, final Object value) {
        final JLabelFaded label = new JLabelFaded(faded);
        label.putClientProperty(GENEE_VALUE, value);
        if (bolded) {
            label.setFont(label.getFont().deriveFont(1));
        }
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() > 1 && !e.isConsumed()) {
                    AbstractLegend.this.showEditDialog(value);
                } else {
                    boolean additional = e.isShiftDown();
                    AbstractLegend.this.labelMousePressed(label, additional);
                }
            }
        });
        return label;
    }

    private void labelMousePressed(JLabel label, boolean additional) {
        this.lastSelectedLabel = label;
        if (this.highlighter != null) {
            Object value = label.getClientProperty(GENEE_VALUE);
            boolean bolded = label.getFont().isBold();
            if (!bolded) {
                this.highlighter.addHighlighted(value, !additional);
            } else if (!additional) {
                this.highlighter.clearHighlighted();
            } else {
                this.highlighter.removeHighlighted(value);
            }
            this.updateLegend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLegend() {
        boolean highlightedColorsEmpty = this.highlighter == null ? true : this.highlighter.isHighlightedEmpty();
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] components;
            for (Component c : components = this.getComponents()) {
                boolean faded;
                if (!(c instanceof JLabel)) continue;
                JLabelFaded label = (JLabelFaded)c;
                Object value = label.getClientProperty(GENEE_VALUE);
                boolean bl = this.highlighter == null ? false : (faded = !highlightedColorsEmpty && !this.highlighter.isHighlighted(value));
                boolean highlighted = this.highlighter == null ? false : !highlightedColorsEmpty && this.highlighter.isHighlighted(value);
                label.setFaded(faded);
                label.setFont(highlighted ? label.getFont().deriveFont(1) : label.getFont().deriveFont(0));
            }
        }
    }

    private class SearchComponent
    extends AbstractIndexedQuickSearch {
        private SearchComponent() {
        }

        @Override
        protected LuceneSearchParser.SearchPredicateAdapterCreator createSearchPredicateAdapterCreator() {
            return new LuceneSearchParser.SearchPredicateAdapterCreator(){

                @Override
                public LuceneSearchParser.IndexedSearchPredicate create(LuceneSearchParser.InternalSearchPredicate internalSearchPredicate) {
                    return new LuceneSearchParser.ListModelSearchPredicateAdapter(internalSearchPredicate);
                }
            };
        }

        @Override
        protected Collection<String> getAvailableFieldNames() {
            return null;
        }

        @Override
        protected String getSavedSearchKey() {
            return null;
        }

        @Override
        protected void notifyFilterChanged() {
            if (this.searchPredicate != null) {
                int i = 0;
                AbstractLegend.this.filteredValues = new ArrayList();
                final Iterator it = AbstractLegend.this.allValues.iterator();
                this.searchPredicate.setData(new ListModel(){

                    @Override
                    public void addListDataListener(ListDataListener l) {
                    }

                    public Object getElementAt(int index) {
                        return it.next();
                    }

                    @Override
                    public int getSize() {
                        return AbstractLegend.this.allValues.size();
                    }

                    @Override
                    public void removeListDataListener(ListDataListener l) {
                    }
                });
                for (Object value : AbstractLegend.this.allValues) {
                    if (this.searchPredicate.accept(i)) {
                        AbstractLegend.this.filteredValues.add(value);
                    }
                    ++i;
                }
                this.setLabelText(AbstractLegend.this.filteredValues.size(), AbstractLegend.this.allValues.size());
            } else {
                AbstractLegend.this.filteredValues = AbstractLegend.this.allValues;
                this.clearLabelText();
            }
            AbstractLegend.this.createLegend();
        }
    }
}

