/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JPanel;
import org.broadinstitute.genee.gui.CartesianProduct;
import org.broadinstitute.genee.gui.TextSpanPair;
import org.broadinstitute.genee.gui.UIUtil;

public class CartesianProductHeader
extends JPanel {
    private CartesianProduct product;
    private boolean xAxis;
    private int gridSize = 0;
    private boolean rotated;
    private int leftBorder;
    private int rightBorder;
    private int minorSpacing;

    public CartesianProductHeader(CartesianProduct product, boolean xAxis) {
        this.product = product;
        this.xAxis = xAxis;
        this.rotated = !xAxis;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
    }

    @Override
    public void print(Graphics g) {
        Container parent = this.getParent();
        Color savedBackground = this.getBackground();
        if (parent != null) {
            this.setBackground(parent.getBackground());
        }
        super.print(g);
        this.setBackground(savedBackground);
    }

    public void layoutLabels() {
        List<TextSpanPair>[] names;
        this.removeAll();
        List<TextSpanPair>[] listArray = names = this.xAxis ? this.product.getColumnNames() : this.product.getRowNames();
        if (names == null) {
            names = new List[]{};
        }
        int groupBy = this.xAxis ? this.product.getGroupColumnsByCount() : this.product.getGroupRowsByCount();
        StringBuilder xyString = new StringBuilder();
        xyString.append(this.leftBorder).append("px, ");
        if (this.gridSize == 0 || names.length == 0) {
            xyString.append("p");
        } else {
            xyString.append(UIUtil.createStringForFormLayout(this.minorSpacing + "px", this.gridSize + "px", names.length));
        }
        xyString.append(", ").append(this.rightBorder).append("px");
        if (this.xAxis) {
            this.setLayout((LayoutManager)new FormLayout(xyString.toString(), UIUtil.rep("bottom:p", groupBy == 0 ? 1 : groupBy, ",")));
        } else {
            this.setLayout((LayoutManager)new FormLayout(groupBy == 0 ? "p" : UIUtil.rep("p", groupBy, ","), xyString.toString()));
        }
        CellConstraints cc = new CellConstraints();
        if (names != null) {
            int gridIndex = 0;
            int xy = 2;
            while (gridIndex < names.length) {
                List<TextSpanPair> pairs = names[gridIndex];
                for (int pairIndex = 0; pairIndex < pairs.size(); ++pairIndex) {
                    int span;
                    TextSpanPair pair = pairs.get(pairIndex);
                    if (pair.getSpan() < 1) continue;
                    JideLabel label = new JideLabel(pair.getText());
                    label.setHorizontalAlignment(0);
                    label.setToolTipText(pair.getText());
                    if (this.rotated) {
                        label.setOrientation(1);
                        label.setClockwise(false);
                    }
                    if ((span = pair.getSpan()) > 1) {
                        span += span - 1;
                    }
                    if (this.xAxis) {
                        this.add((Component)label, cc.xywh(xy, pairIndex + 1, span, 1));
                        continue;
                    }
                    this.add((Component)label, cc.xywh(pairIndex + 1, xy, 1, span));
                }
                ++gridIndex;
                xy += 2;
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip(this);
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setLeftBorder(int leftBorder) {
        this.leftBorder = leftBorder;
    }

    public void setMinorSpacing(int minorSpacing) {
        this.minorSpacing = minorSpacing;
    }

    public void setRightBorder(int rightBorder) {
        this.rightBorder = rightBorder;
    }

    public void setRotated(boolean b) {
        this.rotated = b;
    }
}

