/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.CollapsiblePanes;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.MultiComparisonComponent;
import org.broadinstitute.genee.gui.parameters.TwoClassComparison;
import org.broadinstitute.genee.heatmap.Project;

public class ClassInputPanel {
    private JComponent component;
    private CollapsiblePanes collapsiblePanes = new CollapsiblePanes();
    private Project project;

    public ClassInputPanel() {
        this.collapsiblePanes.setGap(0);
        this.collapsiblePanes.setBackground(UIManager.getColor("Panel.background"));
        this.collapsiblePanes.addExpansion();
        if (!GraphicsEnvironment.isHeadless()) {
            this.collapsiblePanes.add((Component)((Object)new MyCollapsiblePane()));
        }
        this.component = this.collapsiblePanes;
    }

    public JComponent getJComponent() {
        return this.component;
    }

    public TwoClassComparison[] getTwoClassComparison() {
        ArrayList<TwoClassComparison> comparisons = new ArrayList<TwoClassComparison>();
        int cc = this.collapsiblePanes.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            TwoClassComparison[] tmp;
            Component c = this.collapsiblePanes.getComponent(i);
            if (!(c instanceof MyCollapsiblePane) || (tmp = ((MyCollapsiblePane)((Object)c)).multiComparisonComponent.getTwoClassComparisons()) == null || tmp.length <= 0) continue;
            comparisons.addAll(Arrays.asList(tmp));
        }
        return comparisons.toArray(new TwoClassComparison[0]);
    }

    public void setProject(Project project) {
        this.project = project;
        int cc = this.collapsiblePanes.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = this.collapsiblePanes.getComponent(i);
            if (!(c instanceof MyCollapsiblePane)) continue;
            ((MyCollapsiblePane)((Object)c)).multiComparisonComponent.setProject(project);
        }
    }

    private void setIndices() {
        MyCollapsiblePane p = null;
        int index = 0;
        int cc = this.collapsiblePanes.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = this.collapsiblePanes.getComponent(i);
            if (!(c instanceof MyCollapsiblePane)) continue;
            ((MyCollapsiblePane)((Object)c)).setIndex(index++);
            if (index != 1) continue;
            p = (MyCollapsiblePane)((Object)c);
        }
        if (index > 1) {
            p.setEnableDelete(true);
        }
    }

    private class MyCollapsiblePane
    extends CollapsiblePane {
        private JPanel panel;
        private JButton deleteButton;
        private JButton addButton;
        private MultiComparisonComponent multiComparisonComponent;

        private MyCollapsiblePane() {
            super("Comparison 1");
            this.panel = new JPanel(new FlowLayout(0));
            this.panel.setOpaque(false);
            this.deleteButton = new JButton(IconManager.loadIcon("16x16/14763.delete.gif"));
            this.deleteButton.setToolTipText("Delete comparison");
            this.deleteButton.setEnabled(false);
            this.addButton = new JButton(IconManager.loadIcon("16x16/10551.add_exc.gif"));
            this.addButton.setToolTipText("Add another comparison");
            ActionListener addActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyCollapsiblePane pane = new MyCollapsiblePane();
                    pane.multiComparisonComponent.setProject(ClassInputPanel.this.project);
                    ClassInputPanel.this.collapsiblePanes.add((Component)((Object)pane));
                    ClassInputPanel.this.setIndices();
                    int cc = ClassInputPanel.this.collapsiblePanes.getComponentCount();
                    for (int i = 0; i < cc; ++i) {
                        Component c = ClassInputPanel.this.collapsiblePanes.getComponent(i);
                        if (!(c instanceof MyCollapsiblePane) || c == pane) continue;
                        try {
                            ((CollapsiblePane)c).setCollapsed(true);
                            continue;
                        }
                        catch (PropertyVetoException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            };
            this.addButton.addActionListener(addActionListener);
            ActionListener deleteActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClassInputPanel.this.collapsiblePanes.remove((Component)((Object)MyCollapsiblePane.this));
                    ClassInputPanel.this.collapsiblePanes.revalidate();
                    ClassInputPanel.this.setIndices();
                }
            };
            this.deleteButton.addActionListener(deleteActionListener);
            this.panel.add(this.addButton);
            this.panel.add(this.deleteButton);
            this.setTitleComponent(this.panel);
            this.setTitleLabelGap(0);
            this.setSteps(1);
            this.multiComparisonComponent = new MultiComparisonComponent();
            this.setContentPane(this.multiComparisonComponent.getJComponent());
        }

        public void setEnableDelete(boolean b) {
            this.deleteButton.setEnabled(b);
        }

        public void setIndex(int index) {
            this.setTitle("Comparison " + (index + 1));
            this.deleteButton.setEnabled(index > 0);
        }
    }
}

