/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.gui.RoundedBorder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.XIcon;

public class CloseablePanel
extends JPanel {
    private JButton closeButton = new JButton();
    private JLabel headerLabel;
    private JPanel headerPanel;
    private JPanel wrapPanel;
    private JCheckBox enabledCheckBox;

    public CloseablePanel(Component c, String text) {
        this(c, text, false);
    }

    public CloseablePanel(Component c, String title, boolean showEnabled) {
        this.closeButton.setOpaque(false);
        this.closeButton.setIcon(new XIcon());
        this.closeButton.setHorizontalAlignment(4);
        this.closeButton.setContentAreaFilled(false);
        this.enabledCheckBox = new JCheckBox("Enable", false);
        this.enabledCheckBox.setOpaque(false);
        this.headerLabel = new JLabel();
        this.headerLabel.setHorizontalAlignment(0);
        this.headerLabel.setText(title);
        this.headerPanel = new JPanel();
        this.headerPanel.setOpaque(false);
        UIUtil.setLabelProperties(this.closeButton);
        CellConstraints cc = new CellConstraints();
        this.headerPanel.setLayout(new BorderLayout());
        this.headerPanel.add((Component)this.headerLabel, "South");
        this.headerPanel.add((Component)this.closeButton, "East");
        if (showEnabled) {
            this.headerPanel.add((Component)this.enabledCheckBox, "West");
        }
        this.wrapPanel = new JPanel((LayoutManager)new FormLayout("p:g", "p:g, 10px, p"));
        RoundedBorder border = new RoundedBorder(UIUtil.LIGHT_BLUE, UIUtil.LIGHT_BLUE, Color.LIGHT_GRAY, 5, 0);
        this.wrapPanel.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.wrapPanel.add((Component)this.headerPanel, cc.xy(1, 1));
        this.wrapPanel.add(c, cc.xy(1, 3));
        this.setLayout(new BorderLayout());
        this.add(this.wrapPanel);
        this.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 0));
    }

    public void addCloseActionListener(ActionListener l) {
        this.closeButton.addActionListener(l);
    }

    public void addEnabledActionListener(ActionListener l) {
        this.enabledCheckBox.addActionListener(l);
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public Component getComponent() {
        return this;
    }

    public JCheckBox getEnabledCheckBox() {
        return this.enabledCheckBox;
    }

    @Override
    public boolean isEnabled() {
        return this.enabledCheckBox.isSelected();
    }
}

