/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Icon;

public class ColorByIcon
implements Icon {
    private Paint paint;
    private int size;
    private boolean isWhite = false;
    private boolean filled = true;

    public ColorByIcon(Paint paint) {
        this(paint, 12, true);
    }

    public ColorByIcon(Paint paint, boolean filled) {
        this(paint, 12, filled);
    }

    public ColorByIcon(Paint paint, int size) {
        this(paint, size, true);
    }

    public ColorByIcon(Paint paint, int size, boolean filled) {
        this.paint = paint;
        this.size = size;
        this.filled = filled;
        this.isWhite = paint.equals(Color.WHITE);
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.isWhite) {
            g2.setPaint(Color.BLACK);
            g2.drawRect(x, y, this.size, this.size);
        } else {
            g2.setPaint(this.paint);
            if (this.filled) {
                g2.fillRect(x, y, this.size, this.size);
            } else {
                g2.drawRect(x, y, this.size, this.size);
            }
        }
    }
}

