/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jidesoft.hints.ListDataIntelliHints;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.text.JTextComponent;

public abstract class DelimListDataIntelliHints
extends ListDataIntelliHints<String> {
    private char separatorChar = (char)32;

    public DelimListDataIntelliHints(JTextComponent textComponent) {
        super(textComponent, Collections.EMPTY_LIST);
    }

    public void acceptHint(Object obj) {
        if (obj == null) {
            return;
        }
        int caretPosition = this.getTextComponent().getCaretPosition();
        String hint = obj.toString();
        if (hint.indexOf(32) != -1) {
            hint = "\"" + hint + "\"";
        }
        char sep = this.separatorChar;
        String s1 = this.getTextComponent().getText();
        int sepToCaret = s1.lastIndexOf(sep, caretPosition - 1);
        String fromCaret = caretPosition != -1 ? s1.substring(caretPosition) : "";
        s1 = s1.substring(0, sepToCaret + 1);
        s1 = s1 + hint;
        s1 = s1 + fromCaret;
        this.getTextComponent().setText(s1);
        String text = this.getTextComponent().getText();
        int newCaretPos = text.indexOf(10, caretPosition);
        this.getTextComponent().setCaretPosition(newCaretPos != -1 ? newCaretPos : text.length());
    }

    public abstract Collection<String> getMatches(String var1);

    public boolean updateHints(Object context) {
        List matches;
        if (context == null) {
            return false;
        }
        String text = context.toString();
        if (!this.isCaseSensitive()) {
            text = text.toLowerCase();
        }
        try {
            matches = text.equals("") ? Collections.EMPTY_LIST : this.getMatches(text);
        }
        catch (Exception x) {
            x.printStackTrace();
            matches = Collections.emptyList();
        }
        Object[] matchesArray = matches.toArray(new String[0]);
        this.setListData(matchesArray);
        return matches.size() > 0;
    }

    protected JList createList() {
        JList list = super.createList();
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public void setText(String s) {
                if (s != null && s.length() > 60) {
                    s = s.substring(0, 59) + "\u2026";
                }
                super.setText(s);
            }
        });
        return list;
    }

    protected Object getContext() {
        int spaceIndex;
        String s = this.getTextComponent().getText();
        int caretPosition = this.getTextComponent().getCaretPosition();
        if (this.isMultilineTextComponent()) {
            if (caretPosition == 0) {
                s = "";
            } else {
                int carriageReturnIndex = s.lastIndexOf(10, caretPosition - 1);
                s = s.substring(carriageReturnIndex + 1, caretPosition);
            }
        }
        return (spaceIndex = s.lastIndexOf(this.separatorChar, caretPosition - 1)) != -1 ? s.substring(spaceIndex + 1, caretPosition) : s;
    }
}

